<?php

namespace App\Http\Controllers\API\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\{Mail, Hash};
use App\Models\{Client};
use App\Helpers\JsonResponse;
use App\Http\Requests\API\Auth\Member\{MemberPasswordRequest, 
    LoginRequest,MemberRequest,SendOtpRequest,
    ForgetPasswordGuestRequest,SendOtpForgetPasswordRequest,
    ChangePasswordRequest};
use App\Mail\SendEmailTest;


class MemberController extends Controller
{
    public function register(MemberRequest $request)
    {
        try {
            $client = Client::where('membership_number',$request->membership_number)->first();
            if ($client) {
                $otp = rand(1, 9999);
                Mail::to($client->email)
                    ->send(new SendEmailTest("Please Use this Code To Rest Your Password : " . $otp));
                $client->update(['otp' =>$otp]);
                return JsonResponse::respondSuccess(message:'Reset link sent to your email.');
            } else {
                return JsonResponse::respondSuccess(message:'invalid email');
            }
            } catch (\Exception $e) {
                return JsonResponse::respondError($e->getMessage());
            }
    }

    public function send_otp(SendOtpRequest $request)
    {
        try {
            $client = Client::where('otp', $request->otp)->first();
            if ($client) {
                return JsonResponse::respondSuccess(message:'Successful');
            } else {
                return JsonResponse::respondSuccess(message:'invalid Otp');
            }
            } catch (\Exception $e) {
                return JsonResponse::respondError($e->getMessage());
            }
    }

    public function createpassword(MemberPasswordRequest $request)
    {
        try {
            $otp = Client::where('otp', $request->otp)->first();
            if ($otp) {
                $client = Client::findOrFail($otp->id);
                $client->password = Hash::make($request->password);
                $client->type = 'member';
                $client->save();
                $token = $client->createToken('authToken')->accessToken;
                return JsonResponse::respondSuccess(token:$token,message:'Password Changed Successfully');
            }
            } catch (\Exception $e) {
                return JsonResponse::respondError($e->getMessage());
            }
    }

    public function login(LoginRequest $request)
    {
        try{ 
            if($request->type=='member'){
                $client=Client::firstWhere(['membership_number'=>$request->membership_number,'type'=>$request->type]);
                    if ($client) {
                        if (Hash::check($request->password, $client->password)) {
                            $token = $client->createToken('authToken')->accessToken;
                            return JsonResponse::respondSuccess(token:$token, message:'User login successfully.');
                        }else {
                            return JsonResponse::respondSuccess(message:'Password mismatch',status:422);
                        }
                    } else {
                        return JsonResponse::respondSuccess(message:'User does not exist',status:422);
                    }   
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }


    public function forgetPassword(ForgetPasswordGuestRequest $request)
    {
        
        try {
            if ($request->type == "member") {
                $client = Client::where('membership_number', $request->membership_number)->first();
                if ($client) {
                    $otp = rand(1, 9999);
                    $client->update(['otp' => $otp]);
                    Mail::to($client->email)
                        ->send(new SendEmailTest("Please Use this Code To Rest Your Password : " . $otp));
                    return JsonResponse::respondSuccess(message: 'Reset link sent to your email.');
                } else {
                    return JsonResponse::respondSuccess(message: 'invalid email');
                }
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function send_otp_forgetPassword(SendOtpForgetPasswordRequest $request)
    {
        try {
            $client = Client::where('otp', $request->otp)->first();
            if ($client) {
                return JsonResponse::respondSuccess(message: 'Successful');
            } else {
                return JsonResponse::respondSuccess(message: 'invalid Otp');
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function change_password(ChangePasswordRequest $request)
    {
        try {
            $otp = Client::where('otp', $request->otp)->first();
            if ($otp) {
                $client = Client::findOrFail($otp->id);
                $client->password = Hash::make($request->password);
                $client->update();
                return JsonResponse::respondSuccess(message: 'Password Changed Successfully');
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

}
