<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\Support\Facades\DB;
use App\Models\Role;
use App\Models\Country;
use App\Models\PhoneNumber;
use App\Models\Permission;
use Illuminate\Support\Facades\Validator;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */

    public function index()
    {
        $users = User::where('id', '!=', auth()->user()->id)
            ->where('created_by', '=', auth()->user()->id)->get();
        return view('users.index', compact('users'));
    }

    public function create()
    {
        // Get User Children
        $users = User::get();
        $CurrentUser = auth()->user();

        if ($CurrentUser->type == 'admin') {
            $UserChildren = User::get();
            $RoleChildren = Role::get();
            $permissions = Permission::get();
        } else {
            $UserChildren = array();
            foreach ($users as $user) {
                // dd($user);
                $parents = $user->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, [
                        'id' => $user->id,
                        'name' => $user->name
                    ]);
                }
            }
            // Get User Role Children
            $roles = Role::get();
            $CurrentRole = auth()->user()->role;
            $RoleChildren = array();

            foreach ($roles as $role) {
                // dd($user);
                $parents = $role->getParents()->pluck('id')->toArray();
                if (in_array($CurrentRole->id, $parents)) {
                    array_push($RoleChildren, [
                        'id' => $role->id,
                        'name' => $role->name
                    ]);
                }
            }

            // Get All Current User Permissions
            $CurrentUserPermissions = auth()->user()->permissions->pluck('name')->toArray();
            $CurrentRolePermissions = $CurrentRole->permissions->pluck('name')->toArray();

            $Allpermissions = array_merge($CurrentUserPermissions, $CurrentRolePermissions);
            $uniquePermissions = array_unique($Allpermissions);
            // dd($uniquePermissions);
            $permissions = array();

            for ($i = 0; $i < count($uniquePermissions); $i++) {

                $permission = Permission::where('name', $uniquePermissions[$i])->first();
                // dd($permission);
                array_push($permissions, [
                    'id' => $permission->id,
                    'name' => $permission->name,
                ]);
            }
        }

        $countries = Country::all();

        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event('Visited Users Creation Page')
            ->log('User (' . $CurrentUser->name . ') Visited Users Creation Page');


        return view('users.create', compact('permissions', 'UserChildren', 'countries', 'RoleChildren'));
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'email' => 'required|unique:users,email',
            'mobile_number' => 'unique:phone_numbers,phone',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        // dd($request->assigned_to)
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'role_id' => $request->role_id,
            'password' => Hash::make($request->password),
            'created_by' => auth()->user()->id,
            'assigned_to' => $request->assigned_to
        ]);
        $user->attachRole($request->role_id);

        // event(new Registered($user));

        // Auth::login($user);         
        if ($request->permissions) {
            for ($i = 0; $i < count($request->permissions); $i++) {
                // dd($user);
                $user->attachPermission($request->permissions[$i]);
            }
        }

        if ($request->mobile_number) {
            $counts = count($request->mobile_number);
            for ($i = 0; $i < $counts; $i++) {
                $phones = new PhoneNumber();
                $phones->phone = $request->mobile_number[$i];
                $phones->user_id = $user->id;
                $phones->country_id = $request->country_id[$i];
                $phones->save();
            }
        }

        $userModel = new User();
        $CurrentUser = auth()->user();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event('Created User')
            ->log('User (' . $CurrentUser->name . ') Created Profile for user (' . $user->name . ') ');

        return redirect()->route('users.index')
            ->with('success', 'User Added successfully');
    }
}
