<?php

namespace App\Http\Controllers;

use App\Models\Batch;
use App\Models\Unit;
use App\Models\PaymentType;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
class BatchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($unitId)
    {
        //
        $unit = Unit::find($unitId);
        $totalPaid_unit = DB::table('batches')->where([ 'unit_id' => $unitId,'type' => 'total_unit','status' =>'paid'])->sum('amount');
        $totalPaid_maintenance = DB::table('batches')->where([ 'unit_id' => $unitId,'type' => 'maintenance', 'status' =>'paid'])->sum('amount');
        $totalRemaining_unit = DB::table('batches')->where([ 'unit_id' => $unitId,'type' => 'total_unit', 'status' =>'unpaid'])->sum('amount');
        $totalRemaining_maintenance = DB::table('batches')->where([ 'unit_id' => $unitId,'type' => 'maintenance', 'status' =>'unpaid'])->sum('amount');

        return view('batches.index',compact('unit', 'totalPaid_unit', 'totalPaid_maintenance', 'totalRemaining_unit', 'totalRemaining_maintenance'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($unitId)
    {
        //
        $unit = Unit::find($unitId);
        $paymentTypes = PaymentType::get();
        return view('batches.create',compact('unit', 'paymentTypes'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $unit = Unit::find($request->unitId);
        
        for($i=0; $i<count($request->type); $i++){
            $batch  = new Batch();
            if($unit->client){
                $batch->client_id = $unit->client->id;
            }
            $batch->unit_id = $request->unitId;
            $batch->type = $request->type[$i];
            $batch->title = $request->title[$i];
            $batch->amount = $request->amount[$i];
            $batch->date = $request->date[$i];
            $batch->save();

        }
        
        return redirect()->route('batches.index', $request->unitId)
                        ->with('success','batch created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function show(Batch $batch)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function edit(Batch $batch)
    {
        //
        $paymentTypes = PaymentType::get();
        
        return view('batches.edit', compact('batch', 'paymentTypes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Batch $batch)
    {
        //
        $batch->type = $request->type;
        $batch->title = $request->title;
        $batch->amount = $request->amount;
        $batch->date = $request->date;
        $batch->save();

        return redirect()->route('batches.index', $request->unitId)
                        ->with('success','batch updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Batch  $batch
     * @return \Illuminate\Http\Response
     */
    public function destroy(Batch $batch)
    {
        //
        $unit = $batch->unit;
        $batch->delete();
        return redirect()->route('batches.index', $unit->id)
                        ->with('success','batch deleted successfully');
    }

    public function SavePayment($batchId)
    {
        //
        // dd(auth()->user()->id);
        $batch = Batch::find($batchId);
        $user = auth()->user();
        $unit = $batch->unit->name;
        $batch->status = 'paid';
        $batch->user_id = auth()->user()->id;
        $batch->save();

        activity()
        ->performedOn($batch)
        ->causedBy($user)
        ->event('SavePayment')
        ->log($user->name .' marked batch (' . $batch->id . ') as paid for unit: '. $unit . ' Client:' . $batch->client->name);



       return redirect()->route('batches.index', $batch->unit->id)
                        ->with('success','batch marked as Paid successfully');
    }
}
