<?php

namespace App\Http\Controllers;

use PDF;
use Auth;
use Exception;
use Carbon\Carbon;
use App\Models\File;
use App\Models\Lead;
use App\Models\Unit;
use App\Models\User;
use App\Models\Batch;
use App\Models\Offer;
use App\Models\Client;
use App\Models\Source;
use App\Models\Stream;
use App\Models\Country;
use App\Models\Gallery;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Campaign;
use App\Models\Facility;
use App\Models\PhoneNumber;
use App\Models\FacilityUnit;
use Illuminate\Http\Request;
use App\Imports\ClientImport;
use App\Models\Notifications;
use App\Notifications\AssignUser;
use Illuminate\Support\Facades\DB;
use App\Imports\ClientSearchImport;
use App\Imports\ClientSourceImport;
use Illuminate\Support\Facades\Log;
use App\Http\Requests\ClientRequest;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;
use Spatie\Activitylog\Models\Activity;
use App\Http\Requests\UploadLeadRequest;
use App\Models\UnitPrice;
use Illuminate\Support\Facades\Notification;
use Symfony\Component\VarDumper\Caster\Caster;

// use App\Notifications\AssignUser;
// use Notification;


class ClientController extends Controller
{

    protected static $logName = 'custom_log_name_for_this_model';


    // public function __construct()
    // {
    //     $this->middleware('permission:clients-create',['only' => ['create', 'store']]);
    //     $this->middleware('permission:clients-read',['only' => ['show']]);
    //     $this->middleware('permission:clients-update',['only' => ['edit', 'update']]);
    //     $this->middleware('permission:clients-delete',['only' => ['destroy']]);
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // Log Activity
        activity()
            ->event('visit')
            ->log(auth()->user()->name . ' just Visited Clients index');
        // Clients with Filters
        $user = auth()->user();
        $clients = Client::query();
        $userClients = $user->accessed_clients->pluck('id')->toArray();
        // dd($user->role);
        $campaigns = Campaign::get();
        $sources = Source::get();
        $countries = Country::get();
        if ($user->type != 'admin' && !$user->role->hasPermission('clients-readAll')) {
            $clients->whereIn('id', $userClients);
        }

        if ($request->name) {
            $clients->where('name', 'LIKE', '%' . $request->name . '%');
        }

        if ($request->country_id) {
            $clients_id = PhoneNumber::where('country_id', $request->country_id)->where('client_id', '!=', NULL)->pluck('client_id')->toArray();
            $clients->whereIn('id', $clients_id);
        }

        if ($request->phone) {
            $clients_id = PhoneNumber::where('phone', 'LIKE', '%' . $request->phone . '%')->where('client_id', '!=', NULL)->pluck('client_id')->toArray();
            $clients->whereIn('id', $clients_id);
        }

        if ($request->time1 && $request->time2) {
            $clients->whereTime('created_at', '>=', $request->time1)
                ->whereTime('created_at', '<=', $request->time2);
        }

        if ($request->date1 && $request->date2) {
            $clients->whereDate('created_at', '>=', $request->date1)
                ->whereDate('created_at', '<=', $request->date2);
        }
        if ($request->campaign_id) {
            $clients->whereIn('campaign_id', $request->campaign_id);
        }

        if ($request->source_id) {
            $clients->whereIn('source_id', $request->source_id);
        }

        $totalClients = $clients->get();
        $clients = $clients->paginate(100)->withQueryString();

        // Max Number of phones
        $clientNumbers = 0;
        foreach ($clients as $client) {
            $maxCount = count($client->phone_numbers);
            if ($maxCount > $clientNumbers) {
                $clientNumbers = $maxCount;
            }
        }

        return view('clients.index', compact('clients', 'countries', 'clientNumbers', 'campaigns', 'sources', 'totalClients'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, $leadId)
    {
        $units = Unit::whereisActive(1)
            ->where('client_id', '=', null)
            ->get();
        $projects = Project::where('is_active', '1')->get();

        $users = User::get();
        // $campaigns = Campaign::get();
        // $sources = Source::get();
        $countries = Country::all();

        if (isset($leadId)) {
            $lead = Lead::find($leadId);
            $phones = PhoneNumber::where('lead_id', $leadId)->get();
            $user = auth()->user();
            activity()
                ->event('visit')
                ->log($user->name . ' just Visited Create Client Page');
            return view('clients.create', compact('users', 'lead', 'units', 'countries', 'phones', 'projects'));
        } else {
            return 404;
        }


        // return view('clients.create',compact('units','users','campaigns','countries', 'projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // try {
        //     DB::beginTransaction();
        $client = new Client();
        $client->lead_id = $request->leadId;
        $client->name = $request->name;
        $client->email = $request->email;
        $client->job_title = $request->job_title;
        $client->came_from = $request->came_from;
        $client->user_id = $request->user_id ? $request->user_id : Auth()->user()->id;
        $client->campaign_id = $request->campaign_id;
        $client->source_id = $request->source_id;
        $client->civil_date = $request->civil_date ?? '';
        $client->civil_city = $request->civil_city ?? '';
        $client->civil_number = $request->civil_number ?? '';
        $client->civil_address = $request->civil_address ?? '';
        $client->nationality = $request->nationality ?? '';
        $client->save();

        $lead = Lead::find($request->leadId);
        $lead->is_client = 1;
        $lead->client_id = $client->id;
        $lead->save();

        if ($request->mobile_number) {
            for ($i = 0; $i < count($request->mobile_number); $i++) {
                $phone = PhoneNumber::where('phone', $request->mobile_number[$i])->first();
                if (isset($phone)) {
                    $phone->client_id = $client->id;
                    $phone->save();
                }
            }
        }

        // Check if the mobile number filed has value or not

        $user = auth()->user();
        activity()
            ->event('Create')
            ->log($user->name . ' just Created New Client');
        DB::commit();
        return redirect()->route('clients.show', $client->id)->with('success', 'Client Created Successfully');
        // } catch (Exception $e) {
        //     Log::alert('Client Save Error', [$e->getMessage()]);
        //     return redirect()->back()->with('erroe', $e->getMessage());
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client)
    {
        $freeUnits = DB::table('units')->where('status', 'free')->count();
        $users = DB::table('users')->select('name', 'id')->get();
        $codes = Country::get();
        $streams = Stream::where('client_id', $client->id)->orderBy('created_at', 'Desc')->get();
        $clientUsers  = $client->accessed_users->pluck('id')->toArray();
        // dd($clientUsers);
        $user = auth()->user();
        activity()
            ->event('Visit')
            ->log($user->name . ' just Visited Client "' . $client->name . '" Profile');
        return view('clients.show', compact('client', 'freeUnits', 'codes', 'users', 'streams', 'clientUsers'));
    }

    /** 
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Client $client)
    {
        $units = Unit::whereisActive(1)
            ->where(function ($query) use ($client) {
                $query->where('client_id', '=', null)
                    ->orWhere('client_id', '=', $client->id);
            })
            ->get();

        $users = User::where('id', '!=', auth()->user()->id)->get();
        $sources = Source::get();
        $countries = Country::all();
        $clientUnits = $client->units()->pluck('id')->toArray();
        $user = auth()->user();
        activity()
            ->event('Visit')
            ->log($user->name . ' just Visited Edit Client "' . $client->name . '" Page"');
        return view('clients.edit', compact('client', 'units', 'users', 'sources', 'countries', 'clientUnits'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Client $client)
    {
        // dd($request);
        try {
            DB::beginTransaction();

            $client->name = $request->name;
            $client->email = $request->email;
            $client->job_title = $request->job_title;
            $client->came_from = $request->came_from;

            $client->civil_date = $request->civil_date;
            $client->civil_city = $request->civil_city;
            $client->civil_number = $request->civil_number;
            $client->civil_address = $request->civil_address;
            $client->nationality = $request->nationality ?? '';

            if ($client->user_id != $request->user_id) {
                $user = User::find($request->user_id);
            }

            if ($request->source_id) {
                $source = Source::find($request->source_id);
                $campaign = $source->campaign;

                $client->source_id = $source->id;
                $client->campaign_id = $campaign->id;
            }
            $client->save();
            if ($client->lead_id != NULL) {
                $lead = Lead::find($client->lead_id);
                $lead->name = $client->name;
                $lead->save();
            }

            // Check if the payment fileds have value or not

            DB::commit();

            $user = auth()->user();
            activity()
                ->event('update')
                ->log($user->name . ' just updated Client "' . $client->name . '" Profile"');


            return redirect()->route('clients.show', $client->id)->with('success', 'Client Updated Successfully');
        } catch (Exception $e) {
            Log::alert('Client Edit Error', [$e->getMessage()]);
            return redirect()->back()->with('erroe', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy(Client $client)
    {
        $client->delete();
        $user = auth()->user();
        activity()
            ->event('delete')
            ->log($user->name . ' just deleted Client "' . $client->name);

        return redirect()->route('clients.index')
            ->with('success', 'Client Trashed successfully');
    }

    public function deletePermanently($id)
    {
        $client = Client::withTrashed()->find($id);
        $client->forceDelete();

        return redirect()->route('clients.archive')->with('success', 'Client Trashed successfully');
    }

    public function reservationForm(Request $request, $id)
    {
        $client = Client::find($id);
        $projects = Project::where('is_active', '1')->get();
        $unit = '';
        $payment = '';
        $facilities = array();

        if ($request->unit_id) {
            $unit = Unit::find($request->unit_id);
            $payment = Payment::where('unit_id', $request->unit_id)->first();
            $u_facilities = FacilityUnit::where('unit_id', $request->unit_id)->get();
            foreach ($u_facilities as $facility) {
                $f = Facility::find($facility->facility_id);
                array_push($facilities, [
                    'name' => $f->name,
                    'price' => $facility->price,
                    'price_word' => $facility->price_word,
                ]);
            }
        }
        $user = auth()->user();
        activity()
            ->event('visit')
            ->log($user->name . ' accessed reservation form for client "' . $client->name);


        return view('clients.reservation', compact('client', 'projects', 'unit', 'facilities', 'payment'));
    }

    public function unitReservation(Request $request)
    {
        $project = Project::find($request->project_id);
        $units = Unit::whereHas('building.phase.project', function ($query) use ($project) {
            $query->where('id', $project->id);
        })->where(['status' => 'free', 'is_active' => 1])->get();
        $facilities = $project->facilities; //will get only the project's facilities
        return json_encode(['units' => $units, 'facilities' => $facilities]);
    }

    public function getPaymentPlans(Request $request)
    {
        $unitId = $request->unit_id;

        $paymentPlans = UnitPrice::where('unit_id', $unitId)->get();
        $unit = Unit::find($unitId);

        if ($paymentPlans) {

            return response()->json([
                'paymentPlans' => $paymentPlans
            ]);
        } else {
            return response()->json([
                'error' => 'There is no Payment Plans For this unit'
            ], 404);
        }
    }


    public function AssignUnit(Request $request)
    {
        $unit = Unit::find($request->unit_id);
        $client = Client::find($request->client_id);
        $project = Project::find($request->project_id);
        $unit_price = UnitPrice::find($request->payment_plan);

        $unit->status = $request->status ?? 'hold';
        $unit->client_id = $client->id;
        $unit->Booked_date = Carbon::now()->format('y-m-d');

        if (isset($client->lead)) {
            $unit->source_id = $client->lead->source_id ?? null;
        }

        $unit->save();

        if (isset($request->facility_id)) {
            $oldFacilities = FacilityUnit::where('unit_id', $unit->id)->get();
            if (count($oldFacilities) != 0) {
                foreach ($oldFacilities as $oldFacility) {
                    $oldFacility->delete();
                }
            }
            for ($s = 0; $s < count($request->facility_id); $s++) {
                // dd($request->facility_price[$s]);
                $facility_units = new FacilityUnit();
                $facility_units->unit_id      = $request->unit_id;
                $facility_units->facility_id  = $request->facility_id[$s];
                $facility_units->price         = $request->facility_price[$s];
                $facility_units->price_word    = $request->facility_price_word[$s];
                $facility_units->save();
            }
        }

        $payment = Payment::firstOrCreate(['unit_id' => $unit->id]);
        $payment->client_id = $client->id;

        $payment->unit_id = $unit->id;
        $payment->delivery_date = $request->delivery_date;


        // Facililties         
        $facilities_price = FacilityUnit::where('unit_id', $unit->id)->sum('price');
        // Total Price
        $total_price = $unit_price->total_price + $facilities_price;
        
        // Mentainance
        $mentainance_value = $project->mentainance / 100;
        $mentainance = $unit_price->price * $mentainance_value;

        // Total Amount
        $total_amount = $total_price + $mentainance;

        // Remaining
        $remaining = $total_amount - $request->reservation + $request->down_payment;

        // Storing Data
        $payment->unit_price_id = $request->payment_plan;
        $payment->mentainance = $mentainance;
        $payment->total_price = $total_price;
        $payment->total_amount = $total_amount;
        $payment->reservation = $request->reservation;
        $payment->down_payment = $request->down_payment + $request->reservation;
        $payment->remaining = $remaining;
        $payment->save();

        // Update Batches Depended on the payment plan


        $project = $unit->building->phase->project;
        //    Get Payment Plan Details -> DownPayment to be

        $downPayment_2b = 00;

        foreach ($unit->batches as $batch) {
            if ($batch->title == 'DownPayment') {
            }

            $percentage = $batch->amount / 100;

            if ($batch->type == 'maintenance') {
                $amount = $mentainance * $percentage;
            } else {
                $amount = $total_price * $percentage;
            }

            $batch->amount = $amount;
            $batch->client_id = $client->id;

            $batch->save();
        }

        //  Activity Log
        $user = auth()->user();
        $Model = new Unit();
        activity()
            ->performedOn($Model)
            ->causedBy($user)
            ->event('Unit Actions')
            ->withProperties([
                'unit_id' => $unit->id,
                'client_id' => $client->id,
            ])->log('The unit (' . $unit->name . ') has been (' . $unit->status . ') For Client ' . $client->name);

        $Model = new Client();
        activity()
            ->performedOn($Model)
            ->causedBy($user)
            ->event('Unit Actions')
            ->withProperties([
                'unit_id' => $unit->id,
                'client_id' => $client->id,
            ])->log('The Client (' . $client->name . ') Did Action on Unit (' . $unit->name . ')( ' . $unit->status . ')');

        return redirect()->route('units.show', $unit->id)
            ->with('success', 'Reservation Done Successfully');
    }

    public function fileUpload(Request $request)
    {
        $client = Client::find($request->client_id);

        if (isset($request['files'])) {

            for ($i = 0; $i < count($request['files']); $i++) {

                $fileName = time() . $request['files'][$i]->getClientOriginalName();
                $extension = $request['files'][$i]->extension();

                if ($extension == 'csv' || $extension == 'txt'  || $extension == 'xlsx'  || $extension == 'pdf' || $extension == 'docx') {
                    // dd($extension);
                    $request['files'][$i]->move(public_path('files'), $fileName);

                    /* Store $fileName name in DATABASE from HERE */
                    $file = new File();
                    $file->client_id = $request->client_id;
                    $file->file = $fileName;
                    $file->save();
                } else {
                    return redirect()->back()->with('error', 'it not allowed file');
                }
            }
            return redirect()->route('clients.show', $client->id)->with('success', 'Files uploaded successfully');
        }

        if (isset($request['images'])) {
            for ($i = 0; $i < count($request['images']); $i++) {

                $imageName = time() . $request['images'][$i]->getClientOriginalName();
                $extension = $request['images'][$i]->extension();
                // dd($extension);
                if ($extension == 'png' || $extension == 'jpg' || $extension == 'jpeg') {
                    $request['images'][$i]->move(public_path('images'), $imageName);

                    /* Store $imageName name in DATABASE from HERE */
                    $image = new Gallery();
                    $image->client_id = $request->client_id;
                    $image->name = $imageName;
                    $image->save();
                } else {
                    return redirect()->back()->with('error', 'it not allowed image');
                }
            }
            return redirect()->route('clients.show', $client->id)->with('success', 'Files uploaded successfully');
        }
    }

    public function reservationContract(Request $request)
    {
        // dd($request);
        $unit = Unit::find($request->unit_id);
        $client = Client::find($request->client_id);
        $payment = Payment::where(['unit_id' => $unit->id, 'client_id' => $client->id])->first();

        $c_date = Carbon::create($unit->Booked_date);
        $c_date_formate = $c_date->isoFormat('dddd');

        $c_day = '';

        switch ($c_date_formate) {
            case 'Saturday':
                $c_day = 'السبت';
                break;
            case 'Sunday':
                $c_day = 'الاحد';
                break;
            case 'Monday':
                $c_day = 'الاثنين';
                break;
            case 'Tuesday':
                $c_day = 'الثلاثاء';
                break;
            case 'Wednesday':
                $c_day = 'الاربعاء';
                break;
            case 'Thursday':
                $c_day = 'الخميس';
                break;
            case 'Friday':
                $c_day = 'الجمعه';
                break;
        }
        return view('clients.reservationContract', compact('unit', 'client', 'payment', 'c_day'));
    }

    public function storeReservationContract(Request $request)
    {
        // $payment = Payment::where(['unit_id'=> $unit->id , 'client_id'=> $client->id])->first();
        $unit = Unit::find($request->unit_id);
        $client = Client::find($request->client_id);
        $payment = Payment::where(['unit_id' => $unit->id, 'client_id' => $client->id])->first();

        $unit->Booked_date = $request->booked_date;

        $c_date = Carbon::create($unit->Booked_date);
        $c_date_formate = $c_date->isoFormat('dddd');

        $c_day = '';

        switch ($c_date_formate) {
            case 'Saturday':
                $c_day = 'السبت';
                break;
            case 'Sunday':
                $c_day = 'الاحد';
                break;
            case 'Monday':
                $c_day = 'الاثنين';
                break;
            case 'Tuesday':
                $c_day = 'الثلاثاء';
                break;
            case 'Wednesday':
                $c_day = 'الاربعاء';
                break;
            case 'Thursday':
                $c_day = 'الخميس';
                break;
            case 'Friday':
                $c_day = 'الجمعه';
                break;
        }

        $unit->save();

        $payment->batches_amount = $request->batches_amount;
        $payment->payment_method = $request->payment_method;
        $payment->batches_qty = $request->batches_qty;
        $payment->batches_payment_duration = $request->batches_payment_duration;
        $payment->save();

        //  Activity Log
        $user = auth()->user();
        $Model = new Unit();
        activity()
            ->performedOn($Model)
            ->causedBy($user)
            ->event('Unit Actions')
            ->withProperties([
                'unit_id' => $unit->id,
                'client_id' => $client->id,
            ])
            ->log('The unit (' . $unit->name . ') Reservation Contract has been Generated For Client ' . $client->name);

        $Model = new Client();
        activity()
            ->performedOn($Model)
            ->causedBy($user)
            ->event('Client Actions')
            ->withProperties([
                'unit_id' => $unit->id,
                'client_id' => $client->id,
            ])
            ->log('The Client (' . $client->name . ') Recieved the Unit (' . $unit->name . ') Reservation Contract');


        return view('clients.printReservation', compact('unit', 'client', 'payment', 'c_day'));
    }

    public function import(UploadLeadRequest $request)
    {
        if ($request->file) {
            Excel::import(new ClientImport, $request->file);

            $model = new Client();
            $CurrentUser = auth()->user();
            activity()
                ->performedOn($model)
                ->causedBy($CurrentUser)
                ->event('Clients - Import')
                ->log(auth()->user()->name . ' Imprted Clients Sheet');

            return redirect()->route('clients.index')->with('success', 'Clients Uploaded Successfully');
        } else {
            return redirect()->back()->with('error', 'Choose File Please');
        }
    }

    public function searchImport(Request $request)
    {
        if ($request->file) {
            Excel::import(new ClientSourceImport, $request->file);
        } else {
            return redirect()->back()->with('error', 'Choose File Please');
        }
    }


    public function ClientSourceImport(Request $request)
    {
        if ($request->file) {
            Excel::import(new ClientSourceImport, $request->file);

            return redirect()->route('clients.index')->with('success', 'Clients Updated Successfully');
        } else {
            return redirect()->back()->with('error', 'Choose File Please');
        }
    }

    public function toLead($id)
    {
        $client = Client::find($id);
        $lead = new Lead();
        $lead->name = $client->name;
        $lead->email = $client->email;
        $lead->job_title = $client->job_title;
        $lead->is_client = 1;
        $lead->client_id = $id;
        $lead->created_by = auth()->user()->id;

        $lead->campaign_id = $client->campaign_id;
        $lead->source_id = $client->source_id;
        // if($client->user_id != null){
        //     $lead->user_id = $client->user_id;
        // }
        $lead->save();

        $client->lead_id = $lead->id;
        $client->save();

        foreach ($client->phone_numbers as $phone) {
            $phone->lead_id = $lead->id;
            $phone->client_id = $client->id;
            $phone->save();
        }

        $phones = PhoneNumber::where('lead_id', $lead->id)->get();

        $user = auth()->user();

        activity()
            ->performedOn($client)
            ->causedBy($user)
            ->event('converted client')
            ->log('client (' . $client->name . ') converted to lead by ' . $user->name);
        activity()
            ->performedOn($lead)
            ->causedBy($user)
            ->event('creat lead')
            ->log('lead (' . $lead->name . ') created by ' . $user->name);
        return redirect()->route('leads.show', $lead->id)->with('success', 'Client Converted Successfully');
    }



    public function archive()
    {

        $clients = Client::onlyTrashed()->get();
        // Log activity
        $model = new Client();
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Visit - clients archive')
            ->log(auth()->user()->name . ' viewed clients archive');

        return view('clients.archive', compact('clients'));
    }

    public function restore($clientId)
    {
        Client::withTrashed()->find($clientId)->restore();
        $client = Client::find($clientId);

        $user = auth()->user();

        activity()
            ->performedOn($client)
            ->causedBy($user)
            ->event('Restore client')
            ->log('client (' . $client->name . ') Restored by ' . $user->name);


        return redirect()->back();
    }

    public function restoreAll()
    {
        Client::onlyTrashed()->restore();

        $client = new Client();
        $user = auth()->user();

        activity()
            ->performedOn($client)
            ->causedBy($user)
            ->event('Restore All clients')
            ->log('All client Restored by ' . $user->name);

        return redirect()->back();
    }

    public function deleteImage($id)
    {
        Gallery::find($id)->delete();
        return redirect()->back();
    }

    public function AccessUsers(Request $request)
    {
        $client = Client::find($request->client_id);
        $client->accessed_users()->sync($request->user_id);
        return redirect()->back()->with('success', 'users accessed successfully');
    }
}
