<?php

namespace App\Http\Controllers;

use App\Models\PaymentType;
use Illuminate\Http\Request;

class PaymentTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $paymentTypes = PaymentType::get();
        return view('paymentTypes.create', compact('paymentTypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) 
    {
       $paymentTypes = PaymentType::pluck('name');
       
        $fCount = count($paymentTypes);
        $rCount = count($request->name);

        if($rCount >= $fCount){
            for ($i=0; $i<$rCount; $i++) {
                PaymentType::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                );
            }
        }
        
         $user = auth()->user();
         activity()
         ->event('update')
         ->log($user->name .' updated Payment Types');
        return redirect()->back()->with('success', 'Payment Types updated Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PaymentType  $paymentType
     * @return \Illuminate\Http\Response
     */
    public function show(PaymentType $paymentType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PaymentType  $paymentType
     * @return \Illuminate\Http\Response
     */
    public function edit(PaymentType $paymentType)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PaymentType  $paymentType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PaymentType $paymentType)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PaymentType  $paymentType
     * @return \Illuminate\Http\Response
     */
    public function destroy(PaymentType $paymentType)
    {
        //
        $paymentType->delete();
        return redirect()->back()->with('success', 'Payment Types Trashed Successfully');

    }
}