<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Laravel\Passport\HasApiTokens;


class Client extends Authenticatable implements HasMedia
{
    use HasFactory;
    use SoftDeletes;

    use HasApiTokens;
    use InteractsWithMedia;

    public $guarded = [];
    public $table = 'clients';

    protected $appends = [
        'image',
    ];
    protected $guard = 'client';

    protected $hidden = [
        'api_token',
        'deleted_at'
    ];

    public function lead()
    {
        return $this->belongsTo(Lead::class, 'lead_id');
    }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function units()
    {
        return $this->hasMany(Unit::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function actions()
    {
        return $this->hasMany(Action::class);
    }

    public function phone_numbers()
    {
        return $this->hasMany(PhoneNumber::class);
    }

    public function getImageAttribute($value)
    {
        $file = $this->getMedia('image')->last();
        if ($file) {
            $file->url = $file->getUrl();
            // $file->thumbnail = $file->getUrl('thumb');
        }
        return $file;
    }

    public function contracts()
    {
        return $this->hasMany(ClientContract::class);
    }

    public function tag()
    {
        return $this->belongsTo(Tag::class);
    }

    public function accessed_users()
    {
        return $this->belongsToMany(User::class, 'client_user');
    }

    public function batches()
    {
        return $this->hasMany(Batch::class);
    }

    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function images()
    {
        return $this->hasMany(Gallery::class);
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }

    public function streams()
    {
        return $this->hasMany(Stream::class);
    }

    public function source()
    {
        return $this->belongsTo(Source::class,'source_id');
    }
}
