@extends ('../welcome')


@section('content')
    <style>
        #upload-photo {
            display: none;
        }

        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>

    <!-- Filters -->
    <div class="card card-info collapsed-card">
        <div class="card-header btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>Buildings</label>
                            <select name="building_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($Allbuildings as $building)
                                    <option value="{{ $building->id }}" {{ in_array($building->id, request()->get('building_id', [])) ? 'selected' : '' }}>
                                        {{ $building->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
    
                    <div class="col-6">
                        <div class="form-group">
                            <label>Phases</label>
                            <select name="phase_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($phases as $phase)
                                    <option value="{{ $phase->id }}" {{ in_array($phase->id, request()->get('phase_id', [])) ? 'selected' : '' }}>
                                        {{ $phase->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
    
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" value="{{ request()->get('time1', old('time1')) }}" class="form-control" name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>To</label>
                                <input type="time" name="time2" value="{{ request()->get('time2', old('time2')) }}" class="form-control">
                            </div>
                        </div>
    
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="{{ request()->get('date1', old('date1')) }}" class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="{{ request()->get('date2', old('date2')) }}" class="form-control">
                            </div>
                        </div>
    
                        <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:left">Filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    

    {{-- Table --}}
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Buildings</h3>
            @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('buildings-archive'))
                <a href="{{ route('buildingsArchive') }}" style="float:right">
                    <button class="btn btn-outline-success" title="Archive" type="button">
                        <i class="fas fa-archive"></i>
                    </button>
                </a>
            @endif

        </div>
        <div class="card-body">
            <p>Total: {{ $Allbuildings->total() }}</p>
            <table
                id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('buildings-export')? 'example1': 'nonExport' }}
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phase Name</th>
                        <th>Project Name</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <th>Active</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($Allbuildings as $building)
                        <?php
                        $temp = explode(' ', $building->created_at);
                        ?>
                        <tr>
                            <td>{{ $building?->id }}</td>
                            <td>
                                <a href="{{ route('buildings.show', $building->id) }}">
                                    {{ $building->name }}
                                </a>
                            </td>
                            <td>
                                @if ($building->phase?->id)
                                    <a href="{{ route('phases.show', $building->phase->id) }}">
                                        {{ $building->phase->name }}
                                    </a>
                                @endif
                            </td>
                            <td>
                                @if($building->phase->project)
                                    <a href="{{ route('projects.show', $building->phase->project->id) }}">
                                        {{ $building->phase->project->name }}
                                    </a>
                                @endif
                            </td>
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>

                            <td>
                                <form action="{{ route('hideBuilding', $building->id) }}" method="POST">
                                    @csrf
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('buildings-hide'))
                                        <button type="submit"
                                            class="btn btn-{{ $building->is_active == 0 ? 'info' : 'danger' }}"
                                            title="{{ $building->is_active == 0 ? 'unhide' : 'hide' }}">
                                            {{ $building->is_active == 0 ? 'unhide' : 'hide' }}
                                        </button>
                                    @endif
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="pagination">
                {{ $Allbuildings->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection
