@extends ('../welcome')
@section('content')
    <form action="{{ route('generateContract') }}" method="post">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Contract Info
                </div>
            </div>
            <div class="card-body">
                @csrf
                <input type="hidden" name="status" value="taken">
                <input type="hidden" name="unit_id" value="{{ $unit->id }}">
                <input type="hidden" name="client_id" value="{{ $client->id }}">
                <div class="row">
                    <div class="col-6">
                        <!-- Client Data -->
                        <div class=" row">
                            <input type="hidden" name="c_name" value="{{ $client->name }}">
                            <label class="col-sm-4 col-form-label">Client :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->name ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="customer_job" value="{{ $client->job_title }}">
                            <label class="col-sm-4 col-form-label">job title :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->job_title ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="client_nationality" value="{{ $client->nationality }}">
                            <label class="col-sm-4 col-form-label">nationality :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->nationality ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="email" value="{{ $client->email }}">
                            <label class="col-sm-4 col-form-label">email :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->email ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="civil_id_date" value="{{ $client->civil_date }}">
                            <label class="col-sm-4 col-form-label">civil date :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->civil_date ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="civil_id_city" value="{{ $client->civil_city }}">
                            <label class="col-sm-4 col-form-label">civil city :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->civil_city ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="civil_id_num_passport_num" value="{{ $client->civil_number }}">
                            <label class="col-sm-4 col-form-label">civil number :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->civil_number ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="civil_id_address" value="{{ $client->civil_address }}">
                            <label class="col-sm-4 col-form-label">civil address :</label>
                            <label class="col-sm-4 col-form-label">{{ $client->civil_address ?? '' }} </label>
                        </div>

                        <!-- Unit Data -->
                        <div class=" row">
                            <input type="hidden" name="bs_segment_name" value="{{ $unit->name }}">
                            <label class="col-sm-4 col-form-label">Unit Name :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->name }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="units_Floor" id="floor" value="{{ $unit->floor }}">
                            <label class="col-sm-4 col-form-label">Floor :</label>
                            <label class="col-sm-4 col-form-label" id="floorName">
                            </label>

                        </div>

                        <div class=" row">
                            <input type="hidden" name="bs_unit_space" value="{{ $unit->unit_space ?? '' }}">
                            <label class="col-sm-4 col-form-label">Unit Space :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->unit_space ?? '' }} </label>
                        </div>

                        <!-- Building Data -->
                        <div class=" row">
                            <input type="hidden" name="b_Building" value="{{ $unit->building->name ?? '' }}">
                            <label class="col-sm-4 col-form-label">Building Name :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->building->name ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="phase" value="{{ $unit->building->phase->name ?? '' }}">
                            <label class="col-sm-4 col-form-label">phase Name :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->building->phase->name ?? '' }} </label>
                        </div>


                        <div class=" row">

                            <input type="hidden" name="bs_Garden_Space" value="{{ $unit->garden_space ?? '' }}">
                            <label class="col-sm-4 col-form-label">Garden Space :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->garden_space ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="bs_Roof_Space" value="{{ $unit->building->roof_space ?? '' }}">
                            <label class="col-sm-4 col-form-label">Roof Space:</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->building->roof_space ?? '' }}</label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="bs_Roof_Price" value="{{ $unit->roof_total_price ?? '' }}">
                            <label class="col-sm-4 col-form-label">Roof Total Price :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->roof_total_price ?? '' }} </label>
                        </div>

                        <div class=" row">
                            <input type="hidden" name="bs_Garden_Price" value="{{ $unit->garden_total_price }}">
                            <label class="col-sm-4 col-form-label">Garden Total Price :</label>
                            <label class="col-sm-4 col-form-label">{{ $unit->garden_total_price }} </label>
                        </div>
                        <hr>
                        <h4>Facilities</h4>
                        @for ($i = 0; $i < count($facilities); $i++)
                            <div class=" row">
                                <p class="col-sm-4">{{ $facilities[$i]['name'] ?? '' }}</p>
                                <p class="col-sm-4">{{ $facilities[$i]['price'] ?? '' }}</p>
                                <p class="col-sm-4">{{ $facilities[$i]['price_word'] ?? '' }}</p>
                            </div>
                        @endfor
                    </div>
                    <!-- right Side -->
                    <div class="col-6">
                        <div class="row">
                            <label class="col-3">Contracts</label>
                            <div class="form-group col-5">
                                <select name='contract' class="form-control" style="display: inline;" required>
                                    @foreach ($contracts as $contract)
                                        <option value="{{ $contract->id }}">{{ $contract->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-3">Contract Date</label>
                            <div class="form-group col-5">
                                <input class="form-control" value="{{ date('Y-m-d') }}" name="C_date" type="date">
                            </div>
                        </div>


                        <div class="row">
                            <label class="col-3">Deal Price</label>
                            <div class="form-group col-5">
                                <input class="form-control" name="word_deal_price" id="deal_price" type="text">
                            </div>
                            <label class="col-sm-4 col-form-label">{{ $unit->unit_total_price ?? '' }} L.E</label>
                            <input name="num_deal_price" id="num_deal_price" value="{{ $unit->unit_total_price ?? '' }}"
                                type="hidden">
                        </div>

                        <div class="row">
                            <label class="col-3">Total Amount</label>

                            <div class="form-group col-5">
                                <input class="form-control" id="total_amount" name="word_amount" type="text">
                            </div>
                            <label class="col-sm-4 col-form-label">{{ $payments->total_price ?? '' }}L.E</label>
                            <input name="num_amount" id="num_total_amount" value="{{ $payment->total_price ?? '' }}"
                                type="hidden">
                        </div>

                        <div class="row">
                            <label class="col-3">Remaining Amount:</label>

                            <div class="form-group col-5">
                                <input name="word_remaining" class="form-control" id="total_remaining" type="text">
                            </div>
                            <label class="col-sm-4 col-form-label">{{ $payment->remaining ?? '' }}L.E</label>
                            <input name="num_remaining" id="remaining" value="{{ $payment->remaining ?? '' }}"
                                type="hidden">
                        </div>

                        <div class="row">
                            <label class="col-3">Mentainance Amount: </label>

                            <div class="form-group col-5">
                                <input name="word_maintenance" class="form-control" id="word_maintenance"
                                    type="text">
                            </div>
                            <label class="col-sm-4 ">{{ $payment->mentainance ?? '' }}L.E</label>
                            <input name="num_maintenance" value="{{ $payment->mentainance ?? '' }}" type="hidden">
                        </div>

                        <div class="row">
                            <label class="col-3">Down Payment Amount: </label>

                            <div class="form-group col-5">
                                <input name="word_downpayment" class="form-control" id="word_maintenance"
                                    type="text">
                            </div>
                            <label class="col-sm-4">{{ $payment->down_payment ?? '' }}L.E</label>
                            <input name="num_downpayment" value="{{ $payment->down_payment ?? '' }}" type="hidden">
                        </div>

                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class=" btn btn-info col-3" style="margin-left: 30%">Save & Print</button>
                </div>
            </div>
    </form>
    </div>


    <script src="{{ asset('toArabic/dist/index.js') }}"></script>
    <script>
        let floor = document.getElementById('floor').value;
        let floorName = document.getElementById('floorName');
        const numbers = [{
                0: "الارضي"
            },
            {
                1: "الاول"
            },
            {
                2: "الثاني"
            },
            {
                3: "الثالث"
            },
            {
                4: "الرابع"
            },
            {
                5: "الخامس"
            },
            {
                6: "السادس"
            },
            {
                7: "السابع"
            },
            {
                8: "الثامن",
            },
            {
                9: "التاسع"
            },
            {
                10: "العاشر"
            },
        ]
        let currentFloor = numbers.filter(e => e[floor]);
        floorName.innerHTML = currentFloor[0][floor]
        let floorValue = document.getElementById('floor');
        floorValue.value = currentFloor[0][floor];

        let text = document.getElementById('remaining').value;
        let toWord = toArabicWord(text)
        document.getElementById("total_remaining").value = toWord;

        let text2 = document.getElementById('num_total_amount').value;
        let toWord2 = toArabicWord(text2)
        document.getElementById("total_amount").value = toWord2;

        let text3 = document.getElementById('num_deal_price').value;
        let toWord3 = toArabicWord(text3)
        document.getElementById("deal_price").value = toWord3;
    </script>
@endsection
