@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>
    <!-- Filters -->
    <form>
        <div class="card card-info card-outline collapsed-card">
            <div class="card-header btn btn-tool" data-card-widget="collapse">
                <div class="card-title" style="font-weight:bold; font-size:20px">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('communications.index') }}">
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label>Creator</label>
                                <select name="creators_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($creators as $creator)
                                        <option value="{{ $creator->id }}" {{ in_array($creator->id, request()->get('creators_id', [])) ? 'selected' : '' }}>
                                            {{ $creator->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
    
                            <div class="form-group">
                                <label>Status</label>
                                <select name="callActions_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($callActions as $callAction)
                                        <option value="{{ $callAction->id }}" {{ in_array($callAction->id, request()->get('callActions_id', [])) ? 'selected' : '' }}>
                                            {{ $callAction->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
    
                            <div class="form-group">
                                <label>Leads</label>
                                <select name="leads_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($leads as $lead)
                                        <option value="{{ $lead->id }}" {{ in_array($lead->id, request()->get('leads_id', [])) ? 'selected' : '' }}>
                                            {{ $lead->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
    
                        <div class="col-6">
                            <div class="row">
                                <div class="form-group col-6">
                                    <label>From</label>
                                    <input type="time" value="{{ request()->get('time1', old('time1')) }}" class="form-control" name="time1">
                                </div>
                                <div class="form-group col-6">
                                    <label>To</label>
                                    <input type="time" name="time2" value="{{ request()->get('time2', old('time2')) }}" class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <input type="date" name="date1" value="{{ request()->get('date1', old('date1')) }}" class="form-control">
                                </div>
                                <div class="form-group col-6">
                                    <input type="date" name="date2" value="{{ request()->get('date2', old('date2')) }}" class="form-control">
                                </div>
                            </div>
    
                            <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                            <button type="submit" class="btn btn-info" style="float:left">Filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </form>
    

    <!-- End filters -->

    <!-- /.row -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title"> All Actions and Dates</div><br>
                </div>
                <div class="card-body">
                    <div class="card-title">Total: {{ count($totalActions) }}</div>
                    <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('actions-export') ? 'example2' : 'nonExport' }} 
                        class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Lead Name</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Comment</th>
                                <th>Date</th>
                                <!--<th>Type</th>-->
                                <!--<th>Next Action Date</th>-->
                                <th>Created By</th>
                                <th>View</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($communications as $communication)
                                @if ($communication->broker_id == null && !empty($communication->lead))
                                    <tr>
                                        <td>{{ $communication->id }}</td>
                                        
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('leads-show'))
                                                <a href="{{ route('leads.show', $communication->lead->id) }}">
                                                    {{ $communication->lead->name ?? '' }}
                                                </a>
                                            @else
                                                <a>
                                                    {{ $communication->lead->name ?? '' }}
                                                </a>
                                            @endif
                                        </td>
                                        <td>
                                            @foreach($communication->lead->phone_numbers as $phone)
                                                <li>{{$phone->country->phonecode}} {{$phone->phone}}</li>
                                            @endforeach
                                        </td>

                                        <td>
                                            {{ $communication->lead->LeadStatus->name }}
                                        </td>

                                        <td title="Open the Event To Change Status">
                                            {{ $communication->description }}
                                        </td>
                                    
                                        <td>{{ $communication->created_at }}</td>

                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-show'))
                                            <td>
                                                <a href="{{ route('users.show', $communication->user->id) }}">
                                                    {{ $communication->user?->name }}
                                                </a>
                                            </td>
                                            @else
                                            <td>
                                                {{ $communication->user?->name }}
                                            </td>
                                        @endif
                                        
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('communications-show'))
                                                <form action="" method="POST">
                                                    <a class="btn btn-light" title="Show"
                                                        href="{{ route('communications.show', $communication->id) }}">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    @csrf
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                    @endif
                            @endforeach
                        </tbody>
                    </table>
                    <div class="pagination">
                        {{ $communications->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
