@extends ('../welcome')
@section('content')
    
    <!-- End filters -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Delay Leads</h4>
                            <p>Total: {{ count($leads) }}</p>
                            <br>
                            <div class="btn-group">
                                <!-- <button type="button" class="btn btn-default">Action</button> -->
                                <button type="button" title="bulk action"
                                    class="btn btn-light active dropdown-toggle dropdown-icon" data-toggle="dropdown">
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <div class="dropdown-menu" role="menu">
                                    {{-- @if (auth()->user()->hasRole('SuperAdmin')) --}}
                                    <a class="dropdown-item" data-toggle="modal" onClick="clickbutton(this)"
                                        data-target='#assignedUserModal' href="#">Assigned User</a>
                                    {{-- @endif --}}

                                    {{-- <a class="dropdown-item" data-toggle="modal" onClick="changeStatus(this)"
                                    data-target='#statusModal' href="#">Status</a> --}}
                                </div>
                            </div>
                            {{-- @endif --}}
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission(' leads-delaytime'))
                                <a href="{{ route('unitSettings.index') }}" style="float:right" class="btn btn-outline-dark"
                                    title="Manage DelayTime">
                                    <i class="fas fa-hourglass-end"></i>
                                </a>
                            @endif
                            <div class="card-body">


                                <table
                                    id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('delay-leads-export')? 'example1': 'nonExport' }}
                                    class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone Number</th>
                                            <th>Source</th>
                                            <th>Campaign</th>
                                            <th>Status</th>
                                            <th>comunication</th>
                                            <th>Created Date</th>
                                            <th>Created Time</th>

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($leads as $lead)
                                            <?php $temp = explode(' ', $lead->created_at->setTimezone('Africa/Cairo')); ?>

                                            <tr>
                                                <td><input type="checkbox" id="chk_lead" class="checkboxAll sub_chk"
                                                        data-id="{{ $lead->id }}">
                                                </td>
                                                <td>{{ $lead->id }}</td>
                                                <td>
                                                    <a href="{{ route('leads.show', $lead->id) }}">{{ $lead->name }}</a>
                                                </td>
                                                <td>{{ $lead->email }}</td>
                                                <!-- Phone number -->
                                                <td>
                                                    @foreach ($lead->phone_numbers as $phone_number)
                                                        <li>{{ $phone_number->phone }}</li>
                                                    @endforeach
                                                </td>
                                                <td>{{ $lead->came_from }}</td>
                                                <td>{{ $lead->campaign?->name ?? '' }}</td>
                                                <!--LEAD STATUSES -->
                                                @if ($lead->status == 'new' || $lead->status == 'recycled' || $lead->status == 'converted')
                                                    <td class="badge badge-primary"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @elseif(
                                                    $lead->status == 'in-process' ||
                                                        $lead->status == 'pending' ||
                                                        $lead->status == 'following' ||
                                                        $lead->status == 'wait')
                                                    <td class="badge badge-info" style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @elseif(
                                                    $lead->status == 'not-interested' ||
                                                        $lead->status == 'unreachable' ||
                                                        $lead->status == 'no-answer' ||
                                                        $lead->status == 'wrong-number')
                                                    <td class="badge badge-dark" style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @elseif(
                                                    $lead->status == 'follow_up' ||
                                                        $lead->status == 'closed-outside' ||
                                                        $lead->status == 'interestad' ||
                                                        $lead->status == 'meeting')
                                                    <td class="badge badge-warning"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @elseif($lead->status == 'low-budget')
                                                    <td class="badge badge-light"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @elseif($lead->status == 'done-deal')
                                                    <td class="badge badge-success"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @else
                                                    <td class="badge badge-danger"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        {{ ucwords($lead->status) }}
                                                    </td>
                                                @endif

                                                <td>{{ $lead->type }}</td>
                                                <td>{{ $temp[0] }}</td>
                                                <td>{{ $temp[1] }}</td>
                                                <td>
                                                    {{-- @if (auth()->user()->role->hasPermission('leads-update')) --}}

                                                    <a class="btn btn-info" title="Edit"
                                                        href="{{ route('leads.edit', $lead->id) }}">
                                                        <i class="fa fa-pen"></i>
                                                    </a>

                                                    {{-- @endif --}}


                                                    {{-- @if (auth()->user()->role->hasPermission('leads-delete')) --}}
                                                    <button onClick="clickDeletebutton(this)" title="Archive"
                                                        class="btn btn-danger" data-id="{{ $lead->id }}"
                                                        data-toggle="modal" data-target="#exampleModalCenter">
                                                        <i class="fa fa-ban"></i>
                                                    </button>
                                                    {{-- @endif --}}

                                                    <!-- <a class="btn btn-success" title="Next Action"
                                                                href="{{ route('communications.create', $lead->id) }}">
                                                                <i class="fas fa-calendar"></i>
                                                            </a> -->
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{-- Re-Assign Modal --}}
        <div id="assignedUserModal" class="modal fade">
            <div class="modal-dialog">
                <form id="leadData">
                    <div class="modal-content">
                        <div class="modal-body">
                            <select name="user_id" class="select2 custom-select form-control-border" id="user_id">
                                <option value=""></option>
                                @if (auth()->user()->type == 'admin')
                                    @forelse ($UserChildren as $user)
                                        <option {{ old('user_id') == $user->id ? 'selected' : '' }}
                                            value="{{ $user->id }}">
                                            {{ $user->name }}
                                        </option>
                                    @empty
                                    @endforelse
                                @else
                                    @for ($i = 0; $i < count($UserChildren); $i++)
                                        <option value="{{ $UserChildren[$i]['id'] }}">
                                            {{ $UserChildren[$i]['name'] }}
                                        </option>
                                    @endfor
                                @endif
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary yes" type="button">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        {{-- Archive Lead --}}
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Archive Record</h5>
                        <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure to Archive this Lead ?</p>
                    </div>
                    <form class="modal-footer" method="post">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <script>
        clickbutton = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                console.log(leadIds)
                return $(this).data('id')
            }).get();
            var route = "{{ route('leads.bulkAction', ':id') }}";
            route = route.replace(':id', leadIds);
            $('#assignedUserModal').find($('form')).attr('action', route);
        }

        changeStatus = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                return $(this).data('id')
            }).get();
            var route = "{{ route('leads.bulkAction', ':id') }}";
            route = route.replace(':id', leadIds);
            $('#statusModal').find($('form')).attr('action', route);
        }
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('leads.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>


@endsection
