@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>

    <!-- Filters -->
    <!-- <div class="col-3"> -->
    <form>
        <div class="card card-info  collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div id="left side" class="col-6">
                        <table id="phone&name">
                            <tr colispan>
                                <th style="text-align:center">Name</th>
                                <th style="text-align:center">Phone</th>
                                <th style="text-align:center">Country: </th>
                            </tr>
                            <tr>
                                <td class="form-group col-3">
                                    <input name="name" class="form-control" type="text" placeholder="name..."
                                        value="{{ request()->get('name', old('name')) }}">
                                </td>
                                <td class="form-group col-3">
                                    <input name="phone" class="form-control" type="number" placeholder="phone..."
                                        value="{{ request()->get('phone', old('phone')) }}">
                                </td>
                                <td class="form-group col-3">
                                    <select name="country_id[]" class="select2 custom-select form-control-border" multiple>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}"
                                                {{ in_array($country->id, request()->get('country_id', [])) ? 'selected' : '' }}>
                                                {{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>

                        <table id="Other filters" style="width:85%">
                            <tr>
                                <th style="width:25%">Assign To </th>
                                <td class="form-group">
                                    <select name="user_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}"
                                                {{ in_array($user->id, request()->get('user_id', [])) ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Creator: </th>
                                <td class="form-group">
                                    <select name="creator_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($creators as $creator)
                                            <option value="{{ $creator->id }}"
                                                {{ in_array($creator->id, request()->get('creator_id', [])) ? 'selected' : '' }}>
                                                {{ $creator->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Campaigns: </th>
                                <td class="form-group">
                                    <select name="campaign_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($campaigns as $campaign)
                                            <option value="{{ $campaign->id }}"
                                                {{ in_array($campaign->id, request()->get('campaign_id', [])) ? 'selected' : '' }}>
                                                {{ $campaign->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Projects: </th>
                                <td class="form-group">
                                    <select name="project_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}"
                                                {{ in_array($project->id, request()->get('project_id', [])) ? 'selected' : '' }}>
                                                {{ $project->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Source">Lead Target: </th>
                                <td class="form-group">
                                    <select name="source_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($sources as $source)
                                            <option value="{{ $source->id }}"
                                                {{ in_array($source->id, request()->get('source_id', [])) ? 'selected' : '' }}>
                                                {{ $source->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Assigned User">Status Type: </th>
                                <td class="form-group">
                                    <select name="statusTypes[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($statusTypes as $status)
                                            @if ($status == 'type')
                                                @continue
                                            @else
                                                <option value="{{ $status }}"
                                                    {{ in_array($status, request()->get('statusTypes', [])) ? 'selected' : '' }}>
                                                    {{ $status }}
                                                </option>
                                            @endif
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Assigned User">Status : </th>
                                <td class="form-group">
                                    <select name="status_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($statuses as $status)
                                            <option value="{{ $status->id }}"
                                                {{ in_array($status->id, request()->get('status_id', [])) ? 'selected' : '' }}>
                                                {{ $status->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Assigned User">Tags : </th>
                                <td class="form-group">
                                    <select name="tag[]" class="select2 custom-select form-control-border col-8" multiple>
                                        <option value="VIP"
                                            {{ in_array('VIP', request()->get('tag', [])) ? 'selected' : '' }}>VIP</option>
                                        <option value="urgent"
                                            {{ in_array('urgent', request()->get('tag', [])) ? 'selected' : '' }}>urgent
                                        </option>
                                        <option value="potential-client"
                                            {{ in_array('potential-client', request()->get('tag', [])) ? 'selected' : '' }}>
                                            potential-client</option>
                                        <option value="none"
                                            {{ in_array('none', request()->get('tag', [])) ? 'selected' : '' }}>none
                                        </option>
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div id="right side" class="col-6">
                        <table id="Confirm_Date">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Confirm Date</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group" style="width:215px">
                                    <input type="date" name="start_date" class="form-control"
                                        value="{{ request()->get('start_date', old('start_date')) }}">
                                </td>
                                <th>To</th>
                                <td class="form-group" style="width:215px">
                                    <input type="date" name="end_date" class="form-control"
                                        value="{{ request()->get('end_date', old('end_date')) }}">
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>
                        <table id="created_at">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Creation at</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group" style="width:225px">
                                    <input type="date" name="date1" class="form-control"
                                        value="{{ request()->get('date1', old('date1')) }}">
                                </td>
                                <td class="form-group" style="width:225px">
                                    <input type="time" name="time1"
                                        value="{{ request()->get('time1', old('time1')) }}" class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <th>To</th>
                                <td class="form-group" style="width:225px">
                                    <input type="date" name="date2" class="form-control"
                                        value="{{ request()->get('date2', old('date2')) }}">
                                </td>
                                <td class="form-group" style="width:225px">
                                    <input type="time" name="time2"
                                        value="{{ request()->get('time2', old('time2')) }}" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>
                        <table id="created_at">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Last Action</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="lastActio_start_date" class="form-control"
                                        value="{{ request()->get('lastActio_start_date', old('lastActio_start_date')) }}"
                                        style="width:215px">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="lastActio_end_date" class="form-control"
                                        value="{{ request()->get('lastActio_end_date', old('lastActio_end_date')) }}"
                                        style="width:215px">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:right">
                <button type="submit" class="btn btn-info">Filter</button>
                <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
            </div>
        </div>
    </form>

    <!-- </div> -->
    <!-- End filters -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4>Leads</h4>
                    <p>Total: {{ $leads->total() }}</p>
                    <br>
                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-create'))
                        <a href="{{ route('leads.create') }}">
                            <button class="btn btn-square btn-light active" title="create lead" type="button">
                                <i class="fas fa-user-plus"></i>
                            </button>
                        </a>
                    @endif
                    @if (auth()->user()->type == 'admin' || auth()->user()->role->name == 'Marketing Team Leader')
                        <a href="{{ route('leads.importView') }}">
                            <button class="btn btn-square btn-dark" title="Import Leads" type="button">
                                <i class="fas fa-file-import"></i>
                            </button>
                        </a>
                    @endif

                    <div class="btn-group">
                        <!-- <button type="button" class="btn btn-default">Action</button> -->
                        <button type="button" title="bulk action"
                            class="btn btn-light active dropdown-toggle dropdown-icon" data-toggle="dropdown">
                            <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-assignUsers'))
                                <a class="dropdown-item" data-toggle="modal" onClick="clickbutton(this)"
                                    data-target='#assignedUserModal' href="#">Assigned User</a>
                            @endif
                        </div>
                    </div>

                    <div style="float:right">
                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-delayLeads'))
                            <a href="{{ route('delayLeads') }}">
                                <button class="btn btn-square btn-outline-warning" title="Delayed Leads" type="button">
                                    <i class="fas fa-user-clock"></i>
                                </button>
                            </a>
                        @endif
                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-createStatus'))
                            <a href="{{ route('statuses.create') }}">
                                <button title="Manage Status" class="btn btn-square btn-outline-dark" type="button">
                                    <i class="fa fa-cog"></i>
                                </button>
                            </a>
                        @endif
                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-archive'))
                            <a href="{{ route('leads.archive') }}" style="float:right">
                                <button class="btn btn-outline-success mx-1" title="Archive" type="button"><i
                                        class="fas fa-archive"></i></button>
                            </a>
                        @endif

                    </div>
                </div>
                <div class="card-body">
                    <table
                        id="{{ auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-export') ? 'original' : 'original-nonExport' }}"
                        class="display nowrap" style="width:100%">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
                                <!--<th>ID</th>-->
                                <th>Name</th>
                                <!--<th>Email</th>-->
                                @for ($i = 1; $i <= $leadNumbers; $i++)
                                    <th>Phone Number {{ $i }}</th>
                                @endfor
                                <th>Assigned To</th>
                                @for ($i = 1; $i <= 3; $i++)
                                    <th>Last Comment {{ $i }}</th>
                                @endfor

                                <th>Last action date</th>
                                <th>Next action date</th>
                                <th>Status</th>
                                <th>Note</th>
                                <th>Lead Target</th>
                                <th>Source Type</th>
                                <th>Campaign</th>
                                <th>Project</th>
                                <!--<th>Contact Tool</th>-->
                                <!--<th>Reply Option</th>-->
                                <!--<th>Purpose</th>-->
                                <!--<th>Segment</th>-->
                                <th>Tag</th>
                                <!--<th>Last action Status</th>-->
                                <!--<th>Type</th>-->
                                <th>Created by</th>
                                <th>Created Date</th>
                                <th>Created Time</th>
                                <!--<th>Action</th>-->
                            </tr>
                        </thead>
                        <tbody>

                            @foreach ($leads as $lead)
                                @php
                                    $temp = explode(' ', $lead->created_at->setTimezone('Africa/Cairo'));
                                @endphp

                                <tr>
                                    <td><input type="checkbox" id="chk_lead" class="checkboxAll sub_chk"
                                            data-id="{{ $lead->id }}">
                                    </td>
                                    <!--<td>{{ $lead->id }}</td>-->
                                    <td>
                                        <a href="{{ route('leads.show', $lead->id) }}">{{ $lead->name }}</a>
                                    </td>
                                    <!--<td>{{ $lead->email }}</td>-->
                                    <!-- Phone number -->

                                    @for ($i = 0; $i < $leadNumbers; $i++)
                                        <td>
                                            {{ $lead->phone_numbers[$i]->country->phonecode ?? '--' }}
                                            {{ $lead->phone_numbers[$i]->phone ?? '--' }}

                                        </td>
                                    @endfor
                                    <td>
                                        @if ($lead->user_id != null)
                                            <a title="Edit" href="{{ route('users.show', $lead->user_id) }}">
                                                {{ $lead->user?->name }}
                                            </a>
                                        @endif
                                    </td>

                                    @if (auth()->user()->role->name == 'Sales Agent' && $lead->communications->last()?->user_id != auth()->user()->id)
                                        <td>--</td>
                                    @else
                                        <?php $communications = $lead->communications()->orderBy('id', 'desc')->take(3)->get(); ?>
                                        @for ($i = 0; $i < 3; $i++)
                                            <td>


                                                {{ $communications[$i]->description ?? '--' }}

                                            </td>
                                        @endfor
                                    @endif

                                    <td>
                                        {{ $lead->communications->last()?->created_at->format('Y-m-d H:i') ?? 'not yet' }}
                                    </td>
                                    <td>
                                        <?php
                                        $lastEventStart = null;
                                        ?>
                                        @foreach ($events as $event)
                                            @if ($event->communications?->lead?->id == $lead->id)
                                                <?php
                                                $lastEventStart = $event->start;
                                                ?>
                                            @endif
                                        @endforeach
                                        <?php
                                        $dateString = substr($lastEventStart, 0, 10);
                                        $dateTime = new DateTime($dateString);
                                        $formattedDate = $dateTime->format('Y-m-d');
                                        
                                        echo $formattedDate;
                                        ?>
                                    </td>
                                    @if ($lead->LeadStatus)
                                        <td class="badge badge-{{ $lead->LeadStatus->color }}"
                                            style=" margin-top:12px;margin-left:10px;">
                                            {{ ucwords($lead->LeadStatus?->name) ?? '' }}
                                        </td>
                                    @else
                                        <td></td>
                                    @endif
                                    <td>{{ $lead->note ?? '' }}</td>
                                    <td>{{ $lead->source?->name ?? '' }}</td>
                                    <td>{{ $lead->source?->sourceType?->name ?? '' }}</td>
                                    <td>{{ $lead->campaign?->name ?? '' }}</td>
                                    <td>{{ $lead->project?->name ?? '' }}</td>
                                    <!--LEAD STATUSES -->

                                    <!--<td>{{ $lead->contact_tool ?? '' }}</td>-->

                                    <!--<td>{{ $lead->reply_option ?? '' }}</td>-->

                                    <!--<td>{{ $lead->purpose ?? '' }}</td>-->

                                    <!--<td>{{ $lead->segment ?? '' }}</td>-->

                                    {{-- @endif --}}

                                    <td>{{ $lead->tag ?? '' }}</td>


                                    <!--<td>-->
                                    <!--    {{ $lead->LeadStatus->name ?? 'new' }}-->
                                    <!--</td>-->



                                    <!--<td>{{ $lead->type }}</td>-->

                                    <td>
                                        @if ($lead->created_by != null)
                                            <a href="{{ route('leads.show', $lead->created_by_user->id) }}">
                                                {{ $lead->created_by_user->name }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>{{ $temp[0] }}</td>
                                    <td>{{ $temp[1] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="pagination">
                        {{ $leads->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modals -->
    <!-- Assign User Model -->
    <div id="assignedUserModal" class="modal fade">
        <div class="modal-dialog">
            <form id="leadData1">
                <div class="modal-content">
                    <div class="modal-body">
                        <select name="user_id" class="select2 custom-select form-control-border" id="user_id">
                            @if (auth()->user()->type == 'admin')
                                @forelse ($UserChildren as $user)
                                    <option value="{{ $user->id }}">
                                        {{ $user->name }}
                                    </option>
                                @empty
                                @endforelse
                            @else
                                @for ($i = 0; $i < count($UserChildren); $i++)
                                    <option value="{{ $UserChildren[$i]['id'] }}">
                                        {{ $UserChildren[$i]['name'] }}
                                    </option>
                                @endfor
                            @endif
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary yes" type="button">Submit</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Change Status Modal -->
    <div id="statusModal" class="modal fade">
        <div class="modal-dialog">
            <form id="leadData">
                <div class="modal-content">
                    <div class="modal-body">
                        <select name="status_id" class="custom-select form-control-border">
                            @forelse($statuses as $status)
                                <option class="text-{{ $status->color }}" value="{{ $status->id }}">
                                    {{ $status->name }}</option>
                            @empty
                            @endforelse
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary yes" type="button">Submit</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Archive Lead Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive Record</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to Archive this Lead ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickbutton = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                return $(this).data('id')
            }).get();
            console.log(leadIds);
            var route = "{{ route('leads.bulkAction', ':id') }}";
            route = route.replace(':id', leadIds);
            $('#assignedUserModal').find($('form')).attr('action', route);
        }

        changeStatus = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                return $(this).data('id')
            }).get();
            var route = "{{ route('leads.bulkAction', ':id') }}";
            route = route.replace(':id', leadIds);
            $('#statusModal').find($('form')).attr('action', route);
        }
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('leads.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
