@extends ('../welcome')


@section('content')
    <div class="card card-info col-6">
        <div class="card-body">
            <form action="{{ route('phases.update', $phase->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group row">
                    <label class="col-2">Name</label>
                    <input type="text" name="name" class="form-control col-4" value="{{ $phase->name }}"
                        placeholder="Phase Name">
                </div>
                <div class="form-group row">
                    <label class="col-2">Users:</label>
                    <select name="user_id[]" class="select2 custom-select form-control-border col-8" multiple>
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}" {{ in_array($user->id, $phaseUsers) ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @if ($phase->project->is_residential == 0)
                    <div class="form-group row">
                        <label class="col-2">Type:</label>
                        <select name="type" class="select2 custom-select form-control-border access_type col-4">
                            <option value="administrative" {{ $phase->type == 'administrative' ? 'selected' : '' }}>
                                Administrative
                            </option>
                            <option value="medical" {{ $phase->type == 'medical' ? 'selected' : '' }}>Medical</option>
                            <option value="commercial" {{ $phase->type == 'commercial' ? 'selected' : '' }}>Commercial
                            </option>
                        </select>
                    </div>
                @endif
                <input type="hidden" name="project_id" value="{{ $phase->project->id }}">
                <button type="submit" style="float:right" class="btn btn-info">
                    <span>Submit</span>
                </button>
            </form>
        </div>
    </div>
@endsection
