@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>

    <!-- Filters -->
    <form>
        <div class="card card-info collapsed-card">
            <div class="card-header btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div id="left side" class="col-6">
                        <table id="Other filters" style="width:85%">
                            <tr>
                                <th style="width:25%" title="Ticket Status">Status: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="ticket_status[]">
                                        <option value="pending" {{ in_array('pending', request()->get('ticket_status', [])) ? 'selected' : '' }}>pending</option>
                                        <option value="follow_up" {{ in_array('follow_up', request()->get('ticket_status', [])) ? 'selected' : '' }}>follow_up</option>
                                        <option value="done" {{ in_array('done', request()->get('ticket_status', [])) ? 'selected' : '' }}>done</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Ticket Type">Type: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="ticketType_id[]">
                                        @foreach ($ticketTypes as $type)
                                            <option value="{{ $type->id }}" {{ in_array($type->id, request()->get('ticketType_id', [])) ? 'selected' : '' }}>
                                                {{ $type->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Units: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="unit_id[]">
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id }}" {{ in_array($unit->id, request()->get('unit_id', [])) ? 'selected' : '' }}>
                                                {{ $unit->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Clients: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="client_id[]">
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}" {{ in_array($client->id, request()->get('client_id', [])) ? 'selected' : '' }}>
                                                {{ $client->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Communication Method">Methods: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="method_id[]">
                                        @foreach ($methods as $method)
                                            <option value="{{ $method->id }}" {{ in_array($method->id, request()->get('method_id', [])) ? 'selected' : '' }}>
                                                {{ $method->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Assigned User">User: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="user_id[]">
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}" {{ in_array($user->id, request()->get('user_id', [])) ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>
    
                    <div id="right side" class="col-6">
                        <table id="created_at">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Creation Date</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="date1" class="form-control" value="{{ request()->get('date1', old('date1')) }}">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="date2" class="form-control" value="{{ request()->get('date2', old('date2')) }}">
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>
                        <table id="call_date">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Call Date</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="call_date1" class="form-control" value="{{ request()->get('call_date1', old('call_date1')) }}">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="call_date2" class="form-control" value="{{ request()->get('call_date2', old('call_date2')) }}">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:right">
                <button type="submit" class="btn btn-info">filter</button>
                <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
            </div>
        </div>
    </form>
    

    <!-- Content -->
    <div class="card">
        <div class="card-header">
            <div class="card-title">Tickets <br> Total: {{ $tickets->total() }}</div>
            @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('tickets-create'))
                <a href="{{ route('tickets.create') }}">
                    <button class="btn btn-square btn-outline-info" type="button" style="float:right">
                        <i class="fas fa-plus"></i>
                    </button>
                </a>
            @endif
        </div>
        <!-- /.card-header -->

        <div class="card-body">
            <table
                id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('tickets-export')? 'example1': 'nonExport' }}
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Ticket ID</th>
                        <th>Ticket Status</th>
                        <th>Client Name</th>
                        <th>Phone</th>
                        <th>Ticket Type</th>
                        <th>Related Item</th>
                        <th>Ticket Source</th>
                        <th>Note</th>
                        <th>Call Date</th>
                        <th>Ticket Creation Date</th>
                        {{-- <th>Ticket last Action</th>
                        <th>Ticket Action Date</th> --}}
                        <th>Created By</th>
                        <th>Assigned User</th>

                        <th>Show</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($tickets as $ticket)
                        <tr>
                            <td>
                                <a href="{{ route('tickets.show', $ticket->id) }}">
                                    {{ $ticket->id ?? '' }}
                                </a>
                            </td>
                            <td>{{ $ticket->status ?? '' }}</td>
                            <td>
                                <a href="{{ route('clients.show', $ticket->client?->id) }}">
                                    {{ $ticket->client?->name ?? '' }}
                                </a>
                            </td>

                            <td>
                                @if (!empty($ticket->client->phone_numbers))
                                    @foreach ($ticket->client->phone_numbers as $phone)
                                        <li>
                                            {{ $phone->country->phonecode }} {{ $phone->phone }}
                                        </li>
                                    @endforeach
                                @endif
                            </td>
                            <td>{{ $ticket->ticket_type?->name ?? '' }}</td>

                            <td>
                                <a href="{{ route('units.show', $ticket->unit?->id) }}">
                                    {{ $ticket->unit?->name ?? '' }}
                                </a>
                            </td>
                            <td>{{ $ticket->method?->name ?? '' }}</td>
                            <td>{{ $ticket->description ?? '' }}</td>
                            <td>
                                {{ Carbon\Carbon::parse($ticket->call_date)->format('Y-m-d') ?? '' }}
                            </td>
                            <td>{{ $ticket->created_at ?? '' }}</td>
                            <td>
                                <a href="{{ route('users.show', $ticket->ticket_created_by?->id) }}">
                                    {{ $ticket->ticket_created_by?->name }}
                                </a>
                            </td>
                            <td>
                                <a href="{{ route('users.show', $ticket->assigned_to?->id) }}">
                                    {{ $ticket->assigned_to?->name ?? '' }}
                                </a>
                            </td>
                            <td>
                                @if (auth()->user()->type == 'admin' || Auth::user()->role->hasPermission('tickets-show'))
                                    <a class="btn btn-info" href="{{ route('tickets.show', $ticket->id) }}">Show</a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="pagination">
                    {{ $tickets->appends(request()->input())->links() }}
                </div>
        </div>
        <!-- /.card-body -->
    </div>
@endsection
