<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Lead;
use App\Models\LeadUser;
use App\Models\User;
use App\Models\Communication;
use App\Models\Notifications;
use Illuminate\Support\Facades\Notification;
use Carbon\Carbon;

class DelayLead extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'delay:lead';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $leads = Lead::whereNotNull('user_id')->get();    
        foreach($leads as $lead){

                $leadUser = LeadUser::where('lead_id', $lead->id)->latest()->first(); //Order by desc first
                if(!empty($leadUser)){
                    $user = User::find($leadUser->user_id);
                    $leader = User::find($user->assigned_to);
                    $deadline = Carbon::parse($leadUser->deadline);

                    $event = Communication::where('lead_id', $lead->id)->latest()->first();
                    
                    if(!empty($event)){
                        // dd($event->updated_at);
                        if($event->updated_at >= $leadUser->deadline){
                            $data = [
                                'subject'=>'Revoke ' . $lead->name,
                                'greeting' => 'Dear, '. $user->name ,
                                'body' => 'You no longer assigned to follow up with Lead ' . $lead->name,
                                'thanks' => 'thanks',
                            ];
                            
                            $notification = Notifications::where('title', 'Delay lead')->first();
                            if($notification->is_active == 1){
                                Notification::send($user, new DelayLead($data));
                            }
                            $data2 = [
                                'subject'=>'Revoke',
                                'greeting' => 'Dear, '. $leader->name ,
                                'body' => 'your team member'. $user->name. ' has been lost the lead ' . $lead->name,
                                'thanks' => 'thanks',
                            ];
            
                            // $notification = Notifications::where('title', 'Delay lead')->first();
                            // if($notification->is_active == 1){
                                Notification::send($user, new DelayLead($data2));
                            // }
                            $leadUser->status = 'failed';
                            $leadUser->save();

                            $lead->user_id = Null;
                            $lead->is_delay = 1;
                            $lead->save();

                        }else{
                            $leadUser->status = 'Done';
                            $leadUser->save();
                        } 
                    }else{


                        $now = Carbon::now();
                        if($now >= $deadline){
                            $leadUser->status = 'failed';
                            $leadUser->save();

                            $lead->user_id = Null;
                            $lead->is_delay = 1;
                            $lead->save();

                            $data = [
                                'subject'=>'Revoke ' . $lead->name,
                                'greeting' => 'Dear, '. $user->name ,
                                'body' => 'You missed the Lead ' . $lead->name,
                                'thanks' => 'thanks',
                            ];
                            
                            // $notification = Notifications::where('title', 'Delay lead')->first();
                            // if($notification->is_active == 1){
                                Notification::send($user, new DelayLead($data));
                            // }
                            
                            $data2 = [
                                'subject'=>'Revoke',
                                'greeting' => 'Dear, '. $leader->name ,
                                'body' => 'your team member'. $user->name. ' has been missed the lead ' . $lead->name,
                                'thanks' => 'thanks',
                            ];
            
                            // $notification = Notifications::where('title', 'Delay lead')->first();
                            // if($notification->is_active == 1){
                                Notification::send($user, new DelayLead($data2));
                            // }
                        }
                    }              
                }
            }
        return 0;
    }
}