<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Models\User;
use App\Models\Action;
use App\Models\Client;
use App\Models\Ticket;
use App\Models\TicketType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ActionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(auth()->user()->type == 'admin' || auth()->user()->role->name == 'Customer Service Manager')
        {
            $actions = Action::query();
        }
        // Actions Tree
        else{
            $actions = Action::query();
            
            $users = User::all();
            $CurrentUser = auth()->user();
            $UserChildren = array();

            foreach ($users as $userr) {
                $parents = $userr->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, [
                        'id' => $userr->id,
                        'name' => $userr->name,
                    ]);
                }
            }

            $ActionBulk = array();
            if (count($CurrentUser->ticket_actions) != 0) {
                foreach ($CurrentUser->ticket_actions as $action) {
                    array_push($ActionBulk, $action->id);
                }
            }
            for ($i = 0; $i < count($UserChildren); $i++) {
                $user = User::find($UserChildren[$i]['id']);
                if (count($user->ticket_actions) == 0) {
                    continue;
                } else {
                    foreach ($user->ticket_actions as $action) {
                        array_push($ActionBulk, $action->id);
                    }
                }
            }
           
            $actions->whereIn('id', $ActionBulk);
        }
        $ticketTypes = DB::table('ticket_types')->select('id', 'name')->get();
        $units = DB::table('units')->select('id', 'name')->where('status', '!=' , 'free')->get();
        $methods = DB::table('methods')->select('id', 'name')->get();
        $users = DB::table('users')->select('id', 'name')->get();
        $clients = DB::table('clients')->select('id', 'name')->get();

// filter
        
        if ($request->client_id) {
            $actions->whereIn('client_id', $request->client_id);
        }

        if ($request->unit_id) {
            $actions->whereIn('unit_id', $request->unit_id);
        }

        if ($request->ticket_type_id) {
            $actions->whereIn('ticket_type_id', $request->ticket_type_id);
        }

        if ($request->user_id) {
            $actions->whereIn('user_id', $request->user_id);
        }

        if ($request->action_creation1 && $request->action_creation2) {
            $actions->whereDate('created_at', '>=', $request->action_creation1)
                ->whereDate('created_at', '<=', $request->action_creation2);
        }

        if ($request->ticket_creation1 && $request->ticket_creation2) {
            $tickets = Ticket::whereDate('created_at', '>=', $request->ticket_creation1)
            ->whereDate('created_at', '<=', $request->ticket_creation2)->pluck('id')->toArray();
            
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticket_creation1 && $request->ticket_creation2) {
            $tickets = Ticket::whereDate('created_at', '>=', $request->ticket_creation1)
            ->whereDate('created_at', '<=', $request->ticket_creation2)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticketType_id) {
            $tickets = Ticket::where('ticket_type_id',$request->ticketType_id)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticket_status) {
            $tickets = Ticket::where('status',$request->ticket_status)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

// end filter
        $actions = $actions->paginate(50)->withQueryString();

        return view('tickets.TicketActions', compact('actions','units','methods' ,'ticketTypes', 'users', 'clients'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Action  $action
     * @return \Illuminate\Http\Response
     */
    public function show(Action $action)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Action  $action
     * @return \Illuminate\Http\Response
     */
    public function edit(Action $action)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Action  $action
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Action $action)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Action  $action
     * @return \Illuminate\Http\Response
     */
    public function destroy(Action $action)
    {
        //
    }
}
