<?php

namespace App\Http\Controllers\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\CommunicationRequest;
use App\Models\CallAction;
use App\Models\Communication;
use App\Models\User;
use App\Models\Lead;
use App\Models\Broker;
use App\Models\Agent;
use App\Models\Event;
use App\Models\Status;
use App\Models\CommunicationEvent;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Notifications\AssignUser;
use App\Models\Notifications;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class CommunicationController extends Controller
{
    public function __construct()
    {
        // $this->middleware('permission:communications-create',['only' => ['create', 'store']]);
        // $this->middleware('permission:communications-read',['only' => ['show']]);
    }

    public function index(Request $request)
    {
        activity()
            ->event('visit')
            ->log(auth()->user()->name . 'Events Index');

        $communications = Communication::query();
        // if (auth()->user()->type != 'admin') {

        //     $communications->where('user_id', auth()->user()->id);
        // }

        $creators = User::get();
        $callActions = CallAction::get();
        $leads = Lead::get();
        $events = Event::get();

        // dd($request->creators_id);
        if ($request->creators_id) {
            $communications->whereIn('user_id', $request->creators_id);
        }

        if ($request->leads_id) {
            $communications->whereIn('lead_id', $request->leads_id);
        }

        if ($request->callActions_id) {
            $communications->whereIn('call_action_id', $request->callActions_id);
        }

        if ($request->events_id) {
            $events->whereIn('id', $request->events_id);
        }

        if ($request->time1 && $request->time2) {
            $communications->whereTime('created_at', '>=', $request->time1)
                ->whereTime('created_at', '<=', $request->time2);
        }

        if ($request->date1 && $request->date2) {
            $communications->whereDate('created_at', '>=', $request->date1)
                ->whereDate('created_at', '<=', $request->date2);
        }

        $CurrentUser = auth()->user();

        if(auth()->user()->role->name != 'Sales Admin' && auth()->user()->role->name != 'Sales Director')
        {
            if ($CurrentUser->type != 'admin') {
            $UserChildren = array($CurrentUser->id);
            foreach ($creators as $user) {
                $parents = $user->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, $user->id);
                }
            }

            $communications->whereIn('user_id', $UserChildren);
            } else {
                $UserChildren = $creators;
            }
        }
        $totalActions = $communications->get();
        $communications->where(['broker_id'=> NULL ]);
        $communications = $communications->paginate(50)->withQueryString();

        return view('communications.index', compact('communications', 'events', 'creators', 'callActions', 'leads', 'totalActions'));
    }

    public function create($leadId = null)
    {

        activity()
            ->event('visit')
            ->log(auth()->user()->name . ' is creating call action');

        $callActions = CallAction::all();
        $statuses = Status::get();
        // dd($statuses);
        if (auth()->user()->type == 'admin') {
            $leads = Lead::get();
            $users = User::where('id', '!=', auth()->user()->id)->get();
        } else {
            $leads = Lead::where('user_id', auth()->user()->id)->get();
            $users = '';
        }

        if (isset($leadId)) {
            $leadData = Lead::findOrFail($leadId);
            // dd($leadData);
            return view('communications.create', compact('leads', 'leadData', 'callActions', 'users', 'statuses'));
        }


        return view('communications.create', compact('leads', 'callActions', 'users'));
    }

    public function store(Request $request)
    {
        // dd($request->start_date);
        try {
            DB::beginTransaction();
            // Broker Actions
            if($request->broker_id){
                $broker = Broker::find($request->broker_id);
                // store Communiction
                $communication = new Communication();
                $communication->type = $request->type;
                $communication->state = $request->state;
                $communication->broker_id = $request->broker_id;
                $communication->agent_id = $request->agent_id;
                $communication->reminder = $request->reminder ?? '';
                $communication->description = $request->description;
                $communication->check_in = $request->check_in ?? 0;
                $communication->user_id = auth()->user()->id;
                
                if (isset($request->reminder)) {
                    $reminder = Carbon::create($request->reminder);
                    $communication->reminder = $reminder;
                }
                
                $communication->save();
                // store Event
                if(isset($request->start_date)){
                    $event = new Event();
                    $event->title = 'make '.$communication->type.' With ' . $communication->broker?->name;
                    $event->type = $communication->type;
                    $event->communication_id = $communication->id;
                    
                    $start_date = Carbon::create($request->start_date);
                    $event->start = $start_date;
    
                    if (isset($request->end_date)) {
                        $end_date = Carbon::create($request->end_date);
                        $event->end = $end_date;
                    }
    
                    $event->save();
                    CommunicationEvent::create([
                        'communication_id' => $communication->id,
                        'event_id' => $event->id
                    ]);
                }

                 // Log Activity
                 $CurrentUser = auth()->user();
                 activity()
                 ->performedOn($communication)
                 ->causedBy($CurrentUser)
                 ->event('Activity')
                 ->withProperties([
                     'action_creator_name' => $CurrentUser->name,
                     'action_creator_id' => $CurrentUser->id,
                     'action_type' => $communication->type,
                     'broker_name' => $communication->broker->name,
                     'broker_id' => $communication->broker->id,
                     'action_description' => $communication->description,
                 ])
                 ->log($CurrentUser->name . 'make and activity with: (' . $broker->name . ')');
                
            }else{
                // Lead Actions
                $lead = Lead::find($request->lead_id);
                $callAction = CallAction::find($request->call_action_id);
                $status = Status::where('name', $callAction->name)->first();
                
                $communication = new Communication();
                $communication->call_action_id = $request->call_action_id;
                $communication->action_method = $request->action_method;
                $communication->status_id = $status->id;
                $communication->state = $request->start_date ? $request->state : 'done';
                $communication->description = $request->description;
                $communication->lead_id = $request->lead_id;
                $communication->user_id = $request->user_id ?? auth()->user()->id;
                $communication->call_action_id = $request->call_action_id;
    
                $communication->created_by = auth()->user()->id;
    
                $communication->save();
    
                $lead = Lead::find($request->lead_id);
                $lead->status_id = $status->id;
                // $lead->status = $status->name;
                $lead->save();            
                
                
                if (isset($request->start_date)) {
                    $start_date = Carbon::create($request->start_date);
                    // dd($start_date);
                    $event = new Event();
    
                    $event->title = $communication->lead->name . $communication->user->name;
                    $event->start = $request->start_date;
                    $event->type = 'call';
                    $event->communication_id = $communication->id;
    
                    $event->end = $request->start_date;
                    $event->save();
                    CommunicationEvent::create([
                        'communication_id' => $communication->id,
                        'event_id' => $event->id
                    ]);
                }

                // Log Activity
                    $CurrentUser = auth()->user();
                    activity()
                    ->performedOn($communication)
                    ->causedBy($CurrentUser)
                    ->event('Call Action')
                    ->withProperties([
                        'action_creator_name' => $CurrentUser->name,
                        'action_creator_id' => $CurrentUser->id,
                        'action_type' => 'Call Action',
                        'lead_name' => $lead->name,
                        'lead_id' => $lead->id,
                        'lead_status' => $communication->CommunicationStatus->name,
                        'action_description' => $communication->description,
                    ])
                    ->log($CurrentUser->name . 'Took an action on lead: (' . $lead->name . ')');

                    
                }
                // Store Into pivot table communication_event
                
                DB::commit();
                
                return redirect()->back()->with('success', 'Activity Created Successfully');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }


    public function show($communicationId)
    {
        $communication = Communication::findOrFail($communicationId);
        if (isset($communication->lead)) {
            $lead = Lead::find($communication->lead_id);
        } else {
            $lead = Lead::withTrashed()->where('id', $communication->lead_id)->first();
        }
        if (isset($communication->user)) {
            $user = User::find($communication->user_id);
        } else {
            $user = User::withTrashed()->where('id', $communication->user_id)->first();
        }
        $users = User::get();
        $broker = Broker::find($communication->broker_id);
        if($broker != NULL){
        $agents = $broker->agents;
        }else{
            $agents = array();
        }
        
        activity()
            ->event('visit')
            ->log(auth()->user()->name . ' viewed event');

        return view('communications.show', compact('communication', 'lead', 'user', 'users', 'broker', 'agents'));
    }

    public function changeStatus($communicationId, Request $request)
    {
        $communication = Communication::find($communicationId);
        activity()
            ->event('event.change status')
            ->log(auth()->user()->name . ' changed event status to ' . $request->status);

        $communication->state = $request->state;
        $communication->save();

        return redirect()->back()->with('success', 'Status Changed Successfully');
    }


    public function actionTypes(Request $request)
    {
        $actions = CallAction::where('type', $request->action)->get();
        return json_encode(['actionTypes' => $actions]);
    }

    public function nextActions()
    {
        $CurrentUser = auth()->user();
        $users = User::get();

        $children = array($CurrentUser->id);
        foreach ($users as $user) {
            $parents = $user->getParents()->pluck('id')->toArray();

            if (in_array($CurrentUser->id, $parents)) {
                array_push($children, $user->id);
            }
        }

        $communications = Communication::whereIn('user_id', $children);
        $communications->whereNotNull('lead_id');
        $communications = $communications->paginate(100)->withQueryString();

        return view('communications.nextActions', compact('communications'));
    }

    public function myActions()
    {
        // dd('myAcyions');
        $CurrentUser = auth()->user();
        $communications = Communication::query(); 
        $communications->where('user_id' ,$CurrentUser->id);
        $communications->whereNotNull('lead_id')->get();
        $communications = $communications->paginate(100)->withQueryString();

        return view('communications.myActions', compact('communications'));
    }

    public function checkIn(Request $request)
    {
        
        $communication = Communication::findOrFail($request->communication_id);
        $communication->check_in = 1;
        $communication->description = $request->description;
        $communication->user_id = auth()->user()->id;
        $communication->save();

        $event = Event::where('communication_id', $request->communication_id)->first();
        if (isset($request->start_date)) {
            $start_date = Carbon::create($request->start_date);
            $event->start = $start_date;
        }
        if (isset($request->end_date)) {
            $end_date = Carbon::create($request->end_date);
            $event->end = $end_date;
        }

        $event->save();

        $users = User::get();
        $CurrentUser = auth()->user();
        activity()
        ->performedOn($communication)
        ->causedBy($CurrentUser)
        ->event('Activity Check In')
        ->withProperties([
            'activity_creator_name' => $CurrentUser->name,
            'activity_creator_id' => $CurrentUser->id,
            'activity_type' => 'Activity Check In',
            'broker_name' => $communication->broker->name,
            'broker_id' => $communication->broker->id,
            'activity_type' => $communication->type,
            'activity_description' => $communication->description,
        ])
        ->log($CurrentUser->name . 'created an activity on lead: (' . $communication->broker->name . ')');

        return redirect()->back()->with('success', 'Activity Checked in Successfully');
    }

    public function update(Request $request, Communication $communication)
    {
        $broker = Broker::find($request->broker_id);
        // store Communiction
        $communication->type = $request->type;
        $communication->state = $request->state;
        $communication->broker_id = $request->broker_id;
        $communication->agent_id = $request->agent_id;
        $communication->reminder = $request->reminder ?? '';
        $communication->description = $request->description;
        
        if (isset($request->reminder)) {
            $reminder = Carbon::create($request->reminder);
            $communication->reminder = $reminder;
        }
        
        $communication->save();
        // store Event
        
        $event = $communication->event;
        $event->title = 'make '.$communication->type.' With ' . $communication->broker?->name;
        $event->type = $communication->type;
        $event->communication_id = $communication->id;
        
        $start_date = Carbon::create($request->start_date);
        $event->start = $start_date;

        $event->save();

        // Log Activity
        $CurrentUser = auth()->user();
        activity()
        ->performedOn($communication)
        ->causedBy($CurrentUser)
        ->event('Activity')
        ->withProperties([
            'action_creator_name' => $CurrentUser->name,
            'action_creator_id' => $CurrentUser->id,
            'action_type' => $communication->type,
            'broker_name' => $communication->broker?->name,
            'broker_id' => $communication->broker?->id,
            'action_description' => $communication->description,
        ])
        ->log($CurrentUser->name . 'make and activity with: (' . $communication->broker?->name . ')');
        return redirect()->back()->with('success', 'Activity updated in Successfully');
    }

    public function activityReAssign(Request $request)
    {
        
        $communication = Communication::findOrFail($request->communication_id);
        $communication->user_id = $request->user_id;
        $communication->save();

        $users = User::get();
        $CurrentUser = auth()->user();
        activity()
        ->performedOn($communication)
        ->causedBy($CurrentUser)
        ->event('Activity Check In')
        ->withProperties([
            'activity_creator_name' => $CurrentUser->name,
            'activity_creator_id' => $CurrentUser->id,
            'activity_type' => 're-assign user',
            'broker_name' => $communication->broker->name,
            'broker_id' => $communication->broker->id,
            'communication_id' => $communication->id,
        ])
        ->log($CurrentUser->name . ' Re-Assigned Activity to : (' . $communication->user->name . ')');

        return redirect()->back()->with('success', 'user changed successfully');
    }
}
