<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\LoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(LoginRequest $request)
    {
        // dd($request);
        $user = User::where('email', $request->email)->first();
        if(!empty($user)){
            if(password_verify($request->password, $user->password)){
               
                if(isset($user) && $user->is_blocked == 0){
                    $request->authenticate();
                    $request->session()->regenerate();
        
                $userModel = new User();
                $CurrentUser = auth()->user();
        
                activity()
                ->performedOn($userModel)
                ->causedBy($CurrentUser)
                ->event('Login')
                ->log('User (' . $CurrentUser->name . ') Logged in');
                }
                return redirect()->intended(RouteServiceProvider::HOME);
            
                
            }else{
                return redirect()->back()->with('error', 'incorrect password');
            }
        }else{
            return redirect()->back()->with('error', 'user not found');
        }

    }

    /**
     * Destroy an authenticated session.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        $userModel = new User();
        $CurrentUser = auth()->user();

        activity()
        ->performedOn($userModel)
        ->causedBy($CurrentUser)
        ->event('Logout')
        ->log('User (' . $CurrentUser->name . ') Logged Out');
            
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
