<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Source;
use App\Models\Campaign;

use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;

class ClientSourceImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows,SkipsOnFailure
{
    use Importable,SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        //$assignedUser = User::whereName($row['assigned_user'])->first();

        $client = Client::find($row['client_id']);
        if(isset($row['source_id'])){
            $source = Source::find($row['source_id']);
            $campaign = $source->campaign;
    
            $client->source_id = $source->id;
            $client->campaign_id = $campaign->id;
        }
        if(isset($row['user_id'])){
            $user = User::find($row['user_id']);
            if($user != NULL){
                $client->user_id = $row['user_id'];
            }
        }

        $client->save();

        return $client;
    }

    public function rules(): array
    {
        return [
            'client_id' => ['required'],
        ];
    }
    
     public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        $data = [];
        foreach ($failures as $failure) {

            array_push($data,$failure->errors());
        }

        Session::push('leadsErrors', collect($data));
    }
}
