<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentPlan extends Model
{
    use HasFactory;

    public $guarded = [];

    protected $table = 'payment_plans';

    public function PaymentPlanDetails()
    {
        return $this->hasMany(PaymentPlanDetails::class);
    }

    public function projects()
    {
        return $this->belongsToMany(Project::class, 'payment_plan_project')->withTimestamps();
    }
}
