<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Source extends Model
{
    use HasFactory;
    public $guarded = [];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function sourceType()
    {
        return $this->belongsTo(SourceType::class, 'sourceType_id');
    }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class);
    }

    public function clients()
    {
        return $this->hasMany(Client::class);
    }

    public function inquiries()
    {
        return $this->hasMany(Inquiry::class);
    }
}
