<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\UnitSetting;


class UnitSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $unitSettings = [
            [
            "name" => "garden",
            "type" => "view"
            ],
            [
                "name" => "Parking",
                "type" => "view"
            ],
            [
                "name" => "landscape",
                "type" => "view"
            ],
            [
                "name" => "semi-finishing",
                "type" => "finishing"
            ],
            [
                "name" => "finished",
                "type" => "finishing"
            ],
            [
                "name" => "finished with ACs",
                "type" => "finishing"
            ],
            [
                "name" => "SuperMarket",
                "type" => "Commercial"
            ],
            [
                "name" => "Duplex",
                "type" => "Residential"
            ],
            [
                "name" => "Appartment",
                "type" => "Residential"
            ],
            [
                "name" => "pharmacy",
                "type" => "Commercial"
            ],
        ];
        foreach ($unitSettings as $key => $value) {
            UnitSetting::create($value);
        }
    }
}