<!DOCTYPE html>
<html lang="en">

<head>
    <title>SD Solutions</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <!-- {{ asset('db-assets/img/favicon.png') }} -->
    <link rel="stylesheet" href="{{ asset('asset/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="{{ asset('asset/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('asset/dist/css/adminlte.min.css') }}">

    <link rel="stylesheet" href="{{ asset('asset/dist/css/style.css') }}">

</head>

<body>
    <section class="ftco-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-10">
                    <div class="wrap d-md-flex">

                        {{-- <div class="login-wrap p-4 p-lg-5"> --}}
                        @if (session()->has('error'))
                            <div class="alert alert-danger">
                                <ul>
                                    <h5>{{ session()->get('error') }}</h5>
                                </ul>
                            </div>
                        @endif
                        {{-- <div class="d-flex">
                                <div class="w-100">
                                    <h3 class="mb-4">Sign In</h3>
                                </div>
                            </div> --}}
                        <div class="card">
                            <form id="myForm" action="{{ route('brokers.store') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="status" value="pending" class="form-control">
                                <input type="hidden" name="is_broker" value="yes" class="form-control">
                                <div class="card-body register-card-body mt-5 ml-4">
                                    <div class="col-12">
                                        <div class="row">
                                            <div class="form-group col-10">
                                                <label>Name</label>
                                                <input type="text" name="name" value="{{ old('name') }}"
                                                    class="form-control">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-5">
                                                <label for="address">Address</label>
                                                <input type="text" id="address" class="form-control"
                                                    value="{{ old('email') }}" name="address">
                                            </div>
                                            <div class="form-group col-5">
                                                <label>Email</label>
                                                <input type="email" class="form-control"
                                                    placeholder="email@example.com" value="{{ old('email') }}"
                                                    name="email">
                                            </div>
                                        </div>

                                        <div class="row">


                                            <div class="form-group col-5">
                                                <label for="type">Type</label>
                                                <select id="type" name="type"
                                                    class="custom-select form-control-border" id="campaigns">
                                                    <option value="broker">Broker</option>
                                                    <option value="ambassador">Ambassador</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-5">
                                                <label for="owner">Owner Name</label>
                                                <input id="owner" type="text" class="form-control"
                                                    name="owner_name">
                                            </div>
                                            <div class="form-group col-5">
                                                <label for="sales_admin">Sales Admin</label>
                                                <input id="sales_admin" type="text" class="form-control"
                                                    name="sales_admin">
                                            </div>

                                            <div class="form-group col-5">
                                                <label for="authorized_name">Authorized Name</label>
                                                <input id="authorized_name" type="text" class="form-control"
                                                    name="authorized_name">
                                            </div>

                                            <div class="form-group col-5">
                                                <label for="commercial_record">Commercial Record</label>
                                                <input id="commercial_record" type="text" class="form-control"
                                                    name="commercial_record">
                                            </div>

                                            <!-- textarea -->
                                            <div class="form-group col-10">
                                                <label for="desc">Description: </label>
                                                <textarea id="desc" class="form-control" name="description" placeholder="Description"></textarea>
                                            </div>

                                            <div class="form-group col-5">
                                                <label for="files">Upload Files</label>
                                                <input id="files" type="file" name="files[]" multiple>
                                            </div>

                                            <div class="form-group col-5">
                                                <label for="images">Upload images</label>
                                                <input id="images" type="file" name="images[]"
                                                    accept="image/png, image/jpeg" multiple>
                                            </div>
                                        </div>
                                        <div id="inputFormRow">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="card-title">
                                                        Phone Numbers
                                                    </div>
                                                    <button id="addRow" type="button" class="btn btn-info"
                                                        style="float:right">
                                                        <i class="fas fa-plus"></i>
                                                    </button>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-5">
                                                            <label>Country</label>
                                                            <select name="country_id[]"
                                                                class="select2 custom-select form-control-border"
                                                                id="countries" required>
                                                                @foreach ($countries as $country)
                                                                    <option value="{{ $country->id }}"
                                                                        {{ $country->name == 'Egypt' ? 'selected' : '' }}>
                                                                        {{ $country->name }} -
                                                                        {{ $country->phonecode }} +
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="col-6">
                                                            <label>Mobile Number</label>
                                                            <input type="number" step="any"
                                                                class="form-control m-input"
                                                                value="{{ old('phone_number') }}"
                                                                placeholder="Phone Number" name="mobile_number[]"
                                                                id="phone" required>
                                                        </div>
                                                    </div>
                                                    <div id="newRow"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-center">
                        <button type="submit" class="btn btn-info w-25">Submit</button>
                    </div>
                    </form>
                </div>
                {{-- </div> --}}
            </div>
        </div>
        </div>
        </div>
    </section>
</body>
<script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ asset('asset/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ asset('asset/dist/js/adminlte.min.js') }}"></script>

<script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
    // add row
    $("#addRow").click(function() {
        var html = '';
        html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="countries2">
                    @foreach ($countries as $country)
                    <option value="{{ $country->id }}">{{ $country->name }} +{{ $country->phonecode }}</option>
                    @endforeach
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" 
                    placeholder="Phone Number" id ="phone2" name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

        $('#newRow').append(html);
    });
    // remove row
    $(document).on('click', '#removeRow', function() {
        $(this).closest('#inputFormRow').remove();
    });

    $(document).ready(function() {
        //set initial state.

        $('#hasContract').change(function() {
            if ($(this).is(":checked")) {
                $('#contractData').fadeIn();
                $('#hasContract').val($(this).is(':checked'));
            } else {
                $('#contractData').fadeOut();
            }
        });
    });
</script>

</html>
