@extends ('../welcome')


@section('content')
    <style>
        #upload-photo {
            display: none;
        }

        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>
    <form>
        <div class="card card-info collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div id="left side" class="col-6">
                        <table id="phone&name">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Search</th>
                            </tr>
                            <tr>
                                <th class="col-3">Name: </th>
                                <td class="form-group col-6">
                                    <input name="name" class="form-control" type="text" placeholder="name...">
                                </td>
                            </tr>
                            
                            <tr>
                                <th class="col-3">Country: </th>
                                <td class="form-group col-6">
                                    <select name="country_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            
                            <tr>
                                <th class="col-3">Phone: </th>
                                <td class="form-group col-6">
                                    <input name="phone" class="form-control" type="number" placeholder="phone...">
                                </td>
                            </tr>
                        </table>

                        <hr>
                        <table>
                            <tr>
                                <th class="col-3">Campaigns: </th>
                                <td class="form-group col-6">
                                    <select name="campaign_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($campaigns as $campaign)
                                            <option value="{{ $campaign->id }}">{{ $campaign->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-3" title="Source">Sources: </th>
                                <td class="form-group col-6">
                                    <select name="source_id[]" class="select2 custom-select form-control-border col-8"
                                        multiple>
                                        @foreach ($sources as $source)
                                            <option value="{{ $source->id }}">{{ $source->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div id="right side" class="col-6">
                        <table id="created_at">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Creation at</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group" style="width:225px">
                                    <input type="date" name="date1" value="{{ $_GET['date1'] ?? '' }}"
                                        class="form-control">
                                </td>
                                <td class="form-group" style="width:225px">
                                    <input type="time" value="{{ $_GET['time1'] ?? '' }}" class="form-control"
                                        name="time1">
                                </td>
                            </tr>
                            <tr>
                                <th>To</th>
                                <td class="form-group" style="width:225px">
                                    <input type="date" name="date2" value="{{ $_GET['date2'] ?? '' }}"
                                        class="form-control">
                                </td>
                                <td class="form-group" style="width:225px">
                                    <input type="time" name="time2" value="{{ $_GET['time2'] ?? '' }}"
                                        class="form-control">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div style="text-align:center">
                    <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                    <button type="submit" class="btn btn-info">filter</button>
                </div>
            </div>
        </div>
    </form>

    <div class="card">
        <div class="card-header">
            <button type="button" title="Import" class="btn btn-light dropdown-toggle dropdown-icon" data-toggle="dropdown"
                style="float:right"> Import
                <span class="sr-only">Toggle Dropdown</span>
            </button>
            <div class="dropdown-menu" role="menu">
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('clients-upload'))
                    <a class="dropdown-item" data-toggle="modal" style="float:right" title="upload clients"
                        data-target='#UploadFileModal' href="#">
                        Upload New Clients
                    </a>
                @endif
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('clients-update-sheet'))
                    <a class="dropdown-item" data-toggle="modal" style="float:right" title="update clients"
                        data-target='#ClientSourceImport' href="#">
                        Update Existing Clients
                    </a>
                @endif
                @if (auth()->user()->type == 'admin')
                    <a class="dropdown-item" data-toggle="modal" style="float:right" title="search clients"
                        data-target='#searchImport' href="#">
                        Search Clients
                    </a>
                @endif
            </div>

            @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('clients-archive'))
                <a href="{{ route('clients.archive') }}" style="float:right">
                    <button class="btn btn-outline-success" title="Archive" type="button"><i
                            class="fas fa-archive"></i></button>
                </a>
            @endif
            <div class="card-title">Clients</div>
        </div>
        <div class="card-body">
            <div class="card-title">Total: {{ $clients->total() }}</div>
            <table
                id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('clients-export')? 'example2': 'nonExport' }}
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('clients-phoneNumbers'))
                            @for ($i = 1; $i <= $clientNumbers; $i++)
                                <th>Phone Number {{ $i }}</th>
                            @endfor
                        @endif
                        <th>Created Date</th>
                        <th>Created Time</th>
                        @if (auth()->user()->type == 'admin')
                            <th style="display:none">Action</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clients as $client)
                        <?php $temp = explode(' ', $client->created_at->setTimezone('Africa/Cairo')); ?>

                        <tr>

                            <td>{{ $client->id }}</td>
                            <td>
                                <a href="{{ route('clients.show', $client->id) }}">
                                    {{ $client->name }}
                                </a>
                            </td>
                            <td>{{ $client->email }}</td>
                            <!-- Phone number -->
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('clients-phoneNumbers'))
                                @for ($i = 0; $i < $clientNumbers; $i++)
                                    <td>
                                        {{ $client->phone_numbers[$i]->country->phonecode ?? '--' }}
                                        {{ $client->phone_numbers[$i]->phone ?? '--' }}

                                    </td>
                                @endfor
                            @endif
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>
                            @if (auth()->user()->type == 'admin')
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('clients-edit'))
                                        <a class="btn btn-primary" title="Edit"
                                            href="{{ route('clients.edit', $client->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('clients-delete'))
                                        @if (empty($client->lead) && count($client->units) == 0)
                                            <button onClick="clickDeletebutton(this)" title="Delete"
                                                class="btn btn-danger" data-id="{{ $client->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    @endif
                            @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="pagination">
                {{ $clients->appends(request()->input())->links() }}
            </div>
        </div>
    </div>

    <form action="{{ route('clients.import') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UploadFileModal" tabindex="-1" role="dialog" aria-labelledby="UploadFileModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Clients</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="upload-photo" class="btn btn-outline-info" title="upload image">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" name="file" id="upload-photo" multiple>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>


    <form action="{{ route('ClientSourceImport') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="modal fade" id="ClientSourceImport" tabindex="-1" role="dialog"
            aria-labelledby="ClientSourceImport" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import To Update Clients</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            {{-- <label for="upload-photo" class="btn btn-outline-info" title="upload image">
                                Upload Sheet &nbsp;
                            </label> --}}
                            <input type="file" name="file">
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('searchImport') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="modal fade" id="searchImport" tabindex="-1" role="dialog" aria-labelledby="searchImport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import To Update Clients</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            {{-- <label for="upload-photo" class="btn btn-outline-info" title="upload image">
                                Upload Sheet &nbsp;
                            </label> --}}
                            <input type="file" name="file">
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive Record</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to Archive this Client ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('clients.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
