@extends ('../welcome')

@section('content')
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Contracts</h2>&nbsp;&nbsp;
                <div style="float:right">
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('contracts-create'))
                        <a href="{{ route('contracts.create') }}" title="Create Contract" class="btn btn-outline-light"><i
                                class="fas fa-plus"></i></a>
                    @endif

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('contracts-clientContracts'))
                        <a href="{{ route('ClientContracts') }}" title="Client Contracts" class="btn btn-outline-info"><i
                                class="fas fa-address-card"></i></a>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="card-title">Total: {{ count($contracts) }}</div>
            </div>
            <!-- /.card-body -->
            <div class="card-body">



                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('contracts-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered table-striped" style="margin: unset">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Creation Date</th>
                            <th>Creation Time</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($contracts as $contract)
                            <?php $temp = explode(' ', $contract->created_at->setTimezone('Africa/Cairo')); ?>
                            <tr>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-show'))
                                        <a href="{{ route('contracts.show', $contract->id) }}">
                                            {{ $contract->id }}
                                        </a>
                                    @else
                                        {{ $contract->id }}
                                    @endif
                                </td>
                                <td>
                                    {{ $contract->name }}
                                </td>
                                <td>
                                    {{ $contract->type }}
                                </td>
                                <td>{{ $temp[0] }}</td>
                                <td>{{ $temp[1] }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-print'))
                                        <a class="btn btn-info" title="print"
                                            href="{{ route('printContract', $contract->id) }}">
                                            <i class="fa fa-print"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-edit'))
                                        <a class="btn btn-primary" title="Edit"
                                            href="{{ route('contracts.edit', $contract->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-delete'))
                                        @if (count($contract->contracts) == 0)
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="{{ $contract->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('contracts.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
