<?php

use App\Http\Controllers\API\Auth\GuestController;
use App\Http\Controllers\API\Auth\MemberController;
use App\Http\Controllers\API\Home\HomeController;
use App\Http\Controllers\API\News\NewsController;
use App\Http\Controllers\API\Profile\ProfileGuestController;
use App\Http\Controllers\API\Profile\ProfileMemberController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['namespace' => 'API/Auth'], function () {
    //register for guest 
    Route::post('guest_register', [GuestController::class, 'register'])->name('api.guest.register');
    Route::post('guest_login', [GuestController::class, 'login']);
    Route::post('guest_forgetPassword', [GuestController::class, 'forgetPassword'])->middleware('auth:client');
    Route::post('guest_send_otp_forgetPassword', [GuestController::class, 'send_otp_forgetPassword'])->middleware('auth:client');
    Route::post('guest_change_password', [GuestController::class, 'change_password'])->middleware('auth:client');
    Route::post('guest_logout', [GuestController::class, 'logout'])->middleware('auth:client');
});

Route::group(['namespace' => 'API/Auth'], function () {
    //register for guest 
    Route::post('member_register', [MemberController::class, 'register']);
    Route::post('member_send_otp', [MemberController::class, 'send_otp']);
    Route::post('member_create_password', [MemberController::class, 'createpassword']);
    Route::post('member_login', [MemberController::class, 'login']);
    Route::post('member_forgetPassword', [MemberController::class, 'forgetPassword'])->middleware('auth:client');
    Route::post('member_send_otp_forgetPassword', [MemberController::class, 'send_otp_forgetPassword'])->middleware('auth:client');
    Route::post('member_change_password', [MemberController::class, 'change_password'])->middleware('auth:client');
    Route::post('member_logout', [MemberController::class, 'logout'])->middleware('auth:client');
});


//profile guest
Route::get('profile_guest/{id}', [ProfileGuestController::class, 'show'])->middleware('auth:client');
Route::post('profile_guest/update/{id}', [ProfileGuestController::class, 'update'])->middleware('auth:client');

Route::get('profile_member/{id}', [ProfileMemberController::class, 'show'])->middleware('auth:client');
Route::post('profile_member/update/{id}', [ProfileMemberController::class, 'update'])->middleware('auth:client');




//home page
Route::get('home', [HomeController::class, 'index']);
//news
Route::get('news', [NewsController::class, 'index']);
