<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- IonIcons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('asset/dist/css/adminlte.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" />
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" />
    <link rel="stylesheet" href=" https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    
    

    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js" />

    

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.css"
        integrity="sha512-6S2HWzVFxruDlZxI3sXOZZ4/eJ8AcxkQH1+JjSe/ONCEqR9L4Ysq5JdT5ipqtzU7WHalNwzwBv+iE51gNHJNqQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />



    <title>RFCO CRM</title>
    

    <style>
        .clickable-row:hover {
            /* background-color: #17a2b8; */
            opacity: 0.8;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        div.dataTables_wrapper div.dataTables_length select {
            display: inline-block;
            width: 50px;
        }

        .buttons-excel {
            /*width:40px;*/
        }

        .card-title {
            font-weight: bold;
        }
    </style>
</head>




<body class="hold-transition sidebar-mini">
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav" id="closeBar">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>

            </ul>

            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <!-- Notifications -->
                <li class="nav-item dropdown">
                    <a class="nav-link" data-toggle="dropdown" href="#">
                        <i class="far fa-bell"></i>
                        <?php if(count($alerts) != 0): ?>
                            <span class="badge badge-danger"><?php echo e(count($alerts)); ?></span>
                        <?php endif; ?>
                    </a>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                        <?php $__empty_1 = true; $__currentLoopData = $alerts->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e($alert->link); ?>" class="dropdown-item">
                                <?php echo e($alert->title); ?>

                                <span class="float-left text-sm"><?php echo e(substr($alert->body, 15)); ?>...</span>
                                <span class="float-right text-sm"><?php echo e($alert->created_at); ?></span>
                                
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                        <div class="dropdown-divider"></div>
                        <a href="<?php echo e(route('alerts.index')); ?>" class="dropdown-item dropdown-footer">See All
                            Notifications</a>
                    </div>
                </li>
                <!-- End Notifications -->
                <!-- Notifications Dropdown Menu -->


                <li class="nav-item dropdown">
                    <a class="nav-link" aria-expanded="true" data-toggle="dropdown" href="#">
                        <i class="fa fa-cog"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                        <?php if(Auth::user()->type == 'admin'): ?>
                            <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('unitSettings-create')): ?>
                                <a class="dropdown-item" href="<?php echo e(route('unitSettings.index')); ?>">
                                    Settings
                                </a>
                            <?php endif; ?>

                            <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('activityLog-read')): ?>
                                <a class="dropdown-item" href="<?php echo e(route('logsActivities.index')); ?>">
                                    Activity logs
                                </a>
                            <?php endif; ?>

                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <a class="dropdown-item" href="route('logout')"
                                onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                Logout
                            </a>
                        </form>
                    </div>
                </li>

            </ul>
        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4" id="asidBar">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('dashboard')); ?>" class="brand-link p-4">
                <img src="<?php echo e(asset('asset/dist/img/logo-sd-2.png')); ?>" width="182" height="31"
                    alt="sd Logo"><br>
            </a>

            <!-- Sidebar -->

            <div class="sidebar" id="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="info">
                        <a href="<?php echo e(Route('users.show', auth()->user()->id)); ?>"
                            class="d-block"><?php echo e(Auth::user()->name); ?></a>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <!-- ---------------------------- USERS ----------------------------------- -->

                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('roles-read') ||
                                auth()->user()->role->hasPermission('users-read') ||
                                auth()->user()->role->hasPermission('permissions-read')): ?>
                            <li class="nav-item has-treeview">
                                <!-- <a href="/authorization" class="nav-link"> -->
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-user-lock"></i>
                                    <p>
                                        Users
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('users-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('users.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('users') || request()->is('users/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Users
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('index.roles')); ?>"
                                                class="nav-link <?php echo e(request()->is('roles') || request()->is('roles/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Roles
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('permission-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('index.permissions')); ?>"
                                                class="nav-link <?php echo e(request()->is('permissions') || request()->is('permissions/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Permissions
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <!-- ---------------------------- SALES ----------------------------------- -->

                        <li class="nav-item has-treeview">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-hand-holding-usd"></i>
                                <p>
                                    Sales
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">

                                <li class="nav-item has-treeview">
                                    <!-- <a href="/authorization" class="nav-link"> -->
                                    <a href="#" class="nav-link">
                                        <i class="nav-icon fas fa-users"></i>
                                        <p>
                                            leads
                                            <i class="right fas fa-angle-left"></i>
                                        </p>
                                    </a>
                                    <ul class="nav nav-treeview">
                                        
                                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-read')): ?>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index')); ?>"
                                                    class="nav-link <?php echo e(request()->is('allLeads') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        All Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'fresh'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/fresh') || request()->is('leads/fresh/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Fresh Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'interested'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/interested') || request()->is('leads/interested/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Interested Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'followUp'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/followUp') || request()->is('leads/followUp/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Follow Up Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'fakeNumber'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/fakeNumber') || request()->is('leads/fakeNumber/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Fake Number Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'meeting'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/meeting') || request()->is('leads/meeting/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Meeting Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'pending'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/pending') || request()->is('leads/pending/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Pending Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'lowBudget'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/lowBudget') || request()->is('leads/lowBudget/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Low Budget Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'noRegisteration'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/noRegisteration') || request()->is('leads/noRegisteration/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        No Registeration Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'differentLocation'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/differentLocation') || request()->is('leads/differentLocation/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Different Location Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'closed'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/closed') || request()->is('leads/closed/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Closed Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'callFailed'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/callFailed') || request()->is('leads/callFailed/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        Call Failed Leads
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="<?php echo e(route('leads.index', ['status' => 'noAnswer'])); ?>"
                                                    class="nav-link <?php echo e(request()->is('leads/noAnswer') || request()->is('leads/noAnswer/*') ? 'active' : ''); ?>">
                                                    <i class="nav-icon fas fa-"></i>
                                                    <p>
                                                        No Answer Leads
                                                    </p>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                    </ul>
                                </li>


                                
                                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('communications-read')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('communications.index')); ?>"
                                            class="nav-link <?php echo e(request()->is('communications') || request()->is('communications') ? 'active' : ''); ?>">
                                            <i class="nav-icon fas fa-"></i>
                                            <p>
                                                Actions
                                            </p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('communications-myAction')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('myActions')); ?>"
                                            class="nav-link <?php echo e(request()->is('communications/myActions') || request()->is('communications/myActions') ? 'active' : ''); ?>">
                                            <i class="nav-icon fas fa-"></i>
                                            <p>
                                                My Actions
                                            </p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('communications-nextActions')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('nextActions')); ?>"
                                            class="nav-link <?php echo e(request()->is('nextActions') || request()->is('nextActions/*') ? 'active' : ''); ?>">
                                            <i class="nav-icon fas fa-"></i>
                                            <p>
                                                Actions taking place
                                            </p>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <li class="nav-item">
                                    <a href="<?php echo e(route('calendar.index')); ?>"
                                        class="nav-link <?php echo e(request()->is('calendar') || request()->is('calendar/*') ? 'active' : ''); ?>">
                                        <i class="nav-icon fas fa-"></i>
                                        <p>
                                            Calendar
                                        </p>
                                    </a>
                                </li>
                            </ul>
                        </li>


                        
                        <!-- --------------------------- Brokers ------------------------------------ -->
                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('brokers-read')): ?>
                            <li class="nav-item has-treeview">
                                <!-- <a href="/authorization" class="nav-link"> -->
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-user-secret"></i>
                                    <p>
                                        Brokers
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('brokers-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('brokers.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('brokers') || request()->is('brokers/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    list
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('brokers-create-requestType')): ?>
                                        <!--<li class="nav-item">-->
                                        <!--    <a href="<?php echo e(route('inqTypes.create')); ?>"-->
                                        <!--        class="nav-link <?php echo e(request()->is('inqTypes') || request()->is('inqTypes/*') ? 'active' : ''); ?>">-->
                                        <!--        <i class="nav-icon fas fa-"></i>-->
                                        <!--        <p>-->
                                        <!--            Request Types-->
                                        <!--        </p>-->
                                        <!--    </a>-->
                                        <!--</li>-->
                                    <?php endif; ?>
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('brokers-read-requests')): ?>
                                        <!--<li class="nav-item">-->
                                        <!--    <a href="<?php echo e(route('inquiries.index')); ?>"-->
                                        <!--        class="nav-link <?php echo e(request()->is('inquiries') || request()->is('inquiries/*') ? 'active' : ''); ?>">-->
                                        <!--        <i class="nav-icon fas fa-"></i>-->
                                        <!--        <p>-->
                                        <!--            Requests-->
                                        <!--        </p>-->
                                        <!--    </a>-->
                                        <!--</li>-->
                                    <?php endif; ?>
                                    
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('cil-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('CILs')); ?>"
                                                class="nav-link <?php echo e(request()->is('CILs') || request()->is('CILs/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Cils
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('agents-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('agents.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('agents') || request()->is('agents/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Agents
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('brokers-read-activities')): ?>
                                        <!--<li class="nav-item">-->
                                        <!--    <a href="<?php echo e(route('activityManagment')); ?>"-->
                                        <!--        class="nav-link <?php echo e(request()->is('activityManagment') || request()->is('activityManagment/*') ? 'active' : ''); ?>">-->
                                        <!--        <i class="nav-icon fas fa-"></i>-->
                                        <!--        <p>-->
                                        <!--            Activity Managment-->
                                        <!--        </p>-->
                                        <!--    </a>-->
                                        <!--</li>-->
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>
                        <!-- ---------------------------- Operation ----------------------------------- -->
                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('clients-read') ||
                                auth()->user()->role->hasPermission('contracts-read')): ?>
                            <li class="nav-item has-treeview">
                                <!-- <a href="/authorization" class="nav-link"> -->
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-project-diagram"></i>
                                    <p>
                                        Operation
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('clients.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('clients') || request()->is('clients/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Clients
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('contracts-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('contracts.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('contracts') || request()->is('contracts/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Contracts
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>



                        <!-- -------------------------------------- Marketing ------------------------------------------------ -->
                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-read') ||
                                auth()->user()->role->hasPermission('sources-read') ||
                                auth()->user()->role->hasPermission('sourcesTypes-create')): ?>
                            <li class="nav-item has-treeview">
                                <!-- <a href="/authorization" class="nav-link"> -->
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-comments-dollar"></i>
                                    <p>
                                        Marketing
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview">

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('campaigns-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('campaigns.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('campaigns') || request()->is('campaigns/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>&nbsp;&nbsp;
                                                <p>
                                                    Campaigns
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('sourcesTypes-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('sourceTypes.create')); ?>"
                                                class="nav-link <?php echo e(request()->is('sourceTypes') || request()->is('sourceTypes/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>&nbsp;&nbsp;
                                                <p>
                                                    SourceTypes
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('sources-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('sources.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('sources') || request()->is('sources/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>&nbsp;&nbsp;
                                                <p>
                                                    Sources
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <!-- -------------------------------------- Inventory ------------------------------------------------ -->
                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('projects-read') ||
                                auth()->user()->role->hasPermission('phases-read') ||
                                auth()->user()->role->hasPermission('buildings-read') ||
                                auth()->user()->role->hasPermission('units-read') ||
                                auth()->user()->role->hasPermission('facilities-create') ||
                                auth()->user()->role->hasPermission('settings-create')): ?>
                            <li class="nav-item has-treeview">
                                
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas fa-home"></i>
                                    <p>
                                        Inventory
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                
                                <ul class="nav nav-treeview" style="display: none;">

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('projects-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('projects.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('projects') || request()->is('projects/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Projects
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('phases-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('phases.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('phases') || request()->is('phases/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Phases
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('buildings.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('buildings') || request()->is('buildings/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Buildings
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('units.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('units') || request()->is('units/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Units
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('facilities-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('facilities.create')); ?>"
                                                class="nav-link <?php echo e(request()->is('facilities') || request()->is('facilities/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Facilities
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('settings-create')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('unitSettings.create')); ?>"
                                                class="nav-link <?php echo e(request()->is('unitSettings') || request()->is('unitSettings/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Settings
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>

                        <!-- -------------------------------------- Customer Service ------------------------------------------------ -->
                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-read')): ?>
                            <li class="nav-item has-treeview">
                                <a href="#" class="nav-link">
                                    <i class="nav-icon fas  fa-hand-holding"></i>
                                    <p>
                                        Customer Service
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>
                                <ul class="nav nav-treeview" style="display: none;">
                                    <?php if(Auth::user()->hasRole('cs')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('clients.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('clients') || request()->is('clients/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Clients
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('tickets.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('tickets') || request()->is('tickets/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Tickets
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-delayTickets-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('delayTickets')); ?>"
                                                class="nav-link <?php echo e(request()->is('delayTickets') || request()->is('delayTickets/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Delay Tickets
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-ticketActions-read')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('actions.index')); ?>"
                                                class="nav-link <?php echo e(request()->is('actions') || request()->is('actions/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Ticket Actions
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-ticketTypes-create')): ?>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('ticket-types.create')); ?>"
                                                class="nav-link <?php echo e(request()->is('ticket-types') || request()->is('ticket-types/*') ? 'active' : ''); ?>">
                                                <i class="nav-icon fas fa-"></i>
                                                <p>
                                                    Ticket Types
                                                </p>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper p-3">
            <!-- Main content -->
            <div class="content">
                <div class="container-fluid">
                    <div class="row" style="display: block;">
                        <?php if(session()->has('success')): ?>
                            <div class="alert alert-success">
                                <ul>
                                    <h5><?php echo e(session()->get('success')); ?></h5>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if(session()->has('error')): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <h5><?php echo e(session()->get('error')); ?></h5>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if($errors->all()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php if(session()->has('leadsErrors')): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = session()->get('leadsErrors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                                <p> <?php echo e(count(session()->get('leadsErrors'))); ?> rows have dublicate </p>
                                <?php
                                    session()->forget('leadsErrors');
                                ?>
                            </div>
                        <?php endif; ?>
                        <?php echo e(Breadcrumbs::render()); ?>

                        <!-- /.col-md-6 -->
                        <!--<?php echo e(\URL::current()); ?>-->
                        <?php echo $__env->yieldContent('content'); ?>
                        <!-- /.col-md-6 -->
                    </div>
                    <!-- /.row -->
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->

        <!-- Main Footer -->
        <footer class="main-footer">
            <strong>Copyright &copy; 2022 <a href="https://sdsolutionseg.com/">SD-Solutions</a>.</strong> All rights
            reserved.
            <div class="float-right d-none d-sm-inline-block">
                <!-- <b>Version</b> 3.2.0 -->
            </div>
        </footer>
    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    
    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>


    <!-- Bootstrap -->
    <script src="<?php echo e(asset('asset/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('bootstrap/js/bootstrap.js')); ?>"></script>

    <!-- AdminLTE -->
    <script src="<?php echo e(asset('asset/dist/js/adminlte.js')); ?>"></script>

    <!-- OPTIONAL SCRIPTS -->
    <script src="<?php echo e(asset('asset/plugins/chart.js/Chart.min.js')); ?>"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
    <script src="<?php echo e(asset('asset/dist/js/pages/dashboard3.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/select2/js/select2.full.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
    
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js"
        integrity="sha512-lbwH47l/tPXJYG9AcFNoJaTMhGvYWhVM9YI43CT+uteTRRaiLCui8snIgyAN8XWgNjNhCqlAUdzZptso6OCoFQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.3.5/axios.min.js"></script>
    <script src="<?php echo e(asset('fetch/fetch.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('script'); ?>

    <script>
        //Initialize Select2 Elements
        $('.select2').select2({
            theme: 'bootstrap4'
        })

        $(function() {
            var url = window.location;
            // for sidebar menu and treeview
            $('ul.nav-treeview a').filter(function() {
                    return this.href == url;
                }).parentsUntil(".nav-sidebar > .nav-treeview")
                .css({
                    'display': 'block'
                })
                .addClass('menu-open').prev('a');
            // .addClass('active');
        });




        // Leads Index Page
        $("#selectAll").click(function() {
            $(".checkboxAll").prop('checked', $(this).prop('checked'));
        });


        // Calendar Setup and Functionalty
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            const date = new Date();
            const formattedDate = date.toISOString().split('T')[0];

            // initialize calendar in all events
            var calendar = $('#calendar').fullCalendar({
                editable: true,
                events: "<?php echo e(route('calendar.index')); ?>",
                displayEventTime: false,
                eventRender: function(event, element, view) {
                    var start = new Date(event.start);
                    const startFormattedDate = start.toISOString().split('T')[0];

                    if (event.allDay === 'true') {
                        event.allDay = true;
                    } else {
                        event.allDay = false;
                    }
                    if (event.communications.state == 'done') {
                        element.css('background-color', 'green');
                    } else if (event.communications.state == 'planned' && startFormattedDate >=
                        formattedDate) {
                        element.css('background-color', 'rgb(70, 130, 180)');
                    } else {
                        element.css('background-color', 'red');
                    }
                },
                // eventColor: '#378006',
                selectable: true,
                selectHelper: true,
                select: function(start, end, allDay) {
                    var event_name = prompt('Event Name:');
                    if (event_name) {
                        var start = $.fullCalendar.formatDate(start, "YYYY-MM-DD HH:mm:ss");
                        var end = $.fullCalendar.formatDate(end, "YYYY-MM-DD HH:mm:ss");
                        $.ajax({
                            url: "<?php echo e(route('calendar.create')); ?>",
                            data: {
                                title: event_name,
                                start: start,
                                end: end
                            },
                            type: 'post',
                            success: function(data) {
                                iziToast.success({
                                    position: 'topRight',
                                    message: 'Event created successfully.',
                                });

                                calendar.fullCalendar('renderEvent', {
                                    id: data.id,
                                    title: event_name,
                                    start: start,
                                    end: end,
                                    allDay: allDay
                                }, true);
                                calendar.fullCalendar('unselect');
                            }
                        });
                    }
                },
                eventDrop: function(event, delta) {
                    var start = $.fullCalendar.formatDate(event.start, "YYYY-MM-DD");
                    var end = $.fullCalendar.formatDate(event.end, "YYYY-MM-DD");

                    $.ajax({
                        url: "<?php echo e(route('calendar.edit')); ?>",
                        data: {
                            title: event.title,
                            start: start,
                            end: end,
                            id: event.id,
                        },
                        type: "put",
                        success: function(response) {
                            console.log(response);
                            iziToast.success({
                                position: 'topRight',
                                message: 'Event updated successfully.',
                            });
                        }
                    });
                },
                eventClick: function(event) {
                    var url = window.location.origin;
                    console.log(url);
                    $.each(event.communications, function(index, element) {
                        if (index == 'lead_id') {
                            window.location.assign(url + "/demo/public/leads/show/" +
                                element);
                        }

                    });
                }
            });

            $('#example1 thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#example1 thead');

            var table = $('#example1').DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": true,
                "buttons": ["excel", "colvis"],
                orderCellsTop: true,
                fixedHeader: false,
                "scrollX": true,
                "paging": false,
                initComplete: function() {
                    var api = this.api();

                    // For each column
                    api
                        .columns()
                        .eq(0)
                        .each(function(colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');

                            // On every keypress in this input
                            $('input',
                                    $('.filters th').eq($(api.column(colIdx).header()).index())
                                )
                                .off('keyup change')
                                .on('change', function(e) {
                                    // Get the search value
                                    $(this).attr('title', $(this).val());
                                    var regexr =
                                        '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    // Search the column for that value
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != '' ?
                                            regexr.replace('{search}', '(((' + this.value +
                                                ')))') :
                                            '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();
                                })
                                .on('keyup', function(e) {
                                    e.stopPropagation();

                                    $(this).trigger('change');
                                    $(this).focus()[0].setSelectionRange(cursorPosition,
                                        cursorPosition);
                                });
                        });
                },
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            $('#nonExport thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#nonExport thead');

            var table = $('#nonExport').DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": true,
                "buttons": ["colvis"],
                orderCellsTop: true,
                fixedHeader: false,

                "scrollX": true,
                "paging": false,
                initComplete: function() {
                    var api = this.api();

                    // For each column
                    api
                        .columns()
                        .eq(0)
                        .each(function(colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');

                            // On every keypress in this input
                            $('input',
                                    $('.filters th').eq($(api.column(colIdx).header()).index())
                                )
                                .off('keyup change')
                                .on('change', function(e) {
                                    // Get the search value
                                    $(this).attr('title', $(this).val());
                                    var regexr =
                                        '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    // Search the column for that value
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != '' ?
                                            regexr.replace('{search}', '(((' + this.value +
                                                ')))') :
                                            '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();
                                })
                                .on('keyup', function(e) {
                                    e.stopPropagation();

                                    $(this).trigger('change');
                                    $(this).focus()[0].setSelectionRange(cursorPosition,
                                        cursorPosition);
                                });
                        });
                },
            }).buttons().container().appendTo('#nonExport_wrapper .col-md-6:eq(0)');



            var table = $('#ProjectsAll').DataTable({
                    'dom': "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'<'float-md-right ml-2'B>f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    'ajax': 'get-projects',
                    'buttons': ['excel', {
                        'text': '<i class="fa fa-id-badge fa-fw" aria-hidden="true"></i>',
                        'action': function(e, dt, node) {

                            $(dt.table().node()).toggleClass('cards');
                            $('.fa', node).toggleClass(['fa-table', 'fa-id-badge']);

                            dt.draw('page');
                        },
                        'className': 'btn-sm',
                        'attr': {
                            'title': 'Change views',
                        }
                    }],
                    'select': 'single',
                    'columns': [{
                            'orderable': false,
                            'data': null,
                            'className': 'text-center',
                            'render': function(data, type, full, meta) {
                                if (type === 'display') {
                                    var id = data.id;
                                    var image = data.logo;
                                    var url = window.location.href;
                                    data =
                                        '<a href=" ' + url + '/' + id + '"' +
                                        '> <img src=' + image +
                                        ' class="avatar border rounded-circle"></a>';
                                }
                                return data;
                            }
                        },
                        {
                            'data': 'id'
                        },
                        {
                            'data': 'name'
                        },
                        {
                            'data': 'description'
                        },
                        {
                            'data': 'is_residential',
                        },
                        {
                            'data': 'is_active',
                        },

                    ],
                    'drawCallback': function(settings) {
                        var api = this.api();
                        var $table = $(api.table().node());

                        if ($table.hasClass('cards')) {

                            // Create an array of labels containing all table headers
                            var labels = [];
                            $('thead th', $table).each(function() {
                                labels.push($(this).text());
                            });

                            // Add data-label attribute to each cell
                            $('tbody tr', $table).each(function() {
                                $(this).find('td').each(function(column) {
                                    $(this).attr('data-label', labels[column]);
                                });
                            });

                            var max = 0;
                            $('tbody tr', $table).each(function() {
                                max = Math.max($(this).height(), max);
                            }).height(max);

                        } else {
                            // Remove data-label attribute from each cell
                            $('tbody td', $table).each(function() {
                                $(this).removeAttr('data-label');
                            });

                            $('tbody tr', $table).each(function() {
                                $(this).height('auto');
                            });
                        }
                    }
                })
                .on('select', function(e, dt, type, indexes) {
                    var rowData = table.rows(indexes).data().toArray()
                    $('#row-data').html(JSON.stringify(rowData));
                })
                .on('deselect', function() {
                    $('#row-data').empty();
                });


            new DataTable('#leadsAll', {
                // responsive: false,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": [{
                        extend: 'excel',
                        text: 'Export All Leads',
                        exportOptions: {
                            modifier: {
                                page: 'all'
                            }
                        }
                    },
                    "colvis"
                ],
                orderCellsTop: true,
                fixedHeader: false,
                pagingType: 'full_numbers',
                "scrollX": true,
                "paging": false,
                "columnDefs": [{
                    "max-width": "20px",
                    "targets": 0
                }]
            }).buttons().container().appendTo('#original_wrapper .col-md-6:eq(0)');


            new DataTable('#original', {
                // responsive: false,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": [{
                        text: 'Export All Leads',
                        action: function(e, dt, button, config) {
                            let currentUrl = window.location.href;
                            let exportUrl = currentUrl + '/leads/export';
                            window.location.href = exportUrl;
                        }
                    },
                    "excel",
                    "colvis"
                ],
                orderCellsTop: true,
                fixedHeader: false,
                pagingType: 'full_numbers',
                "scrollX": true,
                "paging": false,
                "columnDefs": [{
                    "max-width": "20px",
                    "targets": 0
                }]
            }).buttons().container().appendTo('#original_wrapper .col-md-6:eq(0)');

            new DataTable('#original-nonExport', {
                // responsive: false,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["colvis"],
                orderCellsTop: true,
                fixedHeader: false,
                pagingType: 'full_numbers',
                "scrollX": true,
                "paging": false,
                "columnDefs": [{
                    "max-width": "20px",
                    "targets": 0
                }]
            }).buttons().container().appendTo('#original-nonExport_wrapper .col-md-6:eq(0)');



            $('#example2 thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#example2 thead');

            var table = $('#example2').DataTable({
                responsive: true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["excel", "colvis"],
                orderCellsTop: true,
                fixedHeader: false,
                pagingType: 'full_numbers',
                "scrollX": true,
                "paging": false,
                initComplete: function() {
                    var api = this.api();

                    // For each column
                    api
                        .columns()
                        .eq(0)
                        .each(function(colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');

                            // On every keypress in this input
                            $('input',
                                    $('.filters th').eq($(api.column(colIdx).header()).index())
                                )
                                .off('keyup change')
                                .on('change', function(e) {
                                    // Get the search value
                                    $(this).attr('title', $(this).val());
                                    var regexr =
                                        '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    // Search the column for that value
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != '' ?
                                            regexr.replace('{search}', '(((' + this.value +
                                                ')))') :
                                            '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();
                                })
                                .on('keyup', function(e) {
                                    e.stopPropagation();

                                    $(this).trigger('change');
                                    $(this).focus()[0].setSelectionRange(cursorPosition,
                                        cursorPosition);
                                });
                        });
                },
            }).buttons().container().appendTo('#example2_wrapper .col-md-6:eq(0)');

        });

        $(".access_type").change(function() {
            if ($(".access_type").val() == 'users') {
                $(".users").show();
                $('.roles option:selected').remove();
                $(".roles").hide();

            }
            if ($(".access_type").val() == 'roles') {
                $(".roles").show();
                $('.users option:selected').remove();
                $(".users").hide();
            }

        });
        $('#activities thead tr')
            .clone(true)
            .addClass('filters')
            .appendTo('#activities thead');

        var table = $('#activities').DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": true,
            "buttons": ["copy", "excel", "pdf", "colvis"],
            orderCellsTop: true,
            fixedHeader: false,

            "scrollX": true,
            "paging": false,
            initComplete: function() {
                var api = this.api();

                // For each column
                api
                    .columns()
                    .eq(0)
                    .each(function(colIdx) {
                        // Set the header cell to contain the input element
                        var cell = $('.filters th').eq(
                            $(api.column(colIdx).header()).index()
                        );
                        var title = $(cell).text();
                        $(cell).html('<input type="text" placeholder="' + title + '" />');

                        // On every keypress in this input
                        $('input',
                                $('.filters th').eq($(api.column(colIdx).header()).index())
                            )
                            .off('keyup change')
                            .on('change', function(e) {
                                // Get the search value
                                $(this).attr('title', $(this).val());
                                var regexr =
                                    '({search})'; //$(this).parents('th').find('select').val();

                                var cursorPosition = this.selectionStart;
                                // Search the column for that value
                                api
                                    .column(colIdx)
                                    .search(
                                        this.value != '' ?
                                        regexr.replace('{search}', '(((' + this.value +
                                            ')))') :
                                        '',
                                        this.value != '',
                                        this.value == ''
                                    )
                                    .draw();
                            })
                            .on('keyup', function(e) {
                                e.stopPropagation();

                                $(this).trigger('change');
                                $(this).focus()[0].setSelectionRange(cursorPosition,
                                    cursorPosition);
                            });
                    });
            },
        }).buttons().container().appendTo('#activities_wrapper .col-md-6:eq(0)');

        $('#analysis thead tr')
            .clone(true)
            .addClass('filters')
            .appendTo('#analysis thead');

        var table = $('#analysis').DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": true,
            "buttons": ["copy", "excel", "pdf", "colvis"],
            orderCellsTop: true,
            fixedHeader: false,

            "scrollX": true,
            "paging": false,
            initComplete: function() {
                var api = this.api();

                // For each column
                api
                    .columns()
                    .eq(0)
                    .each(function(colIdx) {
                        // Set the header cell to contain the input element
                        var cell = $('.filters th').eq(
                            $(api.column(colIdx).header()).index()
                        );
                        var title = $(cell).text();
                        $(cell).html('<input type="text" placeholder="' + title + '" />');

                        // On every keypress in this input
                        $('input',
                                $('.filters th').eq($(api.column(colIdx).header()).index())
                            )
                            .off('keyup change')
                            .on('change', function(e) {
                                // Get the search value
                                $(this).attr('title', $(this).val());
                                var regexr =
                                    '({search})'; //$(this).parents('th').find('select').val();

                                var cursorPosition = this.selectionStart;
                                // Search the column for that value
                                api
                                    .column(colIdx)
                                    .search(
                                        this.value != '' ?
                                        regexr.replace('{search}', '(((' + this.value +
                                            ')))') :
                                        '',
                                        this.value != '',
                                        this.value == ''
                                    )
                                    .draw();
                            })
                            .on('keyup', function(e) {
                                e.stopPropagation();

                                $(this).trigger('change');
                                $(this).focus()[0].setSelectionRange(cursorPosition,
                                    cursorPosition);
                            });
                    });
            },
        }).buttons().container().appendTo('#analysis_wrapper .col-md-6:eq(0)');


        $(document).on('click', '#unit', function() {
            console.log('here');
            // document.getElementById("#unit").value = $('#unit option:selected').val();
            // console.log($('#unit').val());
        });

        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });

        $(document).on('click', '.buttons-excel', function() {
            var url = window.location.pathname;
            var user = <?php echo json_encode(auth()->user()); ?>;
            var userId = user.id;
            $.ajax({
                data: {
                    'url': url,
                    'userId': user.id
                },

                method: "POST",
                url: "<?php echo e(route('exportLog')); ?>",

                success: alert('log stored successfully'),
            });

        });
    </script>
</body>

</html>
<?php /**PATH /home/rfg/public_html/demo/resources/views////welcome.blade.php ENDPATH**/ ?>