


<?php $__env->startSection('content'); ?>
    <style>
        #upload-photo {
            display: none;
        }
    </style>
    
    <form>
        <div class="card card-info card-outline collapsed-card col-12">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <label class="col-12">Sales Man</label>
                        <div class="form-group col-12">
                            <select name="salesMan_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <label class="col-12">Brokers</label>
                        <div class="form-group col-12">
                            <select name="broker_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $totalBrokers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $broker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($broker->id); ?>"><?php echo e($broker->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <label class="col-12">Agents</label>
                        <div class="form-group col-12">
                            <select name="agent_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($agent->id); ?>"><?php echo e($agent->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <label class="col-12">Status</label>
                        <div class="form-group col-12">
                            <select name="status[]" class="select2 custom-select form-control-border" multiple>
                                <option value="pending">Pending</option>
                                <option value="accepted">Accepted</option>
                                <option value="rejected">Rejected</option>
                            </select>
                        </div>
                        <h5 class="text-info">Created At</h5>
                        <div class="row">
                            <label class="col-6" for="created_at_from">From:</label>
                            <label class="col-6" for="created_at_to">To:</label>
                        </div>
                        <div class="form-group row">
                            <input id="created_at_from" type="date" name="created_at_from" class="form-control col-6">
                            <input id="created_at_to" type="date" name="created_at_to" class="form-control col-6">
                        </div>
                        <h5 class="text-info">Updated At</h5>
                        <div class="row">
                            <label class="col-6" for="updated_at_from">From:</label>
                            <label class="col-6" for="updated_at_to">To:</label>
                        </div>
                        <div class="form-group row">
                            <input id="updated_at_from" type="date" name="updated_at_from" class="form-control col-6">
                            <input id="updated_at_to" type="date" name="updated_at_to" class="form-control col-6">
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div style="text-align:center">
                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info">filter</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    

    <div class="card">
        <div class="card-header">
            <?php if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('brokers-archive')): ?>
                <a href="<?php echo e(route('brokersArchive')); ?>" style="float:right">
                    <button class="btn btn-outline-success" title="Archive" type="button"><i
                            class="fas fa-archive"></i></button>
                </a>
            <?php endif; ?>
            <?php if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('brokers-import')): ?>
                <a class="btn btn-outline-info" data-toggle="modal" style="float:right" title="upload Brokers"
                    onClick="clickbutton(this)" data-target='#UploadFileModal' href="#">
                    <i class="fas fa-file-import"></i>
                </a>
            <?php endif; ?>
            <?php if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('brokers-create')): ?>
                <a href="<?php echo e(route('brokers.create')); ?>" style="float:right">
                    <button class="btn btn-square btn-outline-light" title="create Broker" type="button"><i
                            class="fas fa-plus"></i></button>
                </a>
            <?php endif; ?>
            <div class="btn-group">
                <button type="button" class="btn btn-default">Brokers</button>
                <button type="button" title="bulk action" class="btn btn-light active dropdown-toggle dropdown-icon"
                    data-toggle="dropdown">
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <div class="dropdown-menu" role="menu">
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('brokers-assignAgents')): ?>
                        <a class="dropdown-item" data-toggle="modal" onClick="clickbutton(this)"
                            data-target='#assignedAgentModal' href="#">Assign Agent</a>
                    <?php endif; ?>
                    
                    <input type="hidden" value="http://127.0.0.1:8000/broker/registeration" id="myInput">
                    <button class="dropdown-item" onclick="copyFunction()">Registration Link</button>
                </div>
            </div>
            
        </div>
        <div class="card-body">
            <div style="font-weight:bold; font-size:20px">Total: <?php echo e(count($totalBrokers)); ?></div>
            <div style="font-weight:bold; font-size:20px">Pending: <?php echo e($brokers->where('status', 'pending')->count()); ?>

            </div>
            <div style="font-weight:bold; font-size:20px">Accepted: <?php echo e($brokers->where('status', 'accepted')->count()); ?>

            </div>

            <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('brokers-export') ? 'example2' : 'nonExport'); ?> 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>status</th>
                        <?php for($i = 1; $i <= $brokerNumbers; $i++): ?>
                            <th>Phone Number <?php echo e($i); ?></th>
                        <?php endfor; ?>
                        <th>type</th>
                        <th>Agents</th>
                        <th>Sales Admin</th>
                        <th>Authorized Name</th>
                        <th>Sales Man</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <?php if(auth()->user()->type == 'admin'): ?>
                            <th style="display:none">Action</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $brokers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $broker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $temp = explode(' ', $broker->created_at->setTimezone('Africa/Cairo')); ?>
                        <tr>
                            <td>
                                <input type="checkbox" id="chk_broker" class="checkboxAll sub_chk"
                                    data-id="<?php echo e($broker->id); ?>">
                            </td>
                            <td><?php echo e($broker->id); ?></td>
                            <td>
                                <?php if(auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('brokers-create')): ?>
                                    <a href="<?php echo e(route('brokers.show', $broker->id)); ?>">
                                        <?php echo e($broker->name); ?>

                                    </a>
                                <?php else: ?>
                                    <?php echo e($broker->name); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($broker->email); ?></td>
                            <td><?php echo e($broker->status); ?></td>
                            <!-- Phone number -->
                            <?php for($i = 0; $i < $brokerNumbers; $i++): ?>
                                <td>
                                    <?php echo e($broker->phone_numbers[$i]->country->phonecode ?? '--'); ?>

                                    <?php echo e($broker->phone_numbers[$i]->phone ?? '--'); ?>


                                </td>
                            <?php endfor; ?>

                            <td><?php echo e($broker->type); ?></td>
                            <td>
                                <?php $__currentLoopData = $broker->agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('agents.show', $agent->id)); ?>"><?php echo e($agent->name); ?></a> ,
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td><?php echo e($broker->sales_admin); ?></td>
                            <td><?php echo e($broker->authorized_name); ?></td>
                            <td><?php echo e($broker->salesMan?->name); ?></td>
                            <td><?php echo e($temp[0]); ?></td>
                            <td><?php echo e($temp[1]); ?></td>
                            <?php if(auth()->user()->type == 'admin'): ?>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-edit')): ?>
                                        <a class="btn btn-info" title="Edit"
                                            href="<?php echo e(route('brokers.edit', $broker->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if(count($broker->agents) == 0 || count($broker->communications) == 0 || count($broker->leads) || count($agent->inquiries) == 0): ?>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('brokers-delete')): ?>
                                            <button onClick="clickDeletebutton(this)" title="Delete"
                                                class="btn btn-danger" data-id="<?php echo e($broker->id); ?>" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    </div>

    <form action="<?php echo e(route('brokers.import')); ?>" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UploadFileModal" tabindex="-1" role="dialog" aria-labelledby="UploadFileModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import brokers</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="upload-photo" class="btn btn-outline-info" title="upload image">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" id="upload-photo" name="file">
                        </div>
                    </div>
                    <?php echo csrf_field(); ?>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>


    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive Record</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to Archive this broker ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>
    
    <div id="assignedAgentModal" class="modal fade">
        <div class="modal-dialog">
            <form id="leadData1">
                <div class="modal-content">
                    <div class="modal-body">
                        <select name="agent_id" class="select2 custom-select form-control-border" id="agent_id">

                            <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($agent->id); ?>">
                                    <?php echo e($agent->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary yes" type="button">Submit</button>
                </div>
            </form>
        </div>
    </div>
    

    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script>
        // Copy To Cliboard
        function copyFunction() {
            console.log('copyText');
            var copyText = document.getElementById("myInput");
            copyText.select();
            navigator.clipboard.writeText(copyText.value);
            alert("Copied the text: " + copyText.value);
        }

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('brokers.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        clickbutton = (e) => {
            var brokerIds = $('.sub_chk:checkbox:checked').map(function() {
                return $(this).data('id')
            }).get();
            console.log(brokerIds);
            var route = "<?php echo e(route('brokerBulkAction', ':id')); ?>";
            route = route.replace(':id', brokerIds);
            $('#assignedAgentModal').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/brokers/index.blade.php ENDPATH**/ ?>