


<?php $__env->startSection('content'); ?>
    <div class="card card-info card-outline collapsed-card col-12">
        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class='col-6'>
                        <div class="col-12">
                            <div class="form-group">
                                <label>Projects</label>

                                <select name="project_id[]" class="select2 custom-select form-control-border" multiple>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Campaigns</label>

                                <select name="campaign_id[]" class="select2 custom-select form-control-border" multiple>
                                    <?php $__currentLoopData = $allCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaignn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($campaignn->id); ?>"><?php echo e($campaignn->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status[]" class="select2 custom-select form-control-border" multiple>
                                    <option value="planning">Planning</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">In-Active</option>
                                    <option value="complete">Complete</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" class="form-control" value="<?php echo e($_GET['time1'] ?? ''); ?>"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="<?php echo e($_GET['time2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="<?php echo e($_GET['date1'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="<?php echo e($_GET['date2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>
                        <label>Budget Range</label>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="text" name="budget1" value="<?php echo e($_GET['budget1'] ?? ''); ?>" value="1"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="text" name="budget2" value="<?php echo e($_GET['budget2'] ?? ''); ?>" placeholder="L.E"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:right">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- End filters -->

    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Campaigns</div> 
                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('campaigns-create')): ?>
                    <a href="<?php echo e(route('campaigns.create')); ?>">
                        <button class="btn btn-square btn-light active" type="button"
                            style="float:left; margin-left:20px;"><i class="fas fa-plus"></i></button>
                    </a>
                <?php endif; ?>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="card-title">Total: <?php echo e($campaigns->total()); ?></div>
            </div>
            <div class="card-body">
                <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('campaigns-export') ? 'example1' : 'nonExport'); ?> 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Status</th>
                            <th>Budget</th>
                            <th>Target</th>
                            <th>Purpose</th>
                            <th>Project</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $campaign->created_at); ?>

                            <tr>
                                <td><?php echo e($campaign->id); ?></td>
                                <td><?php echo e($campaign->name); ?></td>
                                <td><?php echo e($campaign->status); ?></td>
                                <td><?php echo e($campaign->budget); ?></td>
                                <td><?php echo e($campaign->target ?? ''); ?></td>
                                <td><?php echo e($campaign->purpose ?? ''); ?></td>
                                <?php if(!empty($campaign->project)): ?>
                                    <td>
                                        <a href="<?php echo e(route('projects.show', $campaign->project->id)); ?>">
                                            <?php echo e($campaign->project->name); ?>

                                        </a>
                                    </td>
                                <?php else: ?>
                                    <td></td>
                                <?php endif; ?>
                                <td><?php echo e($temp[0]); ?></td>
                                <td><?php echo e($temp[1]); ?></td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-edit')): ?>
                                        <a class="btn btn-primary" title="Edit"
                                            href="<?php echo e(route('campaigns.edit', $campaign->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-show')): ?>
                                        <a class="btn btn-warning" title="Show"
                                            href="<?php echo e(route('campaigns.show', $campaign->id)); ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-delete')): ?>
                                        <?php if(count($campaign->leads) == 0 && count($campaign->sources) == 0): ?>
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="<?php echo e($campaign->id); ?>" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
                <div class="pagination">
                    <?php echo e($campaigns->appends(request()->input())->links()); ?>

                </div>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('campaigns.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        function updateTextInput(val) {
            document.getElementById('textInput').value = val;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/campaigns/index.blade.php ENDPATH**/ ?>