
<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('swiper/swiper.css')); ?>">
    <style>
        .clickable-row:hover {
            background-color: #fff;
            color: black;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        #upload-photo {
            display: none;
        }

        #upload-file {
            display: none;
        }

        #carouselExampleControls .btn {
            position: absolute;
            top: 0%;
            right: 0%;
            background-color: transparent;

            opacity: 0.5;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: grey;
        }

        .w-100 {
            height: 400px !important
        }

        #carouselExampleControls .btn:hover {
            background-color: transparent;
            opacity: 3.0;
            color: white;
        }

        /* swiper ////////////////////////////////////*/
        .swiper {
            width: 240px;
            height: 320px;
        }

        .swiper .swiper-slide {
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 18px;
            font-size: 22px;
            font-weight: bold;
            color: #fff;
        }


        .swiper2 {
            width: 100%;
            padding-top: 50px;
            padding-bottom: 50px;
        }

        .swiper2 .swiper-slide {
            background-position: center;
            background-size: cover;
            width: 300px;
            height: 300px;
        }

        .swiper2 .swiper-slide img {
            display: block;
            width: 100%;
        }
    </style>

    
    <div class="card card-info card-outline">
        <div class="card-header">
            <div class="row">
                <form action="<?php echo e(route('ClientfileUpload')); ?>" method="POST" enctype="multipart/form-data" class="">
                    <?php echo csrf_field(); ?>
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-uploadImages')): ?>
                        <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                            <i class="fas fa-file-image"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="images[]" id="upload-photo" multiple>
                    <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-uploadFiles')): ?>
                        <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                            <i class="fas fa-file-pdf"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="files[]" id="upload-file" multiple>
                    <?php endif; ?>

                    <input type="hidden" value="<?php echo e($client->id); ?>" name="client_id">

                    <button type="submit" title="upload" style="margin-bottom:10px;" class="btn btn-outline-info"><i
                            class="fas fa-check"></i></button>
                </form>


                <div class="col-7"></div>
                <?php if(empty($client->lead)): ?>
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-toLead')): ?>
                        <a href="<?php echo e(route('toLead', $client->id)); ?>" style="float:right">
                            <button class="btn btn-square btn-outline-success" title=" Convert to lead" type="button"
                                style="float:right;">
                                <i class="fas fa-recycle"></i>
                            </button>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-edit')): ?>
                    <a href="<?php echo e(route('clients.edit', $client->id)); ?>" style="float:right">
                        <button class="btn btn-square btn-outline-info" title=" Edit Client" type="button"
                            style="float:right;">
                            <i class="fas fa-pen"></i>
                        </button>
                    </a>
                <?php endif; ?>

                <?php if($freeUnits == 0): ?>
                    <a href="" style="float:right">
                        <button class="btn btn-square btn-outline-light" title="There is no available units right now"
                            type="button" style="float:right;" disabled>
                            <i class="fas fa-door-closed"></i>
                        </button>
                    </a>
                <?php else: ?>
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-makeReservation')): ?>
                        <a href="<?php echo e(route('Reservation.form', $client->id)); ?>" style="float:right">
                            <button class="btn btn-square btn-outline-dark" title=" Make Reservation" type="button"
                                style="float:right;">
                                <i class="fas fa-door-open"></i>
                            </button>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>

            </div>
        </div>
        <div class="card-body">
            <div class="row">
                
                <div class="card col-5">
                    <div class="card-body">
                        <table>
                            <tr>
                                <th>Name :</th>
                                <td><?php echo e($client->name ?? '-'); ?></td>
                            </tr>
                            <?php if($client->lead): ?>
                                <tr>
                                    <th>Lead :</th>
                                    <td>
                                        <a href="<?php echo e(route('leads.show', $client->lead->id)); ?>">
                                            Lead History
                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Email :</th>
                                <td><?php echo e($client->email ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Job Title :</th>
                                <td><?php echo e($client->job_title ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Came From :</th>
                                <td><?php echo e($client->came_from ?? '-'); ?></td>
                            </tr>
                            <?php if($client->source_id != null && $client->campaign_id != null): ?>
                                <tr>
                                    <th>Campaign :</th>
                                    <td>
                                        <a href="<?php echo e(route('campaigns.show', $client->campaign_id)); ?>">
                                            <?php echo e($client->campaign->name); ?>

                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Source :</th>
                                    <td>
                                        <a href="<?php echo e(route('sources.show', $client->source_id)); ?>">
                                            <?php echo e($client->source->name); ?>

                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Status :</th>
                                <td><?php echo e($client->status ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Civil ID Date :</th>
                                <td><?php echo e($client->civil_date ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Civil ID City :</th>
                                <td><?php echo e($client->civil_city ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Civil ID Number :</th>
                                <td><?php echo e($client->civil_number ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Civil ID Address :</th>
                                <td><?php echo e($client->civil_address ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Nationality :</th>
                                <td><?php echo e($client->nationality ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <th>Assigned To :</th>
                                <td><?php echo e($client->user ? $client->user->name : '-'); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="col-7">
                    
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-phoneNumbers')): ?>
                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-create-PhoneNumber')): ?>
                            <button type="button" class="btn btn-" style="float:right;color:#17a2b8" title="add new number"
                                data-toggle="modal" data-target="#storePhones">
                                <i class="fas fa-phone"></i>
                                <i class="fas fa-plus"></i>
                            </button>
                            <br>
                        <?php endif; ?>

                        <div class="card card-info card-outline" style="margin-top:17px">
                            <div class="card-body table-responsive p-0">
                                <table class="table table-hover text-nowrap">
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $client->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>+<?php echo e($phone->country->phonecode); ?> <?php echo e($phone->phone); ?></td>
                                                <td>
                                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-edit-phoneNumber')): ?>
                                                        <a class="btn btn-light"
                                                            href="<?php echo e(route('phones.edit', $phone->id)); ?>">
                                                            <i class="fas fa-pen" style="color:#17a2b8"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if(count($client->phone_numbers) > 1): ?>
                                                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-delete-phoneNumber')): ?>
                                                            <button onClick="clickDeletePhone(this)" title="Delete"
                                                                type="button" style="height:38px;" class="btn btn-light"
                                                                data-id="<?php echo e($phone->id); ?>" data-toggle="modal"
                                                                data-target="#phoneDelete">
                                                                <i class="fa fa-trash" style="color:#dc3545"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-AccessUsers')): ?>
                        <div class="card card-info card-outline">
                            <div class="card-header">
                                Access Users
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('AccessUsers')); ?>" method="post" id="AssignForm">
                                    <?php echo csrf_field(); ?>

                                    <div class="row">
                                        <div class="form-group col-9">
                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                            <select name="user_id[]" class="select2 custom-select form-control-border"
                                                id="user_id" multiple>
                                                <option value=""></option>
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(in_array($user->id, $clientUsers)): ?>
                                                        <option value="<?php echo e($user->id); ?>" selected><?php echo e($user->name); ?>

                                                        </option>
                                                    <?php else: ?>
                                                        <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-2">
                                            <button type="submit" title="User with deadline"
                                                class="btn btn-outline-info">
                                                <i class="fas fa-check" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-units')): ?>
                        <div class="card card-info card-outline collapsed-card">
                            <div class="card-header" data-card-widget="collapse">
                                <div class="card-text">Units</div>
                            </div>
                            <div class="card-body">
                                <ul>
                                    <?php $__currentLoopData = $client->units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <div class="form-group col-12">
                                                <a href="<?php echo e(route('units.show', $unit->id)); ?>">
                                                    <?php echo e($unit->building->phase->project->name); ?> -
                                                    <?php echo e($unit->name); ?>

                                                </a>

                                                <select name="status" style="margin-left:20px;" id="status"
                                                    class="custom-select form-control-border col-3 unit-status"
                                                    data-unit-id="<?php echo e($unit->id); ?>"
                                                    data-unit-name="<?php echo e($unit->name); ?>"
                                                    data-unit-space="<?php echo e($unit->unit_space); ?>"
                                                    data-unit-total-price="<?php echo e($unit->payment->total_amount); ?>"
                                                    data-unit-years="<?php echo e($unit->payment->unitPrice->years ?? 0); ?>"
                                                    data-unit-meter-price="<?php echo e($unit->payment->unitPrice->price ?? 0); ?>"
                                                    data-unit-roof-price="<?php echo e($unit->payment->unitPrice->roof_price ?? 0); ?>"
                                                    data-unit-garden-price="<?php echo e($unit->payment->unitPrice->garden_price ?? 0); ?>"
                                                    data-unit-downpayment="<?php echo e($unit->payment->down_payment); ?>"
                                                    data-unit-maintenance="<?php echo e($unit->payment->mentainance); ?>">
                                                    <option value=""></option>
                                                    <option <?php if($unit->status === 'taken'): ?> selected <?php endif; ?>
                                                        value="contract">Contract</option>
                                                    <option <?php if($unit->status === 'reserved'): ?> selected <?php endif; ?>
                                                        value="reserved">Reserved</option>
                                                    <option value="canceled">Canceled</option>
                                                </select>

                                                <?php if($unit->status === 'taken'): ?>
                                                    <a href="<?php echo e(route('showReservation.report', $unit->id)); ?>"
                                                        title="View Payment Plan" class="btn btn-danger mx-3"
                                                        style="float:right">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(count($client->files) != 0): ?>
                        <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-files')): ?>
                            <div class="card card-outline card-info collapsed-card">
                                <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                    Files
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <?php $__currentLoopData = $client->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <a
                                                        href="<?php echo e(URL::to('/')); ?>/files/<?php echo e($file->file); ?>"><?php echo e($file->file); ?>-<?php echo e($file->created_at); ?></a>
                                                </td>
                                                <td>
                                                    <form method="POST"
                                                        action="<?php echo e(route('files.destroy', $file->id)); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-outline-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Swiper -->
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-gallery')): ?>
                        <div class="card card-outline card-info collapsed-card">
                            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                Images
                            </div>
                            <div class="card-body">
                                <div class="col-12 pb-3">
                                    <div class="swiper mySwiper" id="mySwiper" data-toggle="modal"
                                        data-target="#imageGallery">
                                        <div class="swiper-wrapper">
                                            <?php $__currentLoopData = $client->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="swiper-slide">
                                                    <img class="swiper-slide"
                                                        src="<?php echo e(URL::to('/')); ?>/images/<?php echo e($value->name); ?>"
                                                        alt="<?php echo e($value->name); ?>" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
    
    <div class=" row">
        <div class="col-5">
            <div class="card">
                
                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-read-comment')): ?>
                    <div class="card card-outline card-info  collapsed-card col-12">
                        <div class="card-header" data-card-widget="collapse">
                            <h3 class="card-title">
                                (Comments)
                            </h3>
                            <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-create-comment')): ?>
                                <button type="button" class="btn btn-outline-info" style="float:right;"
                                    title="add comment" data-toggle="modal" data-target="#addComment">
                                    <i class="fas fa-plus"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <?php $__currentLoopData = $streams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stream): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <table>
                                    <tbody>
                                        <tr>
                                            <th>Comment: </th>
                                            <td><?php echo e($stream->comment ?? ''); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Creator: </th>
                                            <td><?php echo e($stream->creator?->name ?? ''); ?></td>
                                        </tr>
                                        <tr>
                                            <th>created_at :</th>
                                            <td><?php echo e($stream->created_at ?? ''); ?></td>
                                        </tr>
                                    </tbody>
                                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-delete-comments')): ?>
                                        <tfoot>
                                            <tr>
                                                <div style="float: right;">
                                                    <form method="POST"
                                                        action="<?php echo e(route('streams.destroy', $stream->id)); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-outline-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </tr>
                                        </tfoot>
                                    <?php endif; ?>
                                </table>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-7">

            <div class="card">
                
                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-tickets')): ?>
                    <?php $__currentLoopData = $client->units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($unit->tickets) != 0): ?>
                            <div class="card card-outline card-info collapsed-card">
                                <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                    Tickets
                                </div>
                                <div class="card-body">
                                    <?php $__currentLoopData = $unit->tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card collapsed-card">
                                            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                                <h3 class="card-title">
                                                    <?php echo e($unit->building->phase->project->name); ?> -
                                                    <?php echo e($unit->name); ?>

                                                </h3>
                                            </div>
                                            <div class="card-body">
                                                <?php if(Auth::user()->type == 'admin' || auth()->user()->role->hasPermission('units-show')): ?>
                                                    <a href="<?php echo e(route('units.show', $unit->id)); ?>" title="View Unit"
                                                        class="btn btn-" style="float:right">
                                                        <i class="fas fa-home"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>ID</th>
                                                            <th>Ticket Type</th>
                                                            <th>Status</th>
                                                            <th>Description</th>
                                                            <th>Last Action Date</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $unit->tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php $temp = explode(' ', $ticket->created_at->setTimezone('Africa/Cairo')); ?>

                                                            <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('clients-showTicket')): ?>
                                                                <tr class='clickable-row'
                                                                    data-href='<?php echo e(route('tickets.show', $ticket->id)); ?>'>
                                                                <?php else: ?>
                                                                <tr>
                                                            <?php endif; ?>

                                                            <td><?php echo e($ticket->id); ?></td>
                                                            <td><?php echo e($ticket->ticket_type->name); ?></td>
                                                            <td><?php echo e($ticket->status); ?></td>
                                                            <td>
                                                                <?php echo e(substr($ticket->description, 0, 20)); ?><?php echo e(strlen($ticket->description) >= 20 ? '...' : ''); ?>

                                                            </td>
                                                            <td><?php echo e($ticket->updated_at); ?></td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>

    </div>


    <!-- Modals -->

    <!-- Delete Image from Slider Modal -->
    <div class="modal fade" id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this Image ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="addComment" tabindex="-1" role="dialog" aria-labelledby="addCommentLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCommentLabel">add Comment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('streams.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="client_id" type="hidden" value="<?php echo e($client->id); ?>">
                            <input class="form-control" name="created_by" type="hidden"
                                value="<?php echo e(auth()->user()->id); ?>">
                            <textarea class="form-control" name="comment" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Store Phone Number -->
    <div class="modal fade" id="storePhones" role="dialog" aria-labelledby="storePhonesLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="storePhonesLabel">add new number</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('phones.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="client_id" type="hidden" value="<?php echo e($client->id); ?>">
                        </div>
                        <div class="row">

                            <div class="form-group col-4">
                                <select class="select2 custom-select form-control-border" name="country_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($code->id); ?>"><?php echo e($code->name); ?>

                                            +<?php echo e($code->phonecode); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-8">
                                <input class="form-control" name="phone" type="text" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- gallery Image from Slider Modal -->
    <div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content"
                style="background-color: unset;
                    box-shadow: unset;
                    border: unset;">
                <div class="modal-body">
                    <div class="swiper2 mySwiper2">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $client->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <img style="position: absolute" src="<?php echo e(URL::to('/')); ?>/images/<?php echo e($value->name); ?>"
                                        alt="<?php echo e($value->name); ?>" />
                                    <a href="<?php echo e(route('clients.deleteImage', $value->id)); ?>">
                                        <button style="position: relative; float:right;color:white;font-size:30px"
                                            class="btn">×</button>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Phone Modal -->
    <div class="modal fade" id="phoneDelete" tabindex="-1" role="dialog" aria-labelledby="phoneDelete"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">

                <div class="modal-body">
                    <h5>Are you sure to delete this phone Number ?</h5>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>


    <!-- Contract Modal -->
    <div class="modal fade" id="paymentPlanModal" role="dialog" aria-labelledby="paymentPlanModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentPlanModalLabel">Build Payment Plan for Unit <span
                            id="unitName"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="paymentPlanForm" action="<?php echo e(route('reservation.report')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <!-- Display Unit Details -->
                        <div class="mb-3">
                            <label for="unitDetails">Unit Details:</label>
                            <ul id="unitDetails">
                                <li><strong>Unit Name:</strong> <span id="modalUnitName"></span></li>
                                <li><strong>Unit Space:</strong> <span id="modalUnitSpace"></span></li>
                                <li><strong>Total Price:</strong> <span id="modalUnitTotalPrice"></span></li>
                                <li><strong>Number Of Years:</strong> <span id="modalYears"></span></li>
                                <li><strong>Meter Price:</strong> <span id="modalMeterPrice"></span></li>
                                <li><strong>Roof Price:</strong> <span id="modalRoofPrice"></span></li>
                                <li><strong>Garden Price:</strong> <span id="modalGardenPrice"></span></li>
                                <li><strong>Maintenance Amount:</strong> <span id="modalMaintenance"></span></li>
                                <li><strong>Total Price:</strong> <span id="modalTotalPrice"></span></li>
                            </ul>
                        </div>

                        <div class="form-group">
                            <label for="modalDownPayment">Down Payment Price:</label>
                            <input class="form-control" id="modalDownPayment" name="downPayment" type="text">
                            <span style="color: red"> *note: This Down Payment is the price from reservation</span>
                        </div>

                        <input type="hidden" name="id" id="modalUnitId">
                        <!-- Payment Plan Options -->
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="paymentPlan" value="quarter"
                                id="quarterly">
                            <label class="form-check-label" for="quarterly">Quarterly</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="paymentPlan" value="double-quarter"
                                id="doubleQuarterly">
                            <label class="form-check-label" for="doubleQuarterly">Double Quarterly</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="paymentPlan" value="annually"
                                id="annually">
                            <label class="form-check-label" for="annually">Annually</label>
                        </div>

                        <!-- Date and Day Inputs -->
                        <div class="form-group mt-3">
                            <label for="contractDate">Contract Date:</label>
                            <input type="date" class="form-control" id="contractDate" name="contractDate">
                        </div>
                        <div class="form-group mt-3">
                            <label for="paymentDay">Contract Day:</label>
                            <input type="text" class="form-control" id="paymentDay" name="paymentDay">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="module" src="<?php echo e(asset('swiper/swiper.js')); ?>"></script>
    <script>
        $(document).ready(function() {

            // Contract Reservation Modal 
            $('.unit-status').on('change', function() {

                var status = $(this).val();

                if (status === 'contract') {
                    var unitId = $(this).data('unit-id');
                    var unitName = $(this).data('unit-name');
                    var unitSpace = $(this).data('unit-space');
                    var unitTotalPrice = $(this).data('unit-total-price');
                    var unitYears = $(this).data('unit-years');
                    var unitMeterPrice = $(this).data('unit-meter-price');
                    var unitRoofPrice = $(this).data('unit-roof-price');
                    var unitGardenPrice = $(this).data('unit-garden-price');
                    var unitDownPayment = $(this).data('unit-downpayment');
                    var unitMaintenance = $(this).data('unit-maintenance');

                    $('#modalUnitId').val(unitId);
                    $('#unitName').text(unitName);
                    $('#modalUnitName').text(unitName);
                    $('#modalUnitSpace').text(unitSpace + ' sqm');
                    $('#modalUnitTotalPrice').text(unitTotalPrice + ' EGP');

                    $('#modalYears').text(unitYears);
                    $('#modalMeterPrice').text(unitMeterPrice + ' EGP');
                    $('#modalRoofPrice').text(unitRoofPrice + ' EGP');
                    $('#modalGardenPrice').text(unitGardenPrice + ' EGP');
                    $('#modalDownPayment').val(unitDownPayment);
                    $('#modalMaintenance').text(unitMaintenance + ' EGP');
                    $('#modalTotalPrice').text(unitTotalPrice + ' EGP');

                    $('#paymentPlanModal').modal('show');
                    $('#paymentPlanModal').addClass('show');

                }
            });
        });


        // Cancel Reservation Request 
        $('.unit-status').on('change', function() {
            var status = $(this).val();
            var unitId = $(this).data('unit-id');

            if (status === 'canceled') {
                if (confirm(
                        'Are you sure you want to cancel this Reservation?'
                    )) {

                    $.ajax({
                        url: '/reservation/' + unitId + '/cancel',
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                alert('Reservation Canceled Succesfully.');
                                location.reload();
                            } else {
                                alert('Failed to update unit status.');
                            }
                        },
                        error: function(xhr, status, error) {
                            alert('An error occurred while canceling the unit.');
                        }
                    });
                }
            }
        });

        clickDeletePhone = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('phones.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#phoneDelete').find($('form')).attr('action', route);
        }

        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });


        DeleteImage = (image) => {
            console.log(image);
            const modelId = image.getAttribute("data-id");
            var route = "<?php echo e(route('galleries.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#image').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/clients/show.blade.php ENDPATH**/ ?>