<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Phase;
use App\Models\Building;
use App\Models\Unit;

use App\Models\Project;
// use App\Http\Requests\ClientRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;


class BuildingController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('permission:buildings-create',['only' => ['create', 'store']]);
    //     $this->middleware('permission:buildings-read',['only' => ['show']]);
    //     $this->middleware('permission:buildings-update',['only' => ['edit', 'update']]);
    //     $this->middleware('permission:buildings-delete',['only' => ['destroy']]);
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = auth()->user();
        activity()
        ->event('visit')
        ->log($user->name .' visited buildings index page ');

        // Default

        $buildings = Building::query();

        if (auth()->user()->type == 'admin') {
            $Allbuildings = $buildings;
        } else {
            $buildings->where('is_active', 1);
            $Allbuildings = $buildings->whereHas('phase', function ($query) {
                $query->whereHas('users', function ($q) {
                        $q->where('users.id', auth()->user()->id);
                    });
            });
        }
        // Filter
        if($request->building_id){
            $Allbuildings->whereIn('id',$request->building_id);
        }

        if($request->phase_id){
            $Allbuildings->whereIn('phase_id', $request->phase_id);
        }

        // if($request->project_id){

        //     // $Allbuildings->whereIn('phase_id', $request->phase_id);
        // }

        if($request->time1 && $request->time2){
            $Allbuildings->whereTime('created_at', '>=',$request->time1)
            ->whereTime('created_at','<=',$request->time2);
        }
        
        if($request->date1 && $request->date2){
            $Allbuildings->whereDate('created_at', '>=',$request->date1)
            ->whereDate('created_at','<=',$request->date2);
        }
        $Allbuildings = $Allbuildings->paginate(100)->withQueryString();
        $projects = Project::get();
        $phases = Phase::get();

        return view('buildings.index', compact('Allbuildings', 'projects', 'phases'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $phase = Phase::find($request->id);
        $project = $phase->project;
        $user = auth()->user();

        activity()
        ->event('visit')
        ->log($user->name .' visited buildings create page ');

        return view('buildings.create', compact('project'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $building =new Building;
        $building->name=$request->name;

        if($request->is_active == ''){
            $building->is_active = 0;
        }else{
            $building->is_active = 1;
        }
        
            $building->type = $request->type ?? '';
            $building->number_of_floors = $request->number_of_floors ?? '';
            $building->phase_id = $request->phase_id ?? '';    
            $building->save();

        $user = auth()->user();
        
        activity()
            ->event('create')
            ->log($user->name .' created buildings ' . $building->name);

        return redirect()->route('phases.show', $request->phase_id)
                        ->with('success','Building created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Building $building)
    {
        $user = auth()->user();
        
        $units = Unit::query();
        $units = Unit::where('building_id', $building->id);
    
        
        
        if ($user->type != 'admin') {
                if (!$user->role->hasPermission('units-hiddenUnits-read')) {
                    $units->where('is_active',1);
                }
                
                $units->where(function ($query) use ($user) {
                if ($user->role->hasPermission('units-read-free')) {
                    $query->orWhere('status', 'free');
                }
        
                if ($user->role->hasPermission('units-read-reserved')) {
                    $query->orWhere('status', 'reserved');
                }
        
                if ($user->role->hasPermission('units-read-hold')) {
                    $query->orWhere('status', 'hold');
                }
        
                if ($user->role->hasPermission('units-read-downpayment')) {
                    $query->orWhere('status', 'downpayment');
                }
        
                if ($user->role->hasPermission('units-read-contracted')) {
                    $query->orWhere('status', 'taken');
                }
        
                if ($user->role->hasPermission('units-read-delivered')) {
                    $query->orWhere('status', 'delivered');
                }
                
            });
        }
        
        // if($user->type != 'admin' && $user->role->hasPermission('units-read-free')){
        //     $units->where('status', 'free');
        // }

        // if($user->type != 'admin' && $user->role->hasPermission('units-read-reserved')){
        //     $units->where('status', 'reserved');
        // }

        // if($user->type != 'admin' && $user->role->hasPermission('units-read-hold')){
        //     $units->where('status', 'hold');
        // }

        // if($user->type != 'admin' && $user->role->hasPermission('units-read-downpayment')){
        //     $units->where('status', 'downpayment');
        // }

        // if($user->type != 'admin' && $user->role->hasPermission('units-read-contracted')){
        //     $units->where('status', 'taken');
        // }

        // if($user->type != 'admin' && $user->role->hasPermission('units-read-delivered')){
        //     $units->where('status', 'delivered');
        // }

        $units = $units->get();
        
        activity()
        ->event('visit')
        ->log($user->name .' visited ' . $building->name . ' Page');

        return view('buildings.show' , compact('building','units'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Building $building)
    {
        $phase = DB::table('phases')->where('id', $building->phase_id)->first();
        return view('buildings.edit' , compact('phase', 'building'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Building $building)
    {
        //
        // $building->update($request->all());
        $building->name = $request->name;
        $building->type = $request->type;
        $building->number_of_floors = $request->number_of_floors;
        $building->save();

        $user = auth()->user();
        activity()
        ->event('update')
        ->log($user->name .' Updated Building: ' . $building->name . ' data');


        return redirect()->route('phases.show', $building->phase->id)
                        ->with('success','Building updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Building $building)
    {
        if(count($building->units) == 0){
            $user = auth()->user();
            activity()
            ->event('delete')
            ->log($user->name .' Deleted Building: ' . $building->name);

            $building->delete();

            return redirect()->route('buildings.index')->with('success','Building deleted successfully');
        }else{
            return redirect()->back()->with('error',"You can't delete this building, This building has units");

        }
       
    }

    public function deletePermanently($id)
    {
        $building = Building::withTrashed()->find($id);
        $building->forceDelete();

        return redirect()->route('buildings.index')->with('success', 'Building Trashed successfully');
    }

    public function hideBuilding($id)
    {
        //
        $building = Building::find($id);
        $user = auth()->user();

        if($building->is_active == 0){
            $building->is_active = 1;
            activity()
                ->event('hide')
                ->log($user->name .' Activated : ' . $building->name);
        }else{
            $building->is_active = 0;
            activity()
                ->event('hide')
                ->log($user->name .' de-Activated : ' . $building->name);
        }
        $building->save();
            foreach($building->units()->get() as $unit){
                $unit->is_active = $building->is_active;
                $unit->save();
            }
               
        return redirect()->back()->with('success', $building->is_active == 0 ? 'Building has been hidden successfully' : 'Building Activated Successfully');
    }

    public function archive()
    {
        // dd('projects');
        
        $buildings = Building::onlyTrashed()->get();
        // Log activity
        $model = new Building();
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Visit - buildings archive')
            ->log(auth()->user()->name .' viewed buildings archive');

        return view('buildings.archive',compact('buildings'));
    }

    public function restore($buildingId)
    {
        Building::withTrashed()->find($buildingId)->restore();
        $building = Building::find($buildingId);

        $user = auth()->user();
            
        activity()
        ->performedOn($building)
        ->causedBy($user)
        ->event('Restore building')
        ->log('building (' . $building->name . ') Restored by '. $user->name);

        return redirect()->back();
    }

    public function restoreAll()
    {
        Building::onlyTrashed()->restore();

        $building = new Building();
        $user = auth()->user();
            
        activity()
        ->performedOn($building)
        ->causedBy($user)
        ->event('Restore All buildings')
        ->log('All building Restored by '. $user->name);

        return redirect()->back();
    }

}