<?php

namespace App\Http\Controllers;

use App\Models\Event;
use Validator;
use Illuminate\Http\Request;
use App\Http\Requests\EventRequest;
use Illuminate\Support\Carbon;

class EventController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            // Special Case to start the calender process from this date.
            $startDate = '2023-12-05';
            if (auth()->user()->type == 'admin' || auth()->user()->role->name == 'Sales Admin') {
                $events = Event::with('communications')
                    ->whereDate('start', '>=', $request->start)
                    ->whereDate('end', '<=', $request->end)
                    ->whereDate('created_at', '>=', $startDate)
                    ->get();
            } else {

                $events = Event::with('communications')
                    ->whereHas('communications.user', function ($q) {

                        // $childUsers = auth()->user()->childs()->pluck('id')->toArray();
                        $childUsers = auth()->user()->allChildren()->pluck('id')->toArray();
                        if (count($childUsers) > 0) {
                            $q->whereIn('id', $childUsers);
                        } else {
                            $q->where('id', '=', auth()->user()->id);
                        }
                    })->whereHas('communications.lead', function ($query) {
                        $authUser = auth()->user();

                        // Ensure only communications with leads assigned to the user or their children are included
                        $query->where('user_id', $authUser->id)
                            ->orWhereIn('user_id', $authUser->allChildren()->pluck('id')->toArray());
                    })
                    ->whereDate('start', '>=', $request->start)
                    ->whereDate('end', '<=', $request->end)
                    ->whereDate('created_at', '>=', $startDate)
                    ->get();
            }

            return response()->json($events);
        }
        return view('events.calendar');
    }
    public function create(EventRequest $request)
    {
        $event = Event::create([
            'title' => $request->title,
            'start' => $request->start,
            'end' => $request->end,
        ]);

        return response()->json([
            'success' => true,
            'data' => $event
        ]);
    }

    public function edit(EventRequest $request)
    {
        $event = Event::where('id', $request->id)
            ->update([
                'title' => $request['title'],
                'start' => $request['start'],
                'end' => $request['end'],
            ]);

        return response()->json([
            'success' => true,
            'data' => $event
        ]);
    }

    public function destroy(Request $request)
    {
        Event::where('id', $request->id)
            ->delete();

        return response()->json([
            'success' => true,
            'message' => 'Event removed successfully.'
        ]);
    }

    public function listMeeting()
    {
        $events = Event::where('type', 'meeting')->get();
        return view('events.meetings', compact('events'));
    }
}
