<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Country;
use App\Models\Lead;
use App\Models\PhoneNumber;
use App\Models\Broker;
use App\Http\Requests\PhoneNumberRequest;

use Illuminate\Http\Request;

class PhoneNumberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return 404;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Edit Activity Log
        $model = new PhoneNumber();
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Store - Phone Number')
            ->log(auth()->user()->name . ' store phone number' . '(' . $request->phone . ')');
        // end Activity Log

        $client = Client::find($request->client_id);
        $lead = Lead::find($request->lead_id);
        $broker = Broker::find($request->broker_id);


        // dd($lead);
        try {
            $phone = new PhoneNumber();
            $phone->phone = $request->phone;
            $phone->country_id = $request->country_id;

            if ($client != NULL) {
                $phone->client_id = $request->client_id;
                $phone->lead_id = $client->lead ? $client->lead->id : null;
            }
            
            if ($lead != NULL) {
                $phone->lead_id = $lead->id;
                $phone->client_id = $lead->client ? $lead->client->id : null;
            }

            if ($broker != NULL) {
                $phone->broker_id = $broker->id;
            }

            $phone->save();

            return redirect()->back()->with('success', 'Phone Number Created Successfully');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'dublicated phone number');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        // Edit Activity Log
        $model = new PhoneNumber();
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Visit - Phone Edit')
            ->log(auth()->user()->name . 'visited phone edit');
        // end Activity Log

        $phone = PhoneNumber::find($id);
        $codes = Country::get();
        $client = Client::find($phone->client_id);
        return view('phones.edit', compact('phone', 'codes', 'client'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Edit Activity Log
        $model = new PhoneNumber();
        $phoneNumber = PhoneNumber::find($id);
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Update - Phone')
            ->log(auth()->user()->name . ' updated phone' . '(' . $phoneNumber->phone . ')');
        // end Activity Log

        $phoneNumber = PhoneNumber::find($id);
        $client = Client::find($phoneNumber->client_id);
        $lead = Lead::find($phoneNumber->lead_id);
        $broker = Broker::find($phoneNumber->broker_id);

        try {
            $phoneNumber->phone = $request->phone;
            $phoneNumber->country_id = $request->country_id;
            $phoneNumber->save();

            if ($client == NULL && $lead != NULL) {
                return redirect()->route('leads.show', $lead->id)->with('success', 'Phone Number Created Successfully');
            } elseif ($broker != NULL) {
                return redirect()->route('brokers.show', $broker->id)->with('success', 'Phone Number Created Successfully');
            } else {
                return redirect()->route('clients.show', $client->id)->with('success', 'Phone Number Created Successfully');
            }
        } catch (\Exception $e) {
            if ($client == NULL && $lead != NULL) {
                return redirect()->route('leads.show', $lead->id)->with('Error', 'Phone Number Dublicated');
            } elseif ($broker != NULL) {
                return redirect()->route('brokers.show', $broker->id)->with('Error', 'Phone Number Dublicated');
            } else {
                return redirect()->route('clients.show', $client - id)->with('Error', 'Phone Number Dublicated');
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Edit Activity Log
        $model = new PhoneNumber();
        $phone = PhoneNumber::find($id);
        $CurrentUser = auth()->user();
        activity()
            ->performedOn($model)
            ->causedBy($CurrentUser)
            ->event('Delete - Phone')
            ->log(auth()->user()->name . ' deleted phone' . '(' . $phone->phone . ')');
        // end Activity Log

        $phone = PhoneNumber::find($id);
        try {
            $phone->delete();

            return redirect()->back()->with('success', 'Phone Number Created Successfully');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Failed To delete phone number');
        }
    }
}
