<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UnitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => ['required', 'unique:units,name'],
            'unit_space' => ['nullable'],
            'unit_meter_price' => ['nullable'],
            'garden_space' => ['nullable'],
            'floor' => ['nullable'],
            'garden_percentage' => ['nullable'],
            'bedrooms' => ['nullable'],
            'bathrooms' => ['nullable'],
            'Booked_date' => ['nullable'],
            'is_active' => ['nullable'],
            'user_id' => ['nullable'],
            'building_id' => ['nullable'],
            'type' => ['nullable'],
            'finishing' => ['nullable'],
            'view' => ['nullable'],
            'user_id' => ['nullable'],
            'dressing' => ['nullable'],
            'description' => ['nullable'],
        ];
    }
}
