<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use URL;
class ProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = URL::to('/') . "/images/" . $this->logo;
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'is_active' => $this->is_active == 0 ? 'not active' : 'Active',
            'is_residential' => $this->is_residential == 0 ? 'NO' : 'Yes',
            'logo' => $image,
        ];
    }
}
