<?php

namespace App\Imports;

use App\Models\Lead;
use App\Models\User;
use App\Models\Country;
use App\Models\PhoneNumber;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;

class LeadsImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows,SkipsOnFailure
{
    use Importable,SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        //$assignedUser = User::whereName($row['assigned_user'])->first();

        $lead = new Lead([
            'name' => $row['name'],
            'email' => $row['email'],
            'job_title' => $row['job_title'],
            'came_from' => $row['came_from'],
            'status_id' => $row['status_id'] ?? 1,
            'campaign_id' => $row['campaign_id'],
            'source_id' => $row['source_id'],
            'type' => 'lead', // lead || cil
            'project_id' => $row['project_id'],
            'purpose' => $row['purpose'],
            'segment' => $row['segment'],
            'tag' => $row['tag'],
            'contact_tool' => $row['contact_tool'],
            'reply_option' => $row['reply_option'],
            'user_id' => $row['user_id'],
            'created_by' => auth()->user()->id
            // 'broker_id ' => $row['broker_id '],
        ]);
        $lead->save(); 
        $country = Country::Where('phonecode',$row['country_code'])->first();

        $phone = PhoneNumber::create([
            'phone' => $row['mobile_number'],
            'lead_id' => $lead->id,
            'country_id' => $country->id
        ]);
        
         if($row['mobile_number2'] != null){
            $country2 = Country::Where('phonecode',$row['country_code2'])->first();
          
            $phone2 = PhoneNumber::create([
                'phone' => $row['mobile_number2'],
                'lead_id' => $lead->id,
                'country_id' => $country2->id
            ]);
        }

        return $lead;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'email' => ['nullable', 'unique:leads,email', 'email'],
            'country_code' => ['required'],
            'mobile_number' => ['required','unique:phone_numbers,phone'],
            'job_title' => ['nullable'],
            'came_from' => ['nullable'],
            'description' => ['nullable'],
            'campaign_id' => ['required'],
            'source_id' => ['required'],
            'project_id' => ['nullable'],
            'purpose' => ['nullable'],
            'segment' => ['nullable'],
            'tag' => ['nullable'],
            'contact_tool' => ['nullable'],
            'reply_option' => ['nullable'],
            'user_id' => ['nullable'],
            // 'broker_id' => ['nullable'],
        ];
    }
    
     public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        $data = [];
        foreach ($failures as $failure) {

            array_push($data,$failure->errors());
        }

        Session::push('leadsErrors', collect($data));
    }

    public function customValidationMessages()
    {
        return [
            'mobile_number.unique' => 'This mobile number :input is duplicated.',
            'mobile_number2.unique' => 'This mobile number :input is duplicated.',
        ];
    }
}
