<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;


class File extends Model
{
    use HasFactory;
    use LogsActivity;
    public $guarded = [];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn(string $eventName) => "This model has been {$eventName}")->useLogName('upload files');;
    }


    public function comment()
    {
        return $this->belongsTo(Comment::class, 'comment_id');
    }

    public function ticket()
    {
        return $this->belongsTo(Ticket::class, 'ticket_id');
    }

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }


    public function unit()
    {
        return $this->belongsTo(unit::class, 'unit_id');
    }

    public function broker()
    {
        return $this->belongsTo(Broker::class, 'broker_id');
    } 
}
