<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Payment extends Model
{
    use HasFactory;
    public $guarded = [];
    use LogsActivity;


    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id');
    }

    public function unitPrice()
    {
        return $this->belongsTo(UnitPrice::class, 'unit_price_id');
    }

    // public function transactions()
    // {
    //     return $this->hasMany(Transaction::class);
    // }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logUnguarded()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Unit Action');
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }
}
