<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;


class Project extends  Model implements HasMedia
{
    use HasFactory;
    use SoftDeletes;
    use InteractsWithMedia;

    public $guarded = [];
    protected $appends = [
        'image',
    ];

    public function getImageAttribute($value)
    {
        return $this->getMedia('image')->last();
    }
    public function phases()
    {
        return $this->hasMany(Phase::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }

    public function facilities()
    {
        return $this->belongsToMany(Facility::class, 'facility_projects');
    }

    public function campaigns()
    {
        return $this->hasMany(Campaign::class);
    }

    public function sources()
    {
        return $this->hasMany(Source::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function PaymentPlans()
    {
        return $this->belongsToMany(PaymentPlan::class, 'payment_plan_project')->withTimestamps();
    }

    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function images()
    {
        return $this->hasMany(Gallery::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class);
    }
}
