toastr.options = {
    "closeButton": true,
    "debug": false,
    "newestOnTop": true,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": false,
    "onclick": null,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
}


////////////////////////////////////////////// assign users permission ///////////////////////////////////////////////////////////

// let selectedPermissions = document.querySelectorAll('.permission-checkbox');
// let submitPermission = document.getElementById('submitPermission');

// submitPermission.addEventListener('click', () => {
//     let selectedUser = document.getElementById('selectedUser').value;
//     let permissions = [];
//     selectedPermissions.forEach(element => {
//         if (element.checked == true) {
//             permissions.push({ 'id': element.value });
//         }
//     });
//     async function updateUserPermissions() {
//         try {
//             const data = new FormData();
//             data.append('userId', selectedUser);
//             await axios.post(`/permissions/add`, data, {
//                 params: {
//                     permissions
//                 },
//                 headers: {
//                     'Content-Type': 'multipart/form-data'
//                 }
//             })
//                 .then(response => {
//                     console.log(response.data.message)
//                     toastr.success(response.data.message)
//                 }
//                 );

//         } catch (error) {
//         }
//     }
//     updateUserPermissions();
// })

///////////////////////////////////////// check every user permission ///////////////////////////////////////////////////////////

// let userSelect = document.getElementById('selectedUser');
// const permissionCheckboxes = document.getElementsByClassName('permission-checkbox');

// userSelect.addEventListener('change', () => {
//     const selectedUserId = userSelect.value;

//     Array.from(permissionCheckboxes).forEach(function (checkbox) {
//         checkbox.checked = false;
//     });

//     axios.get('/permissions/users/' + selectedUserId)
//         .then(function (response) {
//             const userPermissions = response.data;

//             Array.from(permissionCheckboxes).forEach(function (checkbox) {
//                 if (userPermissions.includes(parseInt(checkbox.value))) {
//                     checkbox.checked = true;
//                 }
//             });
//         })
//         .catch(function (error) {
//             console.error(error);
//         });
// })


//assign roles permission
let selectedRolesPermissions = document.querySelectorAll('.permission-checkbox');
let submitRolesPermission = document.getElementById('submitPermission');

submitRolesPermission.addEventListener('click', () => {
    let selectedRole = document.getElementById('selectedRole').value;
    let permissions = [];
    selectedRolesPermissions.forEach(element => {
        if (element.checked == true) {
            permissions.push({ 'id': element.value });
        }
    });
    async function updateRolePermissions() {
        try {
            const data = new FormData();
            data.append('roleId', selectedRole);
            await axios.post(`/CRM/public/permissions/addRole`, data, {
                params: {
                    permissions
                },
                headers: {
                    'Content-Type': 'multipart/form-data'
                }
            })
                .then(response => {
                    toastr.success(response.data.message)
                }
                );

        } catch (error) {
        }
    }
    updateRolePermissions();
})

//check every Role permission
let roleSelect = document.getElementById('selectedRole');
const rolesPermissionCheckboxes = document.getElementsByClassName('permission-checkbox');

roleSelect.addEventListener('change', () => {
    const selectedRoleId = roleSelect.value;

    Array.from(rolesPermissionCheckboxes).forEach(function (checkbox) {
        checkbox.checked = false;
    });

    axios.get('/CRM/public/permissions/roles/' + selectedRoleId)
        .then(function (response) {
            const rolePermissions = response.data;

            Array.from(rolesPermissionCheckboxes).forEach(function (checkbox) {
                if (rolePermissions.includes(parseInt(checkbox.value))) {
                    checkbox.checked = true;
                }
            });
        })
        .catch(function (error) {
            console.error(error);
        });
})