@extends ('../welcome')
@section('content')
    <style>
        .clickable-row:hover {
            background-color: #17a2b8;
            opacity: 0.8;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }
    </style>
    <div class="card col-6">
        <div class="card-body">
            <div class=" row">
                <label class="col-sm-3 col-form-label">Agent Name :</label>
                <label class="col-sm-6 col-form-label">{{ $agent->name }} </label>
            </div>

            <div class=" row">
                <label class="col-sm-3 col-form-label">Agent phone :</label>
                <label class="col-sm-6 col-form-label">{{ $agent->phone }} </label>
            </div>

            <div class=" row">
                <label class="col-sm-3 col-form-label">Agent email :</label>
                <label class="col-sm-6 col-form-label">{{ $agent->email }} </label>
            </div>

            <div class=" row">
                <label class="col-sm-3 col-form-label">Created at :</label>
                <label class="col-sm-6 col-form-label">{{ $agent->created_at }} </label>
            </div>
        </div>
        <div class="card-footer">
            <div style="float:right">
                <a class="btn btn-info" href="{{ route('agents.edit', $agent->id) }}">
                    <i class="fas fa-pen"></i>
                </a>
                @if (count($agent->brokers) == 0 || count($agent->communications) == 0 || count($agent->leads) == 0 || count($agent->inquiries) == 0)
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('agents-delete'))
                        <button onClick="clickDelete(this)" title="Delete" type="button" class="btn btn-danger"
                            data-id="{{ $agent->id }}" data-toggle="modal" data-target="#AgentModal">
                            <i class="fa fa-trash"></i>
                        </button>
                    @endif
                @endif
            </div>
        </div>
    </div>

    {{-- @endif --}}
    <div class="modal fade" id="AgentModal" tabindex="-1" role="dialog" aria-labelledby="AgentModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>



    <!-- /.row -->
    <script>
        clickDelete = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('agents.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#AgentModal').find($('form')).attr('action', route);
        }
    </script>
@endsection
