@extends ('../welcome')


@section ('content')

<div class="card card-info">

    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('buildings.store') }}" method="post">
            @csrf

            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->

                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" placeholder="Building Name">
                    </div>
                </div>
            </div>
            <input name="is_active" value="1" type="hidden">
            @if($project->is_residential == 1)
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->
                    <div class="form-group">
                        <label>Building Type</label>
                        <select name="type" class="form-control">
                            <option value="Residential">Residential</option>
                            <option value="Medical">Medical</option>
                            <option value="Commercial">Commercial</option>
                            <option value="Administrative">Administrative</option>
                            <option value="Multiple">Multiple</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->

                    <div class="form-group">
                        <label>Number of floors</label>
                        <div class="row">
                            <span style="margin-top:6px; font-weight:bold;font-size:20px; "
                                class="col-1">G+</span><input type="number" name="number_of_floors"
                                class="form-control col-5" placeholder="Number of floors">
                        </div>
                    </div>
                </div>
            </div>

            @else
            <input type="hidden" name="type" value="Multiple">
            <input type="hidden" name="number_of_floors" value="0">
            @endif
            <input type="hidden" name="phase_id" value="{{$_GET['id']}}">

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
    <!-- /.card-body -->
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
$('#roof').hide();

$('#hasRoof').on('change', () => {
    $("#roof").animate({
        height: 'toggle'
    });
});
</script>
@endsection