<table
    id="{{ auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-export') ? 'original' : 'original-nonExport' }}"
    class="display nowrap" style="width:100%">
    <thead>
        <tr>
            <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
            <th>Name</th>
            @for ($i = 1; $i <= $leadNumbers; $i++)
                <th>Phone Number {{ $i }}</th>
            @endfor
            <th>Assigned To</th>
            @for ($i = 1; $i <= 3; $i++)
                <th>Last Comment {{ $i }}</th>
            @endfor

            <th>Last action date</th>
            <th>Next action date</th>
            <th>Status</th>
            <th>Note</th>
            <th>Lead Target</th>
            <th>Source Type</th>
            <th>Campaign</th>
            <th>Project</th>
            <th>Tag</th>
            <th>Created by</th>
            <th>Created Date</th>
            <th>Created Time</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($leads as $lead)
            @php
                $temp = explode(' ', $lead->created_at->setTimezone('Africa/Cairo'));
            @endphp

            <tr>
                <td><input type="checkbox" id="chk_lead" class="checkboxAll sub_chk" data-id="{{ $lead->id }}">
                </td>
                <td>
                    <a href="{{ route('leads.show', $lead->id) }}">{{ $lead->name }}</a>
                </td>

                <!-- Phone number -->
                @for ($i = 0; $i < $leadNumbers; $i++)
                    <td>
                        {{ $lead->phone_numbers[$i]->country->phonecode ?? '--' }}
                        {{ $lead->phone_numbers[$i]->phone ?? '--' }}

                    </td>
                @endfor

                <td>
                    @if ($lead->user_id != null)
                        <a title="Edit" href="{{ route('users.show', $lead->user_id) }}">
                            {{ $lead->user?->name }}
                        </a>
                    @endif
                </td>

                @if (auth()->user()->role->name == 'Sales Agent' && $lead->communications->last()?->user_id != auth()->user()->id)
                    @for ($i = 0; $i < 3; $i++)
                        <td>--</td>
                    @endfor
                @else
                    <?php $communications = $lead->communications()->orderBy('id', 'desc')->take(3)->get(); ?>


                    @foreach ($communications as $communication)
                        <td>{{ $communication->description ?? '--' }}</td>
                    @endforeach


                    @for ($i = count($communications); $i < 3; $i++)
                        <td>--</td>
                    @endfor
                @endif

                <td>
                    {{ $lead->communications->last()?->created_at->format('Y-m-d H:i') ?? 'not yet' }}
                </td>

                <td>
                    {{ \Carbon\Carbon::parse($lead->communications->last()?->event?->start)->format('Y-m-d') }}
                </td>

                @if ($lead->LeadStatus)
                    <td class="badge badge-{{ $lead->LeadStatus->color }}" style=" margin-top:12px;margin-left:10px;">
                        {{ ucwords($lead->LeadStatus?->name) ?? '' }}
                    </td>
                @else
                    <td> -- </td>
                @endif
                <td>{{ $lead->note ?? '' }}</td>
                <td>{{ $lead->source?->name ?? '' }}</td>
                <td>{{ $lead->source?->sourceType?->name ?? '' }}</td>
                <td>{{ $lead->campaign?->name ?? '' }}</td>
                <td>{{ $lead->project?->name ?? '' }}</td>

                <td>{{ $lead->tag ?? '' }}</td>

                <td>
                    @if ($lead->created_by != null)
                        <a href="{{ route('leads.show', $lead->created_by_user->id) }}">
                            {{ $lead->created_by_user->name }}
                        </a>
                    @endif
                </td>

                <td>{{ $temp[0] }}</td>
                <td>{{ $temp[1] }}</td>
            </tr>
        @endforeach
    </tbody>
</table>

<div class="pagination">
    {{ $leads->appends(request()->query())->links() }}
</div>
