@extends ('../welcome')
@section ('content')
<style>
a#campaign {
    text-decoration-line: line-through !important;
}
</style>
<div class="row">
    <!-- <div class="col-1"></div> -->
    <div class="row">
        
            <a class="btn btn-success" style="margin-left:25px;" title="Event"
                href="{{route('communications.create',$lead->id)}}">
                <i class="fas fa-calendar"></i>
            </a>&nbsp;&nbsp;
            @if(Auth::user()->role->hasPermission('makeCall'))
                @foreach($lead->phone_numbers as $key => $phoneNumber)
                    @php
                        $countryCode = App\Models\Country::find($phoneNumber->country_id);
                        $leadPhone = '0'.$phoneNumber->phone;
                    @endphp
                    <a class="btn btn-dark" title="Call"
                        href="https://rfco.vroot.com/api/appDeal/CallDial?identity={{auth()->user()->code}}&Calltext={{$leadPhone}}">
                        <i class="fas fa-phone">&nbsp;&nbsp;Call Number {{$key + 1}}</i>
                    </a>&nbsp;&nbsp;
                @endforeach
            
            @endif
            @if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-update'))
                <a class="btn btn-info" title="Edit" href="{{ route('leads.edit',$lead->id) }}">
                    <i class="fa fa-pen"></i>
                </a>&nbsp;&nbsp;
            @endif
            @if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-delete'))
                <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger" data-id="{{$lead->id}}"
                    data-toggle="modal" data-target="#exampleModalCenter">
                    <i class="fa fa-ban"></i>
                </button>&nbsp;&nbsp;
            @endif
        
    </div>
</div>
<div class="row">

<div class="col-6">

    <div class="card-body">
        <div class=" row">
            <div class="col-7">
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Name :</label>
                    <label class="col-sm-7 col-form-label">{{$lead->name}} </label>
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Email :</label>
                    <label class="col-sm-7 col-form-label">{{$lead->email ?? '-'}} </label>
                </div>

                <div class=" row">
                    <label class="col-sm-4 col-form-label">Job Title :</label>
                    <label class="col-sm-7 col-form-label">{{$lead->job_title ?? '-'}} </label>
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Source :</label>
                    <label class="col-sm-7 col-form-label">{{$lead->came_from}} </label>
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Campaign :</label>
                    @if(empty($lead->campaign))
                    <label class="col-sm-7 col-form-label">
                        <a id="campaign" title="Trashed Campaign">
                            --
                        </a>
                    </label>
                    @else
                    <label class="col-sm-7 col-form-label">
                        <a href="{{route('campaigns.show', $campaign->id)}}">
                            {{$campaign->name}}
                        </a>
                    </label>
                    @endif
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Status :</label>
                    @if($lead->status == 'done-deal')
                    <label class="col-sm-7 col-form-label" style="color:#dc3545">{{$lead->status}}</label>
                    @else
                    <label class="col-sm-7 col-form-label">{{$lead->status}}</label>
                    @endif
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Assigned User :</label>
                    @foreach($lead->users as $user)
                    @if($user->id == $lastUser->user_id)

                    <label class="col-sm-7 col-form-label" style="font-weight:bold;color:#dc3545;">
                        <a href="{{route('users.show', $user->id)}}">
                            {{$user->name}}
                        </a>
                    </label>
                    @break
                    @endif
                    @endforeach
                </div>
                <div class=" row">
                    <label class="col-sm-4 col-form-label">Deadline :</label>
                    <label class="col-sm-7 col-form-label" style="font-weight:bold;color:#007bff;">
                        {{$lastUser?->deadline}}
                    </label>
                </div>
            </div>
            <div class="col-5">
                {{--@if(Auth::user()->role->hasPermission('leads-reAssignUser') && $lead->is_client == 0)--}}
                <form action="{{route('leads.reAssignUser', $lead->id)}}" method="post" id="AssignForm">
                    @csrf
                    <div class="row">
                        <div class="col-9">
                            <div class="form-group">
                                <select name="user_id" class="select2 custom-select form-control-border">
                                    <option value=''></option>
                                    @forelse($users as $user)
                                    @if(isset($lastUser))
                                    <option value="{{$user->id}}" {{$user->id == $lastUser->user_id ? 'selected' : ''}}>
                                        {{$user->name}}
                                    </option>
                                    @else
                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                    @endif
                                    @empty
                                    <option>No Users Yet</option>
                                    @endforelse
                                </select>
                            </div>
                        </div>

                        <div class="col-3">
                            <button type="submit" title="User with deadline" class="btn btn-outline-info">
                                <i class="fas fa-user" aria-hidden="true"></i>
                                <i class="fas fa-clock" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>
                </form>
                {{--@endif--}}
                {{--@if (Auth::user()->role->hasPermission('leads-ChangeStatus') && $lead->is_client == 0)--}}
                <form action="{{route('leads.ChangeStatus', $lead->id)}}" method="post" id="AssignForm">
                    @csrf
                    <div class="row">
                        <div class="col-7">
                            <div class="form-group">
                                <select name="status" class="select2 custom-select form-control-border" id="status">
                                    <option value="new" {{$lead->status == 'new' ? 'selected' : ''}}>New</option>
                                    <option value="in-process" {{$lead->status == 'in-process' ? 'selected' : ''}}>
                                        In-Process</option>
                                    <option value="interestad" {{$lead->status == 'interestad' ? 'selected' : ''}}>
                                        Interestad</option>
                                    <option value="not-interested"
                                        {{$lead->status == 'not-interested' ? 'selected' : ''}}>Not Interested
                                    </option>
                                    <option value="wait" {{$lead->status == 'wait' ? 'selected' : ''}}>Wait</option>
                                    <option value="follow_up" {{$lead->status == 'follow-up' ? 'selected' : ''}}>
                                        Follow Up</option>
                                    <option value="recycled" {{$lead->status == 'recycled' ? 'selected' : ''}}>
                                        Recycled</option>
                                    <option value="converted" {{$lead->status == 'converted' ? 'selected' : ''}}>
                                        Converted</option>
                                    <option value="dead" {{$lead->status == 'dead' ? 'selected' : ''}}>Dead</option>
                                    <option value="following" {{$lead->status == 'following' ? 'selected' : ''}}>Following</option>
                                    <option value="unreachable" {{$lead->status == 'unreachable' ? 'selected' : ''}}>Unreachable</option>
                                    <option value="no-answer" {{$lead->status == 'no-answer' ? 'selected' : ''}}>No Answer</option>
                                    <option value="done-deal" {{$lead->status == 'done-deal' ? 'selected' : ''}}>Done Deal</option>
                                    <option value="meeting" {{$lead->status == 'meeting' ? 'selected' : ''}}>Meeting</option>
                                    <option value="low-budget" {{$lead->status == 'low-budget' ? 'selected' : ''}}>Low Budget</option>
                                    <option value="closed-outside" {{$lead->status == 'closed-outside' ? 'selected' : ''}}>Closed Outside</option>
                                    <option value="wrong-number" {{$lead->status == 'wrong-number' ? 'selected' : ''}}>Wrong Number</option>
                                    <option value="pending" {{$lead->status == 'pending' ? 'selected' : ''}}>Pending</option>
                                    <option value="cancelled" {{$lead->status == 'cancelled' ? 'selected' : ''}}>Cancelled</option>

                                    
                                </select>
                            </div>
                        </div>
                        <div class="col-3">
                            <button type="submit" title="Change Status" class="btn btn-outline-info">
                                <i class="fas fa-check" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>
                </form>
                {{--@endif--}}
            </div>
        </div>
    </div>
</div>

<div class="col-6">
    <div class="card card-primary">
        <div class="card-header">
            <h3 class="card-title">Mobile Numbers</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="card-body table-responsive p-0" style="height: 300px;">
                @foreach ($phones as $phone)
                <div class="callout callout-info">

                    <h5>+{{$phone->country->phonecode}}-{{$phone->phone}}</h5>
                    <p>{{$phone->country->name}}-{{$phone->country->code}}</p>
                </div>
                @endforeach
            </div>
            
        </div>
    </div>
</div>
</div>
<br>
<div class="row">
    <div class="col-6">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Lead History</h3>
                <div class="card-tools">

                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                        <i class="fas fa-expand"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <!-- /.card-tools -->
            </div>
            <!-- /.card-header -->
            <div class="card-body">

                @foreach ($lead->communications as $communication)
                <a href="{{route('communications.show', $communication->id)}}">
                    <div class="callout callout-dark">
                        <h5>{{$communication->created_at}}</h5>
                        @if($communication->call_action != 'other')
                        <p>{{$communication->call_action}}</p>
                        @endif
                        <p>{{$communication->description}}</p>
                    </div>
                </a>
                @endforeach

            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>

    {{--<div class="col-6">

        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Lead Comments History</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                        <i class="fas fa-expand"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>

                <!-- /.card-tools -->
            </div>
            <!-- /.card-header -->
            {{--<div class="card-body">
                @if($lead->is_client == 0)
                <div class="row">
                    <div class="col-12">
                        <form action="{{route('leads.createStream',$lead->id)}}" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            <input type="file" name="document[]" multiple><br><br>
                            <div class="row">
                                <div class="form-group col-8">
                                    <textarea style="margin-left:10px; margin-bottom: 50px;" type="text"
                                        placeholder="Add New Comment" class="form-control" rows="2" cols="10"
                                        name="comment" required></textarea>

                                </div>

                                <button type="submit" class="btn btn-info"
                                    style="margin-left:30px; margin-bottom:85px;">
                                    <i class="fa fa-plus" aria-hidden="true"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                    @endif
                </div>
                {{--@foreach ($lead->streams as $stream)
                <div class="callout callout-info">
                    <h5>{{$stream->created_at->setTimezone('Africa/Cairo')}}</h5>
                    <p>{{$stream->comment}}</p>
                    {{-- {{$stream->image->getUrl()}} --}}
                    @if($stream->files)
                    @foreach ($stream->files as $file)
                    <a href="{{ $file->getUrl() }}" target="blank" itemprop="contentUrl" data-bs-original-title=""
                        title="">Attached Document</a>
                    @endforeach
                    @endif
                </div>
                @endforeach--}}

            </div>--}}
            <!-- /.card-body -->
        </div>
    </div>--}}
</div>

@endsection