@extends ('../welcome')


@section ('content')
<div class="card col-6">
    <div class="card-body register-card-body">
        <p class="login-box-msg">Edit Role</p>

        <form action="{{route('roles.update',$role->id)}}" method="POST">
            @csrf
            @method('PUT')
            <input type="hidden" value="{{$role->id}}" name="id">
            <div class="form-group mb-3">
                <label>Display Name</label>
                <input type="text" name="name" value="{{$role->name}}" class="form-control" placeholder="Name" required
                    autofocus>
            </div>
            <div class="form-group mb-3">
                <label>Job Description</label>
                <textarea class="form-control" placeholder="Description" rows="7" cols="50"
                    name="description">{{$role->description}}</textarea>
            </div>

            <div class="form-group">
                <label for="roles">Select Parent Role</label>
                <select name="role_id" class="select2 custom-select form-control-border" id="roles">
                    @foreach ($roles as $parent_role)
                    <option value="{{$parent_role->id}}" {{$role->role_id == $parent_role->id ? 'selected' : ''}}>{{$parent_role->display_name}}</option>
                    @endforeach
                </select>
            </div>

            <div style="float:right;">
                <button type="submit" class="btn btn-info">Edit Role</button>
            </div>
    </div>
    </form>
</div>
</div>
@endsection