@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>
    <!-- Filters -->
    <form>
        <div class="card card-info collapsed-card">
            <div class="card-header btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Left Side Filter --}}
                    <div class="col-6">
                        <table style="width:85%">
                            <tr>
                                <th class="col-4">Select Project :</th>
                                <td class="form-group">
                                    <select name="project_id" id="projects" class="custom-select form-control-border">
                                        <option></option>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}" {{ request()->get('project_id') == $project->id ? 'selected' : '' }}>
                                                {{ $project->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Select Multiple Projects :</th>
                                <td class="form-group">
                                    <select name="project_ids[]" id="projectss" class="select2 custom-select form-control-border" multiple>
                                        <option></option>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}" {{ in_array($project->id, request()->get('project_ids', [])) ? 'selected' : '' }}>
                                                {{ $project->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Choose Building :</th>
                                <td class="form-group">
                                    <select name="building_id[]" id="buildingFilter" class="select2 custom-select form-control-border" multiple>
                                        {{-- Retain building filter options here if they exist --}}
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Choose Unit :</th>
                                <td class="form-group">
                                    <select name="unit_id[]" id="unitsFilter" class="select2 custom-select form-control-border" multiple>
                                        {{-- Retain unit filter options here if they exist --}}
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Sales Man :</th>
                                <td class="form-group">
                                    <select name="user_id[]" class="select2 custom-select form-control-border" multiple>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}" {{ in_array($user->id, request()->get('user_id', [])) ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Status :</th>
                                <td class="form-group">
                                    <select name="status[]" class="select2 custom-select form-control-border" multiple>
                                        <option value="free" {{ in_array('free', request()->get('status', [])) ? 'selected' : '' }}>free</option>
                                        <option value="hold" {{ in_array('hold', request()->get('status', [])) ? 'selected' : '' }}>hold</option>
                                        <option value="reserved" {{ in_array('reserved', request()->get('status', [])) ? 'selected' : '' }}>reserved</option>
                                        <option value="downpayment" {{ in_array('downpayment', request()->get('status', [])) ? 'selected' : '' }}>downpayment</option>
                                        <option value="taken" {{ in_array('taken', request()->get('status', [])) ? 'selected' : '' }}>Contracted</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Type :</th>
                                <td class="form-group">
                                    <select name="type[]" class="select2 custom-select form-control-border" multiple>
                                        @foreach ($types as $type)
                                            <option value="{{ $type->id }}" {{ in_array($type->id, request()->get('type', [])) ? 'selected' : '' }}>
                                                {{ $type->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">Finishing :</th>
                                <td class="form-group">
                                    <select name="finishing[]" class="select2 custom-select form-control-border" multiple>
                                        @foreach ($typesFinishing as $finishing)
                                            <option value="{{ $finishing->id }}" {{ in_array($finishing->id, request()->get('finishing', [])) ? 'selected' : '' }}>
                                                {{ $finishing->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th class="col-4">View :</th>
                                <td class="form-group">
                                    <select name="view[]" class="select2 custom-select form-control-border" multiple>
                                        @foreach ($typesView as $view)
                                            <option value="{{ $view->id }}" {{ in_array($view->id, request()->get('view', [])) ? 'selected' : '' }}>
                                                {{ $view->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
    
                            @if (count($Allunits) != 0)
                                <tr>
                                    <th class="col-4">Floor :</th>
                                    <td class="form-group">
                                        <select name="floor[]" class="select2 custom-select form-control-border" multiple>
                                            @foreach ($Allunits->pluck('floor')->unique() as $floor)
                                                <option value="{{ $floor }}" {{ in_array($floor, request()->get('floor', [])) ? 'selected' : '' }}>
                                                    {{ $floor }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="col-4">Bedrooms :</th>
                                    <td class="form-group">
                                        <select name="bedrooms[]" class="select2 custom-select form-control-border" multiple>
                                            @foreach ($Allunits->pluck('bedrooms')->unique() as $bedrooms)
                                                <option value="{{ $bedrooms }}" {{ in_array($bedrooms, request()->get('bedrooms', [])) ? 'selected' : '' }}>
                                                    {{ $bedrooms }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="col-4">Bathrooms :</th>
                                    <td class="form-group">
                                        <select name="bathrooms[]" class="select2 custom-select form-control-border" multiple>
                                            @foreach ($Allunits->pluck('bathrooms')->unique() as $bathrooms)
                                                <option value="{{ $bathrooms }}" {{ in_array($bathrooms, request()->get('bathrooms', [])) ? 'selected' : '' }}>
                                                    {{ $bathrooms }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="col-4">Dressing :</th>
                                    <td class="form-group">
                                        <select name="dressing[]" class="select2 custom-select form-control-border" multiple>
                                            @foreach ($Allunits->pluck('dressing')->unique() as $dressing)
                                                <option value="{{ $dressing }}" {{ in_array($dressing, request()->get('dressing', [])) ? 'selected' : '' }}>
                                                    {{ $dressing }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                            @endif
                        </table>
                    </div>
    
                    {{-- Right Side Filter --}}
                    <div class="col-6">
                        {{-- Created At --}}
                        <table>
                            <tr>
                                <th colspan="4" style="text-align:center">Creation Date</th>
                            </tr>
                            <tr>
                                <th class="col-4">From</th>
                                <th class="col-4">To</th>
                            </tr>
                            <tr class="form-group">
                                <td>
                                    <input type="date" name="date1" value="{{ request()->get('date1', old('date1')) }}" class="form-control">
                                </td>
                                <td>
                                    <input type="date" name="date2" value="{{ request()->get('date2', old('date2')) }}" class="form-control">
                                </td>
                            </tr>
                            <tr class="form-group">
                                <td class="form-group">
                                    <input type="time" value="{{ request()->get('time1', old('time1')) }}" class="form-control" name="time1">
                                </td>
                                <td>
                                    <input type="time" name="time2" value="{{ request()->get('time2', old('time2')) }}" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
    
                        {{-- Booked Date --}}
                        <table>
                            <tr>
                                <th colspan="4" style="text-align:center">Booked Date</th>
                            </tr>
                            <tr>
                                <th class="col-4">From</th>
                                <th class="col-4">To</th>
                            </tr>
                            <tr class="form-group">
                                <td>
                                    <input type="date" name="bookedDate1" value="{{ request()->get('bookedDate1', old('bookedDate1')) }}" class="form-control">
                                </td>
                                <td>
                                    <input type="date" name="bookedDate2" value="{{ request()->get('bookedDate2', old('bookedDate2')) }}" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
    
                        {{-- Price Range --}}
                        <table>
                            <tr>
                                <th colspan="4" style="text-align:center">Price Range</th>
                            </tr>
                            <tr>
                                <th class="col-4">From: </th>
                                <td class="col-6">
                                    <input type="number" step="any" name="price1" value="{{ request()->get('price1', old('price1')) }}" class="form-control">
                                </td>
                            </tr>
                            <tr class="form-group">
                                <th class="col-4">To: </th>
                                <td class="col-6">
                                    <input type="number" step="any" name="price2" value="{{ request()->get('price2', old('price2')) }}" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
    
                        {{-- Space Range --}}
                        <table>
                            <tr>
                                <th colspan="4" style="text-align:center">Space Range</th>
                            </tr>
                            <tr>
                                <th class="col-4">From: </th>
                                <td class="col-6">
                                    <input type="number" step="any" name="space1" value="{{ request()->get('space1', old('space1')) }}" class="form-control">
                                </td>
                            </tr>
                            <tr class="form-group">
                                <th class="col-4">To: </th>
                                <td class="col-6">
                                    <input type="number" step="any" name="space2" value="{{ request()->get('space2', old('space2')) }}" class="form-control">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div style="float:right">
                    <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                    <button type="submit" class="btn btn-info">filter</button>
                </div>
            </div>
        </div>
    </form>
    
    <!-- End filters -->

    <!-- /.row -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Units</h3><br>
            <h4>Total: {{ $Allunits->total() }}</h4>
            {{-- <h4>Total: {{ count($Allunits) }}</h4> --}}
            <div class="btn-group" style="float:right">
                <a class="btn btn-outline-info" data-toggle="modal" style="float:right" title="Units Report"
                    data-target="#UnitsReportModal">
                    <i class="fas fa-file"></i>
                </a>
                @if (Request::path() != 'hiddenUnits' &&
                        auth()->user()->type == 'admin' &&
                        auth()->user()->role->hasPermission('units-hiddenUnits-read'))
                    <a href="{{ route('hiddenUnits') }}" class="btn btn-outline-danger" style="float:right"
                        title="Hidden units">
                        <i class="fas fa-eye-slash"></i>
                    </a>
                @endif
                <!-- <button type="button" class="btn btn-default">Action</button> -->
                <button type="button" title="Import" class="btn btn-light active dropdown-toggle dropdown-icon"
                    data-toggle="dropdown" style="">
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <div class="dropdown-menu" role="menu">
                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-upload'))
                        <a class="dropdown-item" data-toggle="modal" data-target='#UploadFileModal' href="#">
                            Import Units
                        </a>
                    @endif
                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-update-sheet'))
                        <a class="dropdown-item" data-toggle="modal" data-target='#UpdateSheetModal' href="#">
                            Import update Units
                        </a>
                    @endif
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <!--<div id="demo" class="display">-->
            <table
                id="{{ auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-export') ? 'original' : 'original-nonExport' }}"
                class="display nowrap" style="width:100%">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>phase</th>
                        <th>Building</th>
                        <th>Building Type</th>
                        <th>Project</th>
                        <th>Meter Price</th>
                        <th>Total Space</th>
                        <th>Garden Space</th>
                        <th>Garden Price</th>
                        <th>Roof Space</th>
                        <th>Roof Price</th>
                        <th>Total Cash Price</th>
                        <th>Floor</th>
                        <th>Bedroom</th>
                        <th>Bathrooms</th>
                        <th>Dressing</th>
                        <th>Type</th>
                        <th>Finishing Level</th>
                        <th>View</th>
                        <th>booked date</th>
                        <th>Client Name</th>
                        <th>Sales Man</th>
                        <th>status</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <th>Active</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($Allunits as $unit)
                        <?php $temp = explode(' ', $unit->created_at->setTimezone('Africa/Cairo')); ?>

                        @if (empty($unit->building->phase->project->id))
                        @else
                            <tr>
                                <td>{{ $unit->id }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-show'))
                                        <a href="{{ route('units.show', $unit->id) }}">
                                            {{ $unit->name }}
                                        </a>
                                    @else
                                        <a>
                                            {{ $unit->name }}
                                        </a>
                                    @endif
                                </td>
                                <td>
                                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('phases-show'))
                                        <a href="{{ route('phases.index', $unit->building->phase->id) }}">
                                            {{ $unit->building->phase->name }}
                                        </a>
                                    @else
                                        <a>
                                            {{ $unit->building->phase->name }}
                                        </a>
                                    @endif
                                </td>
                                <td>
                                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-show'))
                                        <a href="{{ route('buildings.index', $unit->building->id) }}">
                                            {{ $unit->building->name ?? '' }}
                                        </a>
                                    @else
                                        <a>
                                            {{ $unit->building->name ?? '' }}
                                        </a>
                                    @endif
                                </td>
                                <td>{{ $unit->building?->type ?? '' }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('projects-show'))
                                        <a href="{{ route('projects.index', $unit->building->phase->project->id) }}">
                                            {{ $unit->building?->phase?->project?->name ?? '' }}
                                        </a>
                                    @else
                                        <a>
                                            {{ $unit->building?->phase?->project?->name ?? '' }}
                                        </a>
                                    @endif
                                </td>

                                @php

                                    $unit_total_price = floatval($unit->unit_meter_price ?? 0);
                                    $unit_space = floatval($unit->unit_space ?? 0);

                                    $price = $unit_total_price * $unit_space;
                                @endphp
                                <td style="text-align:center">
                                    {{ $unit->unit_meter_price != 0 ? $unit->unit_meter_price : '--' }}</td>
                                <td>{{ $unit->unit_space ?? '' }}</td>

                                <td>{{ $unit->garden_space ?? '' }}</td>
                                <td>{{ $unit->garden_total_price ?? '' }}</td>
                                <td>{{ $unit->roof_space ?? 0 }}</td>
                                <td>{{ $unit->roof_total_price ?? '' }}</td>

                                <td>{{ $price ?? '' }}</td>

                                <td>{{ $unit->floor ?? '' }}</td>
                                <td>{{ $unit->bedrooms ?? '' }}</td>
                                <td>{{ $unit->bathrooms }}</td>
                                <td>{{ $unit->dressing }}</td>
                                <td>{{ $unit->typee?->name }}</td>
                                <td>{{ $unit->finishingLevel?->name }}</td>
                                <td>{{ $unit->vieww?->name }}</td>
                                <td>{{ $unit->Booked_date ?? '' }}</td>
                                <td>{{ $unit->client?->name ?? '' }}</td>
                                <td>{{ $unit->user->name ?? '' }}</td>
                                <td>{{ $unit->status == 'taken' ? 'Contracted' : $unit->status }}</td>
                                <td>{{ $temp[0] ?? '' }}</td>
                                <td>{{ $temp[1] ?? '' }}</td>
                                <td>
                                    <form action="{{ route('hideUnit', $unit->id) }}" method="POST">
                                        @csrf

                                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-hide'))
                                            <button type="submit"
                                                class="btn btn-{{ $unit->is_active == 1 ? 'danger' : 'success' }}">{{ $unit->is_active == 1 ? 'hide' : 'unhide' }}
                                            </button>
                                        @endif

                                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-show'))
                                            <a href="{{ route('units.show', $unit->id) }}" class="btn btn-warning"><i
                                                    class="fas fa-eye"></i>
                                            </a>
                                        @endif

                                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-edit'))
                                            <a href="{{ route('units.edit', $unit->id) }}" class="btn btn-info"><i
                                                    class="fas fa-pen"></i>
                                            </a>
                                        @endif
                                    </form>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>
            <!--</div>-->
            <div class="pagination">
                {{ $Allunits->appends(request()->input())->links() }}
            </div>
        </div>
        <!-- /.card-body -->
    </div>

    <!-- IMPORT Units -->
    <form action="{{ route('units.import') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UploadFileModal" tabindex="-1" role="dialog" aria-labelledby="UploadFileModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Units</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="upload-sheet" class="btn btn-outline-info" title="upload Sheet">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" name="file" id="upload-sheet" style="display:none">
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('UpdateSheetModal') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UpdateSheetModal" tabindex="-1" role="dialog" aria-labelledby="UpdateSheetModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Update Units</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="update-sheet" class="btn btn-outline-info" title="upload Sheet">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" name="file" id="update-sheet" style="display:none">
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('unitsReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UnitsReportModal" tabindex="-1" role="dialog" aria-labelledby="UnitsReportModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Units Report</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="projects">Select Project</label>
                            <select name="project_id" id="projects" class="custom-select form-control-border" required>
                                <option></option>
                                @foreach ($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="building_id">Choose Building</label>
                            <select name="building_id[]" onchange="getSelected()" id="building"
                                class="select2 custom-select form-control-border" multiple>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="unit_space">Choose Spaces</label>
                            <select name="unit_space[]" id="unit_space" class="select2 custom-select form-control-border"
                                multiple>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="unit_status">Choose Unit Status</label>
                            <select name="unit_status[]" id="unit_status"
                                class="select2 custom-select form-control-border" multiple>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="unit_finishing">Choose Finishing</label>
                            <select name="unit_finishing[]" id="unit_finishing"
                                class="select2 custom-select form-control-border" multiple>
                            </select>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">Export</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>

    <script>
        $(document).on('change', '#projects', function() {
            var data = this.value;
            $.ajax({
                data: {
                    'project_id': data
                },
                method: "POST",
                url: "{{ route('projectBuilding') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    let buildings = "";
                    Array.from(dataResult.buildings).forEach(myFunction2);

                    function myFunction2(item, index) {
                        buildings += `<option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("building").innerHTML = buildings;
                    document.getElementById("buildingFilter").innerHTML = buildings;

                }
            });

            $.ajax({
                data: {
                    'project_id': data
                },
                method: "POST",
                url: "{{ route('projectUnit') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);

                    let units = "";
                    let uniqueUnits = [];

                    Array.from(dataResult.projects).forEach(myFunction1);

                    function myFunction1(item, index) {
                        console.log(item);
                        uniqueUnits.push(item);
                        units += `<option value="` + item.id + `">` + item.name +
                            `</option>`;
                    }
                    document.getElementById("unitsFilter").innerHTML = units;

                }
            });
        });

        function getSelected() {
            let selectElement = document.getElementById('building');
            console.log(selectElement);
            var selectedOptions = Array.from(selectElement.selectedOptions);

            var selectedValues = selectedOptions.map(function(option) {
                return option.value;
            });
            var data = selectedValues;
            $.ajax({
                data: {
                    'building_id': data
                },

                method: "POST",
                url: "{{ route('unitsBuilding') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    console.log(dataResult);

                    let units_finishing = "";
                    let uniqueFinishing = [];

                    Array.from(dataResult.units).forEach(myFunction1);

                    function myFunction1(item, index) {
                        if (!uniqueFinishing.includes(item.finishing)) {
                            uniqueFinishing.push(item.finishing);
                            units_finishing += `<option value="` + item.finishing + `">` + item.finishing +
                                `</option>`;
                        }
                    }

                    let units_status = "";
                    let uniqueStatus = [];

                    Array.from(dataResult.units).forEach(myFunction);

                    function myFunction(item, index) {
                        if (!uniqueStatus.includes(item.status)) {
                            uniqueStatus.push(item.status);
                            units_status += `<option value="` + item.status + `">` + item.status +
                                `</option>`;
                        }
                    }

                    let unit_space = "";
                    let uniqueSpaces = [];
                    Array.from(dataResult.units).forEach(myFunction3);

                    function myFunction3(item, index) {
                        if (!uniqueSpaces.includes(item.unit_space)) {
                            uniqueSpaces.push(item.unit_space);
                            unit_space += `<option value="` + item.unit_space + `">` + item.unit_space +
                                `</option>`;
                        }
                    }

                    document.getElementById("unit_finishing").innerHTML = units_finishing;
                    document.getElementById("unit_status").innerHTML = units_status;
                    document.getElementById("unit_space").innerHTML = unit_space;
                }
            });
        }
    </script>
@endsection
