<?php

use App\Models\Unit;
use App\Models\Project;
use App\Models\Building;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CodeController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AgentController;
use App\Http\Controllers\BatchController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\PhaseController;
use App\Http\Controllers\ActionController;
use App\Http\Controllers\BrokerController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SourceController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\InqTypeController;
use App\Http\Controllers\InquiryController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\BuildingController;
use App\Http\Controllers\ContractController;
use App\Http\Controllers\MakeCallController;
use App\Http\Controllers\CallActionController;
use App\Http\Controllers\SourceTypeController;
use App\Http\Controllers\TicketTypeController;
use App\Http\Controllers\PaymentPlanController;
use App\Http\Controllers\PaymentTypeController;
use App\Http\Controllers\PhoneNumberController;
use App\Http\Controllers\UnitSettingController;
use App\Http\Controllers\LogsActivityController;
use App\Http\Controllers\PaymentPlanDetailsController;
use App\Http\Controllers\Administration\RoleController;
use App\Http\Controllers\Auth\RegisteredUserController;

use App\Http\Controllers\Administration\LeadsController;
use App\Http\Controllers\Administration\CampaignController;
use App\Http\Controllers\Administration\PermissionController;
use App\Http\Controllers\Administration\CommunicationController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/test', function () {
    echo "ssss";
});


Route::group(['middleware' => ['auth']], function () {
    Route::get('/', 'DashboardController@index')->name('dashboard');
    // Route::get('alerts', 'DashboardController@alerts');
    Route::get('/profile', 'UserController@profile')->name('profile');
    Route::get('/editProfile/{id}', 'UserController@editProfile')->name('editProfile');
    Route::put('/updateProfile/{user}', 'UserController@updateProfile')->name('updateProfile');

    // Route::get('/', function () {
    //     return view('welcome');
    // });

    Route::get('addUser', [RegisteredUserController::class, 'create'])->name('addUser');
    Route::post('addUser/store', [RegisteredUserController::class, 'store'])->name('storeUser');
    Route::resource('users', UserController::class);
    Route::get('block/{id}', [UserController::class, 'block'])->name('block');
    Route::get('unblock/{id}', [UserController::class, 'unblock'])->name('unblock');
    Route::get('blocklist', [UserController::class, 'blocklist'])->name('blocklist');
    Route::get('users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::get('usersTree', [UserController::class, 'usersTree'])->name('usersTree');
    Route::get('users/destroy/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // Roles Routes
    Route::get('roles', [RoleController::class, 'index'])->name('index.roles');
    Route::get('roles/create', [RoleController::class, 'create'])->name('roles.create');
    Route::post('roles/create', [RoleController::class, 'store'])->name('roles.store');
    Route::get('roles/show/{roleId}', [RoleController::class, 'show'])->name('roles.show');
    Route::get('roles/edit/{roleId}', [RoleController::class, 'edit'])->name('roles.edit');
    Route::put('roles/edit/{roleId}', [RoleController::class, 'update'])->name('roles.update');
    Route::delete('roles/destroy/{roleId}', [RoleController::class, 'destroy'])->name('roles.destroy');
    Route::get('roles/archive', [RoleController::class, 'Roles_Archive'])->name('Roles_Archive');
    Route::get('roles/restore/{roleId}', [RoleController::class, 'restore'])->name('roles.restore');
    Route::get('roles/restore-all', [RoleController::class, 'restoreAll'])->name('roles.restoreAll');
    Route::get('roles/deletePermanently/{id}', [RoleController::class, 'deletePermanently'])->name('roles.deletePermanently');

    Route::get('rolesTree', [RoleController::class, 'rolesTree'])->name('rolesTree');

    // Permissions Routes
    Route::get('permissions', [PermissionController::class, 'index'])->name('index.permissions');
    Route::get('permissions/create', [PermissionController::class, 'create'])->name('permissions.create');
    Route::post('permissions/create', [PermissionController::class, 'store'])->name('permissions.store');
    Route::get('permissions/show/{permissionId}', [PermissionController::class, 'show'])->name('permissions.show');
    Route::get('permissions/edit/{permissionId}', [PermissionController::class, 'edit'])->name('permissions.edit');
    Route::put('permissions/edit/{permissionId}', [PermissionController::class, 'update'])->name('permissions.update');
    Route::delete('permissions/destroy/{permissionId}', [PermissionController::class, 'destroy'])->name('permissions.destroy');
    Route::post('permissions/add', [PermissionController::class, 'addPermission'])->name('permissions.add');
    Route::get('permissions/users/{id}', [PermissionController::class, 'getUserPermissions'])->name('permissions.getUser');
    Route::post('permissions/addRole', [PermissionController::class, 'addRolePermission'])->name('permissions.addRole');
    Route::get('permissions/roles/{id}', [PermissionController::class, 'getRolePermissions'])->name('permissions.getRole');

    // Leads Routes
    Route::get('leads/create', [LeadsController::class, 'create'])->name('leads.create');
    Route::post('leads/create', [LeadsController::class, 'store'])->name('leads.store');
    Route::get('leads/edit/{leadId}', [LeadsController::class, 'edit'])->name('leads.edit');
    Route::put('leads/edit/{leadId}', [LeadsController::class, 'update'])->name('leads.update');
    Route::get('leads/show/{leadId}', [LeadsController::class, 'show'])->name('leads.show');
    Route::delete('leads/destroy/{leadId}', [LeadsController::class, 'destroy'])->name('leads.destroy');
    Route::get('leads/archive', [LeadsController::class, 'archive'])->name('leads.archive');
    Route::get('leads/restore/{leadId}', [LeadsController::class, 'restore'])->name('leads.restore');
    Route::get('leads/restore-all', [LeadsController::class, 'restoreAll'])->name('leads.restoreAll');
    Route::get('leads/deletePermanently/{id}', [LeadsController::class, 'deletePermanently'])->name('leads.deletePermanently');
    Route::post('leads/stream/create/{leadId}', [LeadsController::class, 'createStream'])->name('leads.createStream');
    Route::post('leads/reAssignUser/{leadId}', [LeadsController::class, 'reAssignUser'])->name('leads.reAssignUser');
    Route::post('leads/ChangeStatus/{leadId}', [LeadsController::class, 'ChangeStatus'])->name('leads.ChangeStatus');
    Route::get('lead/makeCall/{leadId}', [MakeCallController::class, 'makeCall'])->name('makeCall');
    Route::post('PhoneCode', [LeadsController::class, 'PhoneCode'])->name('PhoneCode');
    Route::post('campaignSources', [LeadsController::class, 'campaignSources'])->name('campaignSources');
    Route::get('CILs', [LeadsController::class, 'CILs'])->name('CILs');
    Route::get('confirmCIL/{id}', [LeadsController::class, 'confirmCIL'])->name('confirmCIL');
    Route::get('allLeads/{status?}', [LeadsController::class, 'index'])->name('leads.index');
    Route::post('allLeads/{status?}', [LeadsController::class, 'index'])->name('leads.index');
    Route::get('export', [LeadsController::class, 'export'])->name('leads.export');
    Route::get('importExportVieww', [LeadsController::class, 'importView'])->name('leads.importView');
    Route::post('import', [LeadsController::class, 'import'])->name('leads.import');
    Route::get('leadsBulk/{leads}', [LeadsController::class, 'bulkAction'])->name('leads.bulkAction');
    Route::get('delayLeads', [LeadsController::class, 'delayLeads'])->name('delayLeads');
    Route::get('allLeads/leads/export', [LeadsController::class, 'getLeads'])->name('get-leads');
    Route::post('check-mobile-number', [LeadsController::class, 'checkMobileNumber'])->name('check-mobile-number');

    // Communication Routes

    Route::resource('communications', CommunicationController::class);
    // Route::get('communications', [CommunicationController::class, 'index'])->name('communications.index');
    Route::get('communications/create/{leadId?}', [CommunicationController::class, 'create'])->name('communications.create');
    // Route::post('communications/store', [CommunicationController::class, 'store'])->name('communications.store');
    // Route::get('communications/show/{communicationId}', [CommunicationController::class, 'show'])->name('communications.show');
    Route::post('communications/changeStatus/{communicationId}', [CommunicationController::class, 'changeStatus'])->name('communications.changeStatus');
    Route::get('nextActions', [CommunicationController::class, 'nextActions'])->name('nextActions');
    Route::get('myActions', [CommunicationController::class, 'myActions'])->name('myActions');

    // Clients Route
    Route::get('clients/create/{leadId?}', [ClientController::class, 'create'])->name('clients.create');
    Route::get('clients/archive', [ClientController::class, 'archive'])->name('clients.archive');
    Route::get('clients/restore/{clientId}', [ClientController::class, 'restore'])->name('clients.restore');
    Route::get('clients/restore-all', [ClientController::class, 'restoreAll'])->name('clients.restoreAll');
    Route::resource('clients', ClientController::class)->except(['create']);
    Route::post('importClients', [ClientController::class, 'import'])->name('clients.import');
    Route::post('searchImport', [ClientController::class, 'searchImport'])->name('searchImport');
    Route::get('clients/deletePermanently/{id}', [ClientController::class, 'deletePermanently'])->name('clients.deletePermanently');
    Route::get('clients/deleteImage/{id}', [ClientController::class, 'deleteImage'])->name('clients.deleteImage');
    Route::post('ClientSourceImport', [ClientController::class, 'ClientSourceImport'])->name('ClientSourceImport');

    Route::get('contract/{id}', [ClientController::class, 'setContract'])->name('clients.contract');
    Route::post('clients/fileUpload', [ClientController::class, 'fileUpload'])->name('ClientfileUpload');
    Route::post('ImgUpload/{id}', [ClientController::class, 'ImgUpload'])->name('ClientImgUpload');
    Route::post('printContract/{id}', [ClientController::class, 'printContract'])->name('printContract');
    Route::get('restoreClient/{id}', [ClientController::class, 'restoreClient'])->name('restoreClient');
    Route::get('forceDelete/{id}', [ClientController::class, 'forceDelete'])->name('forceDelete');
    Route::get('showTrashed/{id}', [ClientController::class, 'showTrashed'])->name('showTrashed');
    Route::get('reservationForm/{id}', [ClientController::class, 'reservationForm'])->name('Reservation.form');
    Route::post('unitReservation', [ClientController::class, 'unitReservation'])->name('unitReservation');
    Route::post('get-payment-plans', [ClientController::class, 'getPaymentPlans'])->name('getPaymentPlans');

    Route::post('AssignUnit', [ClientController::class, 'AssignUnit'])->name('AssignUnit');
    Route::post('reservationContract', [ClientController::class, 'reservationContract'])->name('reservationContract');
    Route::post('storeReservationContract', [ClientController::class, 'storeReservationContract'])->name('storeReservationContract');
    Route::get('toLead/{id}', [ClientController::class, 'toLead'])->name('toLead');
    Route::post('AccessUsers', [ClientController::class, 'AccessUsers'])->name('AccessUsers');

    // Phone Numbers
    Route::resource('phones', PhoneNumberController::class);

    //Projects
    Route::resource('projects', ProjectController::class);
    Route::post('hideProject/{id}', [ProjectController::class, 'hideProject'])->name('hideProject');
    Route::post('projects/fileUpload', [ProjectController::class, 'fileUpload'])->name('ProjectfileUpload');
    Route::get('archive', [ProjectController::class, 'archive'])->name('projects.archive');
    Route::get('projectsRestore/{ProjectId}', [ProjectController::class, 'restore'])->name('project.restore');
    Route::get('projectsRestore-all', [ProjectController::class, 'restoreAll'])->name('projects.restoreAll');
    Route::get('project/deletePermanently/{id}', [ProjectController::class, 'deletePermanently'])->name('project.deletePermanently');
    Route::get('project/deleteImage/{id}', [ProjectController::class, 'deleteImage'])->name('project.deleteImage');
    Route::get('get-projects', [ProjectController::class, 'getProjects'])->name('get-projects');

    //Phases
    Route::resource('phases', PhaseController::class);
    Route::post('hidePhase/{id}', [PhaseController::class, 'hidePhase'])->name('hidePhase');
    Route::get('phasesArchive', [PhaseController::class, 'archive'])->name('phasesArchive');
    Route::get('phasesRestore/{phaseId}', [PhaseController::class, 'restore'])->name('phasesRestore');
    Route::get('phasesRestore-all', [PhaseController::class, 'restoreAll'])->name('phases.restoreAll');
    Route::get('phase/deletePermanently/{id}', [PhaseController::class, 'deletePermanently'])->name('phase.deletePermanently');

    //Building
    Route::resource('buildings', BuildingController::class);
    Route::post('hideBuilding/{id}', [BuildingController::class, 'hideBuilding'])->name('hideBuilding');
    Route::get('buildingsArchive', [BuildingController::class, 'archive'])->name('buildingsArchive');
    Route::get('buildingsRestore/{buildingId}', [BuildingController::class, 'restore'])->name('buildingsRestore');
    Route::get('buildingsRestore-all', [BuildingController::class, 'restoreAll'])->name('buildings.restoreAll');
    Route::get('building/deletePermanently/{id}', [BuildingController::class, 'deletePermanently'])->name('building.deletePermanently');

    //Settings
    Route::resource('unitSettings', UnitSettingController::class);
    Route::post('ExtraTime', [UnitSettingController::class, 'SetExtraTime'])->name('SetExtraTime');
    Route::resource('notifications', NotificationController::class);

    // Unit Controller
    Route::resource('units', UnitController::class);
    Route::post('hideUnit/{id}', [UnitController::class, 'hideUnit'])->name('hideUnit');
    Route::post('changeStatus', [UnitController::class, 'changeStatus'])->name('changeStatus');
    Route::post('deliveryDate', [UnitController::class, 'deliveryDate'])->name('deliveryDate');
    Route::get('importExportView', [UnitController::class, 'importView'])->name('units.importView');
    Route::post('units-import', [UnitController::class, 'import'])->name('units.import');
    Route::post('UpdateSheetModal', [UnitController::class, 'UpdateSheetModal'])->name('UpdateSheetModal');
    Route::post('units/fileUpload', [UnitController::class, 'fileUpload'])->name('UnitfileUpload');
    // Route::post('ImgUpload/{id}',[UnitController::class,'ImgUpload'])->name('UnitImgUpload');
    Route::get('unitsArchive', [UnitController::class, 'archive'])->name('unitsArchive');
    Route::get('unitsRestore/{unitId}', [UnitController::class, 'restore'])->name('unitsRestore');
    Route::get('unitsRestore-all', [UnitController::class, 'restoreAll'])->name('units.restoreAll');
    Route::get('unitsHistory/{unitId}', [UnitController::class, 'history'])->name('unitsHistory');
    Route::post('projectBuilding', [UnitController::class, 'projectBuilding'])->name('projectBuilding');
    Route::post('projectUnit', [UnitController::class, 'projectUnit'])->name('projectUnit');
    Route::post('unitsBuilding', [UnitController::class, 'unitsBuilding'])->name('unitsBuilding');
    Route::get('units/deleteImage/{id}', [UnitController::class, 'deleteImage'])->name('unit.deleteImage');
    Route::get('unitDeliveryStatus/{id}', [UnitController::class, 'unitDeliveryStatus'])->name('unitDeliveryStatus');
    Route::get('hiddenUnits', [UnitController::class, 'hiddenUnits'])->name('hiddenUnits');
    Route::post('transfareUnit', [UnitController::class, 'transfareUnit'])->name('transfareUnit');
    Route::post('reservation/report', [UnitController::class, 'reservationReport'])->name('reservation.report');
    Route::get('reservation/report/{id}', [UnitController::class, 'showReservationReport'])->name('showReservation.report');
    Route::post('reservation/{id}/cancel', [UnitController::class, 'cancelUnit'])->name('units.cancel');


    // Events Routes
    Route::get('calendar', [EventController::class, 'index'])->name('calendar.index');
    Route::post('calendar/create-event', [EventController::class, 'create'])->name('calendar.create');
    Route::put('calendar/edit-event', [EventController::class, 'edit'])->name('calendar.edit');
    Route::delete('calendar/remove-event', [EventController::class, 'destroy'])->name('calendar.destroy');
    Route::get('meetings', [EventController::class, 'listMeeting'])->name('listMeeting');

    // Campaigns Route
    Route::get('campaigns', [CampaignController::class, 'index'])->name('campaigns.index');
    Route::get('campaigns/create', [CampaignController::class, 'create'])->name('campaigns.create');
    Route::post('campaigns/create', [CampaignController::class, 'store'])->name('campaigns.store');
    Route::get('campaigns/edit/{campaignId}', [CampaignController::class, 'edit'])->name('campaigns.edit');
    Route::put('campaigns/edit/{campaignId}', [CampaignController::class, 'update'])->name('campaigns.update');
    Route::get('campaigns/show/{campaignId}', [CampaignController::class, 'show'])->name('campaigns.show');
    Route::delete('campaigns/destroy/{campaignId}', [CampaignController::class, 'destroy'])->name('campaigns.destroy');

    // Source types
    Route::resource('sourceTypes', SourceTypeController::class);

    // Sources
    Route::resource('sources', SourceController::class);

    // Tickets
    Route::resource('tickets', TicketController::class);
    Route::post('projectUnits', [TicketController::class, 'projectUnits'])->name('projectUnits');
    Route::put('TicketChangeStatus/{id}', [TicketController::class, 'TicketChangeStatus'])->name('TicketChangeStatus');
    Route::put('reAssignUser/{id}', [TicketController::class, 'reAssignUser'])->name('reAssignUser');
    Route::get('delayTickets', [TicketController::class, 'delayTickets'])->name('delayTickets');

    // Ticket Actions 
    Route::resource('actions', ActionController::class);
    // Ticket Details 
    Route::resource('comments', CommentController::class);

    // Ticket types
    Route::resource('ticket-types', TicketTypeController::class);

    // Payments
    Route::resource('payments', PaymentController::class);
    // Route::get('newClients', [PaymentController::class, 'newClients'])->name('newClients');
    // Route::get('PaymentsOfClient/{id}', [PaymentController::class, 'PaymentsOfClient'])->name('PaymentsOfClient');

    // Facilities
    Route::resource('facilities', FacilityController::class);

    Route::resource('logsActivities', LogsActivityController::class);
    Route::post('filter', [LogsActivityController::class, 'filter'])->name('filter');
    Route::post('exportLog', [LogsActivityController::class, 'exportLog'])->name('exportLog');

    // Reports
    Route::resource('reports', ReportController::class);
    Route::get('exportUL', [ReportController::class, 'exportUL'])->name('reports.export');

    Route::get('userLeads', [ReportController::class, 'userLeads'])->name('userLeads');
    Route::get('ProjectCampagins', [ReportController::class, 'ProjectCampagins'])->name('ProjectCampagins');
    Route::get('CampaignLeads', [ReportController::class, 'CampaignLeads'])->name('CampaignLeads');
    Route::get('userSales', [ReportController::class, 'userSales'])->name('userSales');
    Route::get('userActions', [ReportController::class, 'userActions'])->name('userActions');
    Route::get('ProjectIncome', [ReportController::class, 'ProjectIncome'])->name('ProjectIncome');
    Route::post('unitsReport', [ReportController::class, 'unitsReport'])->name('unitsReport');
    Route::post('DailyCrmReport', [ReportController::class, 'DailyCrmReport'])->name('DailyCrmReport');
    Route::post('DailySalesReport', [ReportController::class, 'DailySalesReport'])->name('DailySalesReport');
    Route::post('projectsReport', [ReportController::class, 'projectsReport'])->name('projectsReport');
    Route::post('cilReport', [ReportController::class, 'cilReport'])->name('cilReport');

    Route::resource('statuses', StatusController::class);

    // Contracts
    Route::resource('contracts', ContractController::class);
    Route::get('printContract/{id}', [ContractController::class, 'printContract'])->name('printContract');
    Route::get('ContractDelivered/{id}', [ContractController::class, 'ContractDelivered'])->name('ContractDelivered');
    Route::get('ClientContracts', [ContractController::class, 'ClientContracts'])->name('ClientContracts');

    Route::get('cContractsArchive', [ContractController::class, 'archive'])->name('cContractsArchive');
    Route::get('cContractsRestore/{cContractId}', [ContractController::class, 'restore'])->name('cContractsRestore');
    Route::get('cContractsRestore-all', [ContractController::class, 'restoreAll'])->name('cContracts.restoreAll');

    Route::resource('codes', CodeController::class);

    // unit client contract
    Route::get('unitContract/{unitId}/{clientId}', [ContractController::class, 'unitContract'])->name('unitContract');
    Route::post('generateContract', [ContractController::class, 'generateContract'])->name('generateContract');

    Route::resource('alerts', AlertController::class);

    Route::resource('paymentTypes', PaymentTypeController::class);

    Route::resource('paymentPlans', PaymentPlanController::class);

    Route::resource('paymentPlanDetails', PaymentPlanDetailsController::class);

    Route::resource('batches', BatchController::class)->except(['create', 'index', 'show']);
    Route::get('SavePayment/{batchId}', [BatchController::class, 'SavePayment'])->name('SavePayment');
    Route::get('batches/create/{unitId}', [BatchController::class, 'create'])->name('batches.create');
    Route::get('batches/{unitId}', [BatchController::class, 'index'])->name('batches.index');
    Route::get('batch/{unitId}', [BatchController::class, 'show'])->name('batches.show');

    Route::resource('galleries', GalleryController::class);

    Route::resource('callActions', CallActionController::class);
    Route::post('actionTypes', [CommunicationController::class, 'actionTypes'])->name('actionTypes');
    Route::post('checkIn', [CommunicationController::class, 'checkIn'])->name('checkIn');
    Route::post('activityReAssign', [CommunicationController::class, 'activityReAssign'])->name('activityReAssign');

    // Broker
    Route::resource('brokers', BrokerController::class);
    Route::post('broker/fileUpload', [BrokerController::class, 'fileUpload'])->name('BrokerfileUpload');
    Route::get('broker/archive', [BrokerController::class, 'brokersArchive'])->name('brokersArchive');
    Route::get('brokersRestore-all', [BrokerController::class, 'restoreAll'])->name('brokers.restoreAll');
    Route::get('brokerRestore/{brokerId}', [BrokerController::class, 'restore'])->name('broker.Restore');
    Route::get('broker/deletePermanently/{id}', [BrokerController::class, 'deletePermanently'])->name('broker.deletePermanently');
    Route::get('broker/deleteImage/{id}', [BrokerController::class, 'deleteImage'])->name('broker.deleteImage');
    Route::post('brokers/import', [BrokerController::class, 'importBrokers'])->name('brokers.import');
    Route::get('brokerBulkAction/{brokers}', [BrokerController::class, 'brokerBulkAction'])->name('brokerBulkAction');
    Route::get('ActivityManagment', [BrokerController::class, 'activityManagment'])->name('activityManagment');
    Route::post('brokerAgents', [BrokerController::class, 'brokerAgents'])->name('brokerAgents');
    Route::post('brokerStatus', [BrokerController::class, 'brokerStatus'])->name('brokerStatus');
    Route::post('brokerReAssign', [BrokerController::class, 'brokerReAssign'])->name('brokerReAssign');

    // Files
    Route::resource('files', FileController::class);

    // Streams
    Route::resource('streams', StreamController::class);

    // Agent
    Route::resource('agents', AgentController::class);

    // Inquiry
    Route::resource('inquiries', InquiryController::class);
    Route::post('inquiryReAssign', [InquiryController::class, 'inquiryReAssign'])->name('inquiryReAssign');

    // Inquiry Types (Request types)
    Route::resource('inqTypes', InqTypeController::class);

    Route::get('refactor', function () {
        $units = Unit::where('project_id', NULL)->get();
        foreach ($units as $unit) {
            $building = Building::find($unit->building_id);
            $project = $building->phase->project;
            $unit->project_id = $project->id;
            $unit->save();
        }
    });
});

Route::get('broker/registeration', [BrokerController::class, 'brokerRegistration'])->name('broker.registration');

require __DIR__ . '/auth.php';
