<table
    id="<?php echo e(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('leads-export') ? 'original' : 'original-nonExport'); ?>"
    class="display nowrap" style="width:100%">
    <thead>
        <tr>
            <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
            <th>Name</th>
            <?php for($i = 1; $i <= $leadNumbers; $i++): ?>
                <th>Phone Number <?php echo e($i); ?></th>
            <?php endfor; ?>
            <th>Assigned To</th>
            <?php for($i = 1; $i <= 3; $i++): ?>
                <th>Last Comment <?php echo e($i); ?></th>
            <?php endfor; ?>

            <th>Last action date</th>
            <th>Next action date</th>
            <th>Status</th>
            <th>Note</th>
            <th>Lead Target</th>
            <th>Source Type</th>
            <th>Campaign</th>
            <th>Project</th>
            <th>Tag</th>
            <th>Created by</th>
            <th>Created Date</th>
            <th>Created Time</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $temp = explode(' ', $lead->created_at->setTimezone('Africa/Cairo'));
            ?>

            <tr>
                <td><input type="checkbox" id="chk_lead" class="checkboxAll sub_chk" data-id="<?php echo e($lead->id); ?>">
                </td>
                <td>
                    <a href="<?php echo e(route('leads.show', $lead->id)); ?>"><?php echo e($lead->name); ?></a>
                </td>

                <!-- Phone number -->
                <?php for($i = 0; $i < $leadNumbers; $i++): ?>
                    <td>
                        <?php echo e($lead->phone_numbers[$i]->country->phonecode ?? '--'); ?>

                        <?php echo e($lead->phone_numbers[$i]->phone ?? '--'); ?>


                    </td>
                <?php endfor; ?>

                <td>
                    <?php if($lead->user_id != null): ?>
                        <a title="Edit" href="<?php echo e(route('users.show', $lead->user_id)); ?>">
                            <?php echo e($lead->user?->name); ?>

                        </a>
                    <?php endif; ?>
                </td>

                <?php if(auth()->user()->role->name == 'Sales Agent' && $lead->communications->last()?->user_id != auth()->user()->id): ?>
                    <?php for($i = 0; $i < 3; $i++): ?>
                        <td>--</td>
                    <?php endfor; ?>
                <?php else: ?>
                    <?php $communications = $lead->communications()->orderBy('id', 'desc')->take(3)->get(); ?>


                    <?php $__currentLoopData = $communications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $communication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($communication->description ?? '--'); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <?php for($i = count($communications); $i < 3; $i++): ?>
                        <td>--</td>
                    <?php endfor; ?>
                <?php endif; ?>

                <td>
                    <?php echo e($lead->communications->last()?->created_at->format('Y-m-d H:i') ?? 'not yet'); ?>

                </td>

                <td>
                    <?php echo e(\Carbon\Carbon::parse($lead->communications->last()?->event?->start)->format('Y-m-d')); ?>

                </td>

                <?php if($lead->LeadStatus): ?>
                    <td class="badge badge-<?php echo e($lead->LeadStatus->color); ?>" style=" margin-top:12px;margin-left:10px;">
                        <?php echo e(ucwords($lead->LeadStatus?->name) ?? ''); ?>

                    </td>
                <?php else: ?>
                    <td> -- </td>
                <?php endif; ?>
                <td><?php echo e($lead->note ?? ''); ?></td>
                <td><?php echo e($lead->source?->name ?? ''); ?></td>
                <td><?php echo e($lead->source?->sourceType?->name ?? ''); ?></td>
                <td><?php echo e($lead->campaign?->name ?? ''); ?></td>
                <td><?php echo e($lead->project?->name ?? ''); ?></td>

                <td><?php echo e($lead->tag ?? ''); ?></td>

                <td>
                    <?php if($lead->created_by != null): ?>
                        <a href="<?php echo e(route('leads.show', $lead->created_by_user->id)); ?>">
                            <?php echo e($lead->created_by_user->name); ?>

                        </a>
                    <?php endif; ?>
                </td>

                <td><?php echo e($temp[0]); ?></td>
                <td><?php echo e($temp[1]); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<div class="pagination">
    <?php echo e($leads->links()); ?>

</div>
<?php /**PATH /home/rfg/public_html/demo/resources/views/leads/partials/leads_table.blade.php ENDPATH**/ ?>