
<?php $__env->startSection('content'); ?>

    <div class="row">
        
        <div class="card col-6" style="margin-right:20px;">
            <div class="card-header">
                <div class="card-title">
                    <h4>
                        <?php echo e($ticket->unit->name); ?> - <?php echo e($ticket->client->name); ?>

                    </h4>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if($ticket->status != 'done'): ?>
                        
                        <div class="col-6">
                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('tickets-assignUser')): ?>
                                <form action="<?php echo e(route('reAssignUser', $ticket->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <label>Re-assign User</label><br>
                                    <div class="row">
                                        <select name="user_id" class="select2 custom-select form-control-border col-5">
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($user->id); ?>" <?php echo e($ticket->assigned_to->id == $user->id ? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <button type="submit" class="btn btn-info">Change</button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-6">
                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('tickets-changeStatus')): ?>
                                <form action="<?php echo e(route('TicketChangeStatus', $ticket->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <label>Change Status</label><br>
                                    <?php if($ticket->status == 'pending'): ?>
                                        <select name="status" class="custom-select form-control-border col-6">
                                            <option value="follow_up">follow up</option>
                                            <option value="done">Done</option>
                                        </select>
                                    <?php else: ?>
                                        <select name="status" class="custom-select form-control-border col-6">
                                            <option value="done">Done</option>
                                        </select>
                                    <?php endif; ?>
                                    <button type="submit" class="btn btn-danger">Change</button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <hr>
                
                <table>
                    <tr>
                        <th>ID :</th>
                        <td>
                            <?php echo e($ticket->id); ?>

                            <span style="color:#dc3545"><?php echo e($ticket->delay == 1 ? 'Delay ticket' : ''); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th>Client ID :</th>
                        <td>
                            <a href="<?php echo e(route('clients.show', $ticket->client->id)); ?>">
                                <?php echo e($ticket->client->name); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Assigned User:</th>
                        <td>
                            <a href="<?php echo e(route('users.show', $ticket->assigned_to->id)); ?>">
                                <?php echo e($ticket->assigned_to->name); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Created By:</th>
                        <td>
                            <a href="<?php echo e(route('users.show', $ticket->user_id)); ?>">
                                <?php echo e($ticket->ticket_created_by->name); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Project:</th>
                        <td>
                            <a href="<?php echo e(route('projects.show', $ticket->project->id)); ?>">
                                <?php echo e($ticket->project->name); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Unit:</th>
                        <td>
                            <a href="<?php echo e(route('units.show', $ticket->unit->id)); ?>">
                                <?php echo e($ticket->unit->name); ?>

                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Description:</th>
                        <td>
                            <?php echo e($ticket->description); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Communication Method :</th>
                        <td>
                            <?php echo e($ticket->method->name); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Ticket Type :</th>
                        <td>
                            <?php echo e($ticket->ticket_type->name); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Status :</th>
                        <td>
                            <?php echo e($ticket->status); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Call Date:</th>
                        <td>
                            <?php echo e(Carbon\Carbon::parse($ticket->call_date)->format('Y-m-d') ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Created at :</th>
                        <td>
                            <?php echo e(Carbon\Carbon::parse($ticket->created_at)->format('Y-m-d H:i:s') ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Deadline :</th>
                        <td>
                            <?php echo e(Carbon\Carbon::parse($ticket->deadline)->format('Y-m-d') ?? ''); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Total Impression :</th>
                        <td>
                            <?php echo e($ticket->client->tag?->name ?? ''); ?>

                        </td>
                    </tr>
                </table>
                <?php if(count($ticket->files) != 0): ?>
                    <hr>
                    <span style="font-weight:bold;">Attached Files</span><br>
                    <div class="row">
                        <?php $__currentLoopData = $ticket->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="col-3">
                                <a href="<?php echo e(url('/images/' . $file->file)); ?>"><?php echo e($file->file); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card card-outline col-5">
            <div class="card-header">
                
                <?php if($ticket->status != 'done'): ?>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('tickets-createComment')): ?>
                        <form action="<?php echo e(route('comments.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <!-- text input -->
                                    <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                                    <div class="form-group">
                                        <label>Comment</label>
                                        <textarea type="text" name="description" class="form-control" required></textarea>
                                    </div>
                                </div>
                                <input type="hidden" name="comment_status" value="<?php echo e($ticket->status); ?>">
                                <input type="hidden" name="created_by" value="<?php echo e(auth()->user()->id); ?>">
                                <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                            </div>
                            <div class="form-group">
                                <label for="Files">Related Files / Images</label>
                                <input name="files[]" type="file" multiple>
                            </div>

                            <button type="submit" class="btn btn-info" style="float:right">
                                submit
                            </button>

                        </form>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            
            <div class="card-body" style="overflow-y: scroll;height:410px;">
                <?php $__currentLoopData = $ticket->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <table>
                        <tr>
                            <th> Description :</th>
                            <td><?php echo e($comment->description); ?></td>
                        </tr>
                        <tr>
                            <th>Status :</th>
                            <td><?php echo e($comment->status); ?></td>
                        </tr>
                        <tr>
                            <th>Created by :</th>
                            <td>
                                <?php echo e($comment->user->id ?? ''); ?> -
                                <?php echo e($comment->user->name ?? ''); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>Date :</th>
                            <td>
                                <?php echo e(Carbon\Carbon::parse($comment->created_at)->format('Y-m-d H:i:s') ?? ''); ?>

                            </td>
                        </tr>
                        <?php if(isset($comment->files) != 0): ?>
                            <tr>
                                <th>Files: </th>
                                <td>
                                    <?php $__currentLoopData = $comment->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(url('/images/' . $file->file)); ?>"><?php echo e($file->file); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </table>
                    <hr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <hr>
    
    <div class="col-12">
        <table
            id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('ticket-history-export')? 'example1': 'nonExport'); ?>

            class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Ticket ID</th>
                    <th>Ticket Creator</th>
                    <th>Ticket Type</th>
                    <th>Ticket Creation Date</th>
                    <th>Client Name</th>
                    <th>Client Mobile</th>
                    <th>Action</th>
                    <th>Details</th>
                    <th>Assigned User</th>
                    <th>Action created at</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <?php $action_created_at = explode(' ', $action->created_at->setTimezone('Africa/Cairo')); ?>
                    <?php $ticket_created_at = explode(' ', $action->ticket->created_at->setTimezone('Africa/Cairo')); ?>
                    <tr>
                        <td><?php echo e($action->ticket_id ?? ''); ?></td>
                        <td>
                            <?php echo e($action->created_by?->name ?? ''); ?>

                        </td>

                        <td>
                            <?php echo e($action->ticket->ticket_type?->name ?? ''); ?>

                        </td>
                        <td>
                            <?php echo e(Carbon\Carbon::parse($action->ticket->created_at)->format('Y-m-d H:i:s') ?? ''); ?>

                        </td>
                        <td>
                            <?php echo e($action->client->name ?? ''); ?>

                        </td>
                        <td>
                            <?php $__currentLoopData = $action->client->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($phone->country->phonecode); ?> <?php echo e($phone->phone); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td>
                            <?php echo e($action->action_type ?? ''); ?>

                        </td>
                        <td>
                            <?php echo e($action->details ?? ''); ?>

                        </td>
                        <td>
                            <?php echo e($action->assigned_user_name ?? ''); ?>

                        </td>
                        <td>
                            <?php echo e(Carbon\Carbon::parse($action->created_at)->format('Y-m-d H:i:s') ?? ''); ?>

                        </td>

                        
                    </tr>
                    
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <br>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/tickets/show.blade.php ENDPATH**/ ?>