<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\User;
use App\Models\Broker;
use App\Models\Communication;
use App\Models\Notifications;
use Illuminate\Support\Facades\Notification;
use Carbon\Carbon;

class CommunicationReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'communication:reminder';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Communication Reminder';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $communications = Communication::whereNotNull('reminder')->get();

        foreach($communications as $communication){

            $user = User::find($communication->user_id);                
            if(!empty($user)){
                $user = User::find($communication->user_id);
                $broker = Broker::find($communication->broker_id);
                $reminder = Carbon::parse($communication->reminder);
                $todayDate = Carbon::now();
                
                
                    if($reminder == $todayDate){
                        $data = [
                            'subject'=>'Activity ' . $broker->name . ' Reminder',
                            'greeting' => 'Dear, '. $user->name ,
                            'body' => 'You planned to make activity with broker ' . $broker->name,
                            'thanks' => 'thanks',
                        ];
                        Notification::send($user, new CommunicationReminder($data));
                    }
                }              
            }
        return 0;
    }
}