<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */

    protected $commands = [
        Commands\DelayLead::class,
        Commands\TicketDeadline::class,
        Commands\CommunicationReminder::class,
        // Commands\HideItems::class,
    ];


    protected function schedule(Schedule $schedule)
    {
        $schedule->command('delay:lead')->everyMinute();
        $schedule->command('ticket:deadline')->everyMinute();
        $schedule->command('communication:reminder')->everyMinute();
        $schedule->command('leads:auto-distribute')->hourly();
        // $schedule->command('Hide:Item')->everyMinute();

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
